#pragma once
#include "mbed.h"
#define MAXGAITS 10

class fishgait
{
protected:
    Timer* t;
public:
    fishgait(); //give the constructor a timer to use
    ~fishgait();
    void setTimer(Timer* tObject); //give the instance a timer to base its calculations off of instead of making a new one
    virtual float compute()=0; //asbtract function to compute output duty cycle. Must redefine in child classes
};
/*
class mixedGait : public fishgait
{
    private:
    fishgait gaits[MAXGAITS];
    float weights[MAXGAITS];
    int count;
    public:
    mixedGait();
    void attach(fishgait gait, float weight); //gait to attach and its weight in the overall result. weights will be normalized
    float compute(); //return the mixed signal pattern
};
*/
class triangleGait: public fishgait
{
private:
    float frq;
    float amp;
public:
    triangleGait(float freq, float amplitude);
//~triangleGait();
    float compute(); //this does a triangle wave pattern. frequency and amplitude controlled
};

class squareGait: public fishgait
{
private:
    float frq;
    float amp;
public:
    squareGait(float freq, float amplitude);
//~triangleGait();
    float compute(); //this does a triangle wave pattern. frequency and amplitude controlled
};

class sawGait: public fishgait
{
private:
    float frq;
    float amp;
public:
    sawGait(float freq, float amplitude);
//~triangleGait();
    float compute(); //this does a triangle wave pattern. frequency and amplitude controlled
};