#ifndef MBED_MAINCONTROLLER_H
#define MBED_MAINCONTROLLER_H
 
#include "mbed.h"
#include "esc.h"

#define MATH_PI 3.14159265359
#define TOFF 0.03
class MainController {
public:
    /** Create a MainController
     *
     * @param 
     */ 
    MainController() ;
    
    /** Start the main controller
     * @returns 
     */
    void start();
    float getDutyCycle();
    float getAmplitude();

    /** Stop the main controller
     * @returns 
     */
    void stop();
    
protected:        
    void control();
    //float calculateAdj();
    float signum(float input);
    float saturate(float input);
    
private:
    ESC esc1;
    
    Timer timer1;
    Ticker ticker1;
    float amp;
    float dutyCycle;
    float curTime;
    float frqMin;
    float frqMax;    
    PwmOut myled;
    AnalogIn mypotentiometer;
    
};
 
#endif