#include "MainController.h"

MainController::MainController()
    :esc1(p25),
    myled(LED1),
    mypotentiometer(p20)
{
    wait_ms(50);
    amp = 0.0;
    frqMin = 0.8; //hardcoded
    frqMax = 1.8; //hardcoded
    dutyCycle = 0.5;
    esc1 = dutyCycle;
    esc1();
    wait_ms(3000); //to arm brushless motor

}

void MainController::control()
{
    amp = mypotentiometer.read();
    myled = amp;
        
    curTime = timer1.read();
    
    //set brushless motor speed
    dutyCycle = 0.5 + (amp/2); 
    esc1.setThrottle(dutyCycle);
    esc1.pulse();
}

//float MainController::calculateAdj()
//{
//    return (ch4.dutycyclescaledup());
//}

void MainController::start()
{
    timer1.start();

    ticker1.attach(this, &MainController::control,0.001);
}

void MainController::stop()
{
    timer1.stop();
    ticker1.detach();
    dutyCycle = 0.5;
    esc1 = dutyCycle;
    esc1();
}

float MainController::getDutyCycle()
{
    return dutyCycle;
}

float MainController::getAmplitude()
{
    return amp;
}

//signum function
float MainController::signum(float input) //gives back the sign
{
    if (input>0.0)
        return 1.0;
    else if (input<0.0)
        return (-1.0);
    else
        return 0.0;
}

//saturate function
float MainController::saturate(float input) //saturates a value at 1.0 or -1.0
{
    if (input > 1.0)
        return (1.0);
    else if (input < -1.0)
        return (-1.0);
    else
        return input;
}