/*
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.

  * Demo Program
  * for Pressure Sensors of type MS5803-x of MEAS Switzerland     (www.meas-spec.com).
  * The driver uses I2C mode (sensor's Protocol Select (PS) pin pulled to high). 
  * MS5803-01BA (Barometer Sensor (Altimeter)) was successfully tested by Raig Kaufer.
  * MS5803-14BA (Underwater Pressure Sensor 14 bar) was successfully tested by Robert Katzschmann
  * Other types of MEAS are compatible but not tested 
  * Written by Raig Kaufer, distribute freely!
  * Revised by Robert Katzschmann
 */

#include "mbed.h"
#include "MS5803.h"

#define debug
#ifdef debug

Serial pc(USBTX, USBRX);
#endif

MS5803     press_sensor( p9, p10, ms5803_addrCH );           // sda, scl, I2C_address 
                                                             // I2C_address: ms5803_addrCH (0x76) or ms5803_addrCL (0x77)
                                                             // see also at MS5803.h

int main() {

#ifdef debug
        wait( 3 );
        pc.printf("MS5803 demo\r\n");
#endif

    while ( 1 ) {
#ifdef debug
        press_sensor.Barometer_MS5803();
        pc.printf("%4.1f (mBar)\r\n", press_sensor.MS5803_Pressure());
        pc.printf("%4.1f (deg C)\r\n", press_sensor.MS5803_Temperature());
#endif

        wait( 1 );
    }
}
