#include "mbed.h"
#include "I2C_SSD1306Z.h" 
#include "BME280.h"
#include "setwifi.h"


RawSerial pc(USBTX, USBRX); // tx, rx 
I2C i2c(I2C_SDA, I2C_SCL);
I2C bme(PB_3, PB_10);
BME280 sensor(bme, DEFAULT_SLAVE_ADDRESS); 
ESP8266Interface wi_fi(PA_11, PA_12, D0, "ittraining402","itstudent"); // tx, rx 

const char* TEST_SERVER_ADDRESS = "192.168.2.65";
const int TEST_SERVER_PORT = 8889;



int main()
{
    pc.baud(115200);
    char tbuffer[50], hpbuffer[50], hbuffer[50];
    printf("init oled\r\n");
    Init_LCD();
    clear_LCD();
    TCPSocketConnection socket;
    
    if((setwifi(&wi_fi)) != 0)
        printf("wifi not connect\r\n");
 
  while (1) {
     

     
     sprintf(tbuffer, "Temp: %2.2f degC", sensor.getTemperature());
     sprintf(hpbuffer, "P: %4.2f hPa", sensor.getPressure());
     sprintf(hbuffer, "Hum: %2.2f %%", sensor.getHumidity()); 
     
     tbuffer[strlen(tbuffer)] = '\0';
     hpbuffer[strlen(hpbuffer)] = '\0';
     hbuffer[strlen(hbuffer)] = '\0';
     
     print_Line(0, tbuffer);
     print_Line(1, hpbuffer);
     print_Line(2, hbuffer);
     
     
    if(socket.is_connected() != true)
    {
        while (socket.connect(TEST_SERVER_ADDRESS, TEST_SERVER_PORT) < 0) {
            pc.printf("Unable to connect to (%s) on port (%d)\n", TEST_SERVER_ADDRESS, TEST_SERVER_PORT);
            wait(1);
        }
    }
    char endl[5] = " \r\n";
    strcat(tbuffer, endl);
    strcat(hpbuffer, endl);
    strcat(hbuffer, endl);
   
   
    socket.send_all(tbuffer, strlen(tbuffer));
    socket.send_all(hpbuffer, strlen(hpbuffer));
    socket.send_all(hbuffer, strlen(hbuffer));
    
    //printf("%s%s%s", tbuffer, hpbuffer, hbuffer);
   
    /*char rev[1024]; 
    socket.receive(rev, 1024);
    printf("%s\r\n", rev);*/
    
    
    
    wait(1);
    clear_LCD();
    wait(0.5);
  

   }
      socket.close();
}


