#include "mbed.h"
#include "MMA8451Q.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1) // accel address

Serial pc(USBTX,USBRX);

// accel comes from MMA8451Q.CPP library 
struct xyz{
    float x;
    float y;
    float z;
};



void read_accel(struct xyz *data, MMA8451Q acc);
void set_color(struct xyz *data);
void send_data(struct xyz *data);


int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS); // PTE25, PTE24 
    PwmOut rled(LED1); // 
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    float x = abs(acc.getAccX());

    //printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) 
    {
        struct xyz data;
        read_accel(&data, acc);
        /*set_color(&data);*/
        send_data(&data);
        wait_ms(50);
    }
}

void send_data(struct xyz *data){
 pc.printf("X = %f1.3,", data->x);
 pc.printf("Y = %f1.3,", data->y);
 pc.printf("Z = %f1.3 \r\n", data->z);   
}

void read_accel(struct xyz *data, MMA8451Q acc)
{
    data->x = abs(acc.getAccX());
    data->y = abs(acc.getAccY());
    data->z = abs(acc.getAccZ());
    
}


/*void set_color(struct *xyz data)
{
    rled = 1.0f - data->x;
    gled = 1.0f - data->y;
    bled = 1.0f - data->z;
}*/






