/**
 **************************
 * @file    main.cpp
 * @author  Davide Aliprandi, STMicroelectronics
 * @version V1.0.0
 * @date    October 14th, 2015
 * @brief   mbed test application for the STMicroelectronics X-NUCLEO-IHM01A1
 *          Motor Control Expansion Board: control of 2 motors.
 **************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************
 */


/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"

/* Helper header files. */
#include "DevSPI.h"

/* Component specific header files. */
#include "L6474.h"
#define DELAY_3 6000

/* Definitions ---------------------------------------------------------------*/

/* Number of steps. */
#define STEP_1 (3600)
#define STEP_2 (1500)

/* Delay in milliseconds. */



/* Speed in pps (Pulses Per Second).
   In Full Step mode: 1 pps = 1 step/s).
   In 1/N Step Mode:  N pps = 1 step/s). */
#define SPEED_1 4800
Serial Serial1(PB_6,PB_7);
Serial pc(USBTX,USBRX);
char anglex[256];
char angley[256];
char dist[256];
float X,Y;
char m;
int D;
int differenza=0;
int precedente=0;
int j=0;
int g=0;
int C=0;
int i=0;
int k=0;
int B=0;
int appoggio=0;
int re=0;
/* Variables -----------------------------------------------------------------*/
L6474_init_t init = {
    1000,                              /* Acceleration rate in pps^2. Range: (0..+inf). */
    160,                              /* Deceleration rate in pps^2. Range: (0..+inf). */
    10000,                             /* Maximum speed in pps. Range: (30..10000]. */
    3200,                              /* Minimum speed in pps. Range: [30..10000). */
    3000,                              /* Torque regulation current in mA. Range: 31.25mA to 4000mA. */
    L6474_OCD_TH_3750mA,               /* Overcurrent threshold (OCD_TH register). */
    L6474_CONFIG_OC_SD_ENABLE,        /* Overcurrent shutwdown (OC_SD field of CONFIG register). */
    L6474_CONFIG_EN_TQREG_TVAL_USED,  /* Torque regulation method (EN_TQREG field of CONFIG register). */
    L6474_STEP_SEL_1_8,               /* Step selection (STEP_SEL field of STEP_MODE register). */
    L6474_SYNC_SEL_1_2,               /* Sync selection (SYNC_SEL field of STEP_MODE register). */
    L6474_FAST_STEP_12us,             /* Fall time value (T_FAST field of T_FAST register). Range: 2us to 32us. */
    L6474_TOFF_FAST_8us,              /* Maximum fast decay time (T_OFF field of T_FAST register). Range: 2us to 32us. */
    3,                                /* Minimum ON time in us (TON_MIN register). Range: 0.5us to 64us. */
    21,                               /* Minimum OFF time in us (TOFF_MIN register). Range: 0.5us to 64us. */
    L6474_CONFIG_TOFF_044us,          /* Target Swicthing Period (field TOFF of CONFIG register). */
    L6474_CONFIG_SR_320V_us,          /* Slew rate (POW_SR field of CONFIG register). */
    L6474_CONFIG_INT_16MHZ,           /* Clock setting (OSC_CLK_SEL field of CONFIG register). */
    L6474_ALARM_EN_OVERCURRENT |
    L6474_ALARM_EN_THERMAL_SHUTDOWN |
    L6474_ALARM_EN_THERMAL_WARNING |
    L6474_ALARM_EN_UNDERVOLTAGE |
    L6474_ALARM_EN_SW_TURN_ON |
    L6474_ALARM_EN_WRONG_NPERF_CMD    /* Alarm (ALARM_EN register). */
};
/* Motor Control Component. */
L6474 *motor1;




//RICORDA 15V per l'alimentazione collega le alimentazioni con un GND sul COM e l'altro GND sul meno

 
/* Main ----------------------------------------------------------------------*/

int main()
{
    
   
    /*----- Initialization. -----*/

    /* Initializing SPI bus. */
    DevSPI dev_spi(D11, D12, D13);

    /* Initializing Motor Control Components. */
    motor1 = new L6474(D2, D8, D7, D9, D10, dev_spi);
       if (motor1->init(&init) != COMPONENT_OK) {
        exit(EXIT_FAILURE);
    }

  /*   motor1->set_max_speed(1000);
    motor1->run(StepperMotor::FWD);
    motor1->wait_while_active(); */
    
    while(1){
 
   /*     if (!motor1->set_step_mode((StepperMotor::step_mode_t) STEP_MODE_1_16)) {
        printf("    Step Mode not allowed.\r\n");
    }*/
   //motor1->move(StepperMotor::FWD, 7000);
    motor1->set_max_speed(3200); //1600 fa un giro al secondo
    motor1->run(StepperMotor::FWD);
    int speed = motor1->get_speed();

    /* Printing to the console. */
    
    // Waiting while the motor is active. 
    //motor1->wait_while_active();
    wait(300);//5 minuti 300
    printf("    Speed: %d.\r\n", speed);
    printf("primo\r\n");
    //motor1->set_max_speed(6000);
    //motor1->run(StepperMotor::FWD);
    //wait_ms(8000);
   //printf("secondo\r\n");
   //motor1->go_to(7000);
    //          printf("giro\r\n");
              
    //  motor1->wait_while_active();
    }

 
        
       
    }