//EDITS
//changed the initial remainder from 0x0000 to 0xffff according to the standards
//made two seperate functions crc16_gen and crc8_gen

#define TOPBIT16 (1 << 15)
#define TOPBIT8 (1 << 7)
#define POLYNOMIAL16 0x1021
#define POLYNOMIAL8 0xEA

namespace CRC
{
     typedef uint16_t crctype16; 
    crctype16 crc16_gen(const unsigned char message[], unsigned int nBytes)
        {
            crctype16 remainder = 0xffff;
            int byte;
            char bit;
        
            for( byte = 0 ; byte < nBytes ; byte++ )
                {
                    /*
                    Bring the data byte by byte
                    each time only one byte is brought
                    0 xor x = x
                    */
                    remainder = remainder ^ ( message[byte] << 8 );
            
                    for( bit = 8 ; bit > 0 ; bit--)
                        {
                            /*
                            for each bit, xor the remainder with polynomial
                            if the MSB is 1
                            */
                            if(remainder & TOPBIT16)
                                {
                                    remainder = (remainder << 1) ^ POLYNOMIAL16;
                                    /*
                                    each time the remainder is xor-ed with polynomial, the MSB is made zero
                                    hence the first digit of the remainder is ignored in the loop
                                    */
                                }
                            else
                                {
                                    remainder = (remainder << 1);
                                }
                        }           
                }
        
            return remainder;
        }

  
    typedef uint8_t crctype8;
    crctype8 crc8_gen(const unsigned char message[], unsigned int nBytes)
        {
            crctype8 remainder = 0xff;
        
            for(int byte = 0 ; byte < nBytes ; byte++ )
                {
                    /*
                    Bring the data byte by byte
                    each time only one byte is brought
                    0 xor x = x
                    */
                    remainder = remainder ^ ( message[byte] );
            
                    for(int bit = 8 ; bit > 0 ; bit--)
                        {
                            /*
                            for each bit, xor the remainder with polynomial
                            if the MSB is 1
                            */
                            if(remainder & TOPBIT8)
                                {
                                    remainder = (remainder << 1) ^ POLYNOMIAL8;
                                    /*
                                    each time the remainder is xor-ed with polynomial, the MSB is made zero
                                    hence the first digit of the remainder is ignored in the loop
                                    */
                                }
                            else
                                {
                                    remainder = (remainder << 1);
                                }
                        }
                }
        
            return remainder;
        }
}