#include "BCN.h"
#include "EPS.h"
#include <stdio.h>
#include "pin_config.h"
//Check the pin names
//Takes max 4 sec in void FCTN_BCN_TX_MAIN() (temp.calc. + long_beacon + short_beacon) 

Timer timer_Init_BEACON_HW;
Timer timer_Set_BCN_TX_STATUS_DISABLED;
Timer timer_Set_BCN_TX_STATUS_SUSPENDED;
Timer timer_Set_BCN_TX_STATUS_RF_SILENCE;
Timer timer_Set_BCN_TX_STATUS_SUCCESS;
Timer timer_Set_BCN_TX_STATUS_FAILURE;

extern BAE_HK_actual actual_data;

Serial pc_bcn(USBTX, USBRX);        //tx,rx //see if it creates a problem
//SPI spi(D11, D12, D13);              // mosi, miso, sclk 
//DigitalOut cs(D10);                //slave select or chip select
SPI spi(PIN16, PIN17, PIN15);              // mosi, miso, sclk 
DigitalOut cs(PIN6);                //slave select or chip select
Timer t_i;//timer for checking the time taken by (temp.calc. + long_beacon + short_beacon)
//Timer t_is;//timer for short_beacon
//Timer t_il;//timer for long_beacon
Timeout rf_sl_timeout;//RF_silence timer
Ticker loop;//for transmitting every 10 secs

//GLOBAL VARIABLES
uint8_t BCN_INIT_STATUS = 0;
uint8_t BCN_TX_MAIN_STATUS = 0;
uint8_t BCN_TX_STATUS = BCN_RF_SILENCE;
//uint8_t BCN_TX_ENABLE = 1;              //hardcoding for now    //check where is this variable toggled??
uint8_t BCN_TX_SW_STATUS = 1;
uint8_t BCN_FEN = 0;                //hardcoding for now    //write this value to flash
uint8_t BCN_SPND_TX = 0;            //hardcoding for now    //check where is this variable toggled??
uint8_t BCN_TMP = 5;          // For Temperature
uint8_t ERROR_CHECK = 0;
uint8_t BCN_FAIL_COUNT = 0;         //Flag for keeping count of no. of times of BCN failure in init or one transmission in 30 secs (failure in spi communication)
                                    //This Flag when exceeds a threshold, uC should reset.
uint16_t BCN_TX_MAIN_COUNTER = 0;
uint8_t SHORT_HK_data[15];
extern uint8_t BCN_LONG_MSG_TYPE;
extern uint8_t LONG_HK_data[2][134];
extern DigitalOut BCN_SW;
extern float EPS_BTRY_TMP_AVG;

extern BAE_HK_quant quant_data;
extern uint8_t BAE_RESET_COUNTER;
extern Timer BAE_uptime;
extern Timer I2C_last;
extern void RETURN_UPTIME(float,uint8_t*,uint8_t*,uint8_t*);
extern DigitalIn CDMS_OC_FAULT;
extern DigitalIn EPS_CHARGER_STATUS;
extern uint8_t crc8_short();

extern uint8_t float_to_uint8(float min,float max,float val);

void SHORT_HK_data_AQ()
{   
    uint8_t days,hours,mins;//for calculating the timing data in bae i2c uptime
    
    //1st 0-7 call sign
    //SHORT_HK_data[0] _ SHORT_HK_data[6]
    SHORT_HK_data[0] = 0xF3;
    SHORT_HK_data[1] = 0x02;
    SHORT_HK_data[2] = 0xFA;
    SHORT_HK_data[3] = 0xC6;
    SHORT_HK_data[4] = 0xD4;
    SHORT_HK_data[5] = 0x28;
    SHORT_HK_data[6] = 0x8A;
    
    SHORT_HK_data[7] = quant_data.voltage_quant[15];
    SHORT_HK_data[7] = (SHORT_HK_data[7] & 0xF0) | (quant_data.current_quant[1]>>4);
    
    //taking only the most significant bits
    SHORT_HK_data[8] = actual_data.bit_data_acs_mg[0]>>8;
    SHORT_HK_data[8] = (SHORT_HK_data[8] & 0xF0) | BCN_TMP>>4;
    //SHORT_HK_data[9] = 0xFF;
    SHORT_HK_data[9] = float_to_uint8(-50,100,EPS_BTRY_TMP_AVG);
    SHORT_HK_data[9] = (SHORT_HK_data[9]&0xF0) | BAE_RESET_COUNTER>>4;
    
    
    RETURN_UPTIME(BAE_uptime.read(),&days,&hours,&mins);
    SHORT_HK_data[10] = CDMS_OC_FAULT;
    SHORT_HK_data[10] = (SHORT_HK_data[10]<<1) | 0;//receiver_oc_fault//to be diss;
    SHORT_HK_data[10] = (SHORT_HK_data[10]<<1) | ((quant_data.voltage_quant[5]>>2)&0x3C);
    SHORT_HK_data[10] = (SHORT_HK_data[10]<<2) | ((days>>3)&0x03);
    SHORT_HK_data[11] = (days<<5) | (hours&0x1F);
    
    RETURN_UPTIME(I2C_last.read(),&days,&hours,&mins);
    SHORT_HK_data[12] = EPS_CHARGER_STATUS;
    SHORT_HK_data[12] = (SHORT_HK_data[12]<<4) | (quant_data.voltage_quant[6]>>4);
    SHORT_HK_data[12] = (SHORT_HK_data[12]<<3) | (days>>2);    
    SHORT_HK_data[13] = (days<<6) | (mins&0x3F);

    SHORT_HK_data[14] = crc8_short();    
}

void FCTN_BCN_INIT()
{
    pc_bcn.printf("FCTN_BCN_INIT\n");
    BCN_INIT_STATUS = 1;
    if( BCN_TX_SW_STATUS == 0b00000001)
        {   
            timer_Init_BEACON_HW.reset();
            timer_Init_BEACON_HW.start();
            Init_BEACON_HW();
            timer_Init_BEACON_HW.stop();
        }
    else 
        {
            timer_Set_BCN_TX_STATUS_DISABLED.reset();
            timer_Set_BCN_TX_STATUS_DISABLED.start();
            BCN_TX_STATUS = BCN_TX_DISABLED;
            timer_Set_BCN_TX_STATUS_DISABLED.stop();
        }
 // if(BCN_FEN == 0)//BCN_FEN is in flash
 //     rf_sl_timeout.attach(&FCTN_BCN_FEN, RF_SILENCE_TIME);
    BCN_INIT_STATUS = 0;
}

extern uint32_t FCTN_BAE_RD_FLASH_ENTITY(uint16_t);
extern void FCTN_BAE_WR_FLASH(uint16_t ,uint32_t );

void FCTN_BCN_FEN(const void*)
{
    pc_bcn.printf("FCTN_FEN\n\r");
    BCN_FEN = 1;//write this value to flash
    uint32_t FLASH_DATA;
    FLASH_DATA = FCTN_BAE_RD_FLASH_ENTITY(0);
    FLASH_DATA = (FLASH_DATA | 0x00000800);//see if uint8 to uint32 conversion works
    FCTN_BAE_WR_FLASH(0,FLASH_DATA);
}
void FCTN_BCN_TX_MAIN()
{
    ERROR_CHECK=0;
    pc_bcn.printf("\n\nFCTN_BCN_TX_MAIN\n\r");
    t_i.start();
    int begin = t_i.read_us();
    //int begins,beginl,endl;
    int begintx,endtx;
    BCN_TX_MAIN_STATUS = 1; // tranmission started
    BCN_TX_MAIN_COUNTER++;
    pc_bcn.printf("BCN_FEN = %d\n\r",BCN_FEN);  //to be checked next time
    if(BCN_FEN == 1)
    {
        pc_bcn.printf("BCN_TX_SW_STATUS = %d\n\r",BCN_TX_SW_STATUS); // to be checked nxt time
        //if(BCN_TX_SW_STATUS == 0b00000001)
        if(BCN_TX_SW_STATUS != 0b00000000) // why have we put it as !0== why not just ==01??
        {
            timer_Init_BEACON_HW.reset();
            timer_Init_BEACON_HW.start();
            Init_BEACON_HW();
            timer_Init_BEACON_HW.stop();
            
            if( BCN_TX_STATUS == BCN_INIT_SUCCESS )
            {
                pc_bcn.printf("\n\r trying to trmntng");
                
                //Measure and store BCN temperature in BCN_TS_BUFFER
                uint8_t temp_temp = check_Temperature();
                if( temp_temp != 0xFF )
                    BCN_TMP = temp_temp;
                    
                    pc_bcn.printf("\n\rthe BCN_TMP is %d\n",temp_temp);
                pc_bcn.printf("temperature = %d\n\r",BCN_TMP);
                
                //Get BCN_HK data from BCN HW(SPI) //Store BCN_HK data in BCN_HK_BUFFER
                pc_bcn.printf("BCN_SPND_TX = %d\n\r",BCN_SPND_TX);
                if(BCN_SPND_TX == 1)
                {
                    timer_Set_BCN_TX_STATUS_SUSPENDED.reset();
                    timer_Set_BCN_TX_STATUS_SUSPENDED.start();
                    BCN_TX_STATUS = BCN_TX_SUSPENDED;
                    BCN_TX_MAIN_STATUS = 0;
                    timer_Set_BCN_TX_STATUS_SUSPENDED.stop();
                }
                else if(BCN_SW == 0)
                {
                    BCN_TX_STATUS = BCN_TX_DISABLED;
                    BCN_TX_MAIN_STATUS = 0;
                }
                else
                {       
                    //transmit short beacon and long beacon
                    begintx = t_i.read_us();
                    BCN_TX();
                    endtx = t_i.read_us();
                        
                    if(Check_ACK_RECEIVED() == 1)
                    {
                        BCN_TX_STATUS = BCN_TX_SUCCESS;
                        BCN_TX_MAIN_STATUS = 0;   
                    }
                    else if(BCN_SPND_TX == 1 )
                    {
                        timer_Set_BCN_TX_STATUS_SUSPENDED.reset();
                        timer_Set_BCN_TX_STATUS_SUSPENDED.start();
                        BCN_TX_STATUS = BCN_TX_SUSPENDED;
                        BCN_TX_MAIN_STATUS = 0;
                        timer_Set_BCN_TX_STATUS_SUSPENDED.stop();
                    }
                    else if(BCN_SW == 0)
                    {
                        BCN_TX_STATUS = BCN_TX_DISABLED;
                        BCN_TX_MAIN_STATUS = 0;
                    }
                    else
                    {
                        BCN_TX_STATUS = BCN_TX_FAILURE;
                        //BCN_FAIL_COUNT++;
                        //Init_BEACON_HW();
                        BCN_TX_MAIN_STATUS = 0;
                            
                    }
                }
            }
        }
        else
        {
            BCN_TX_STATUS = BCN_TX_DISABLED;
            BCN_TX_MAIN_STATUS = 0;
        }
    }
    else
    {
        timer_Set_BCN_TX_STATUS_RF_SILENCE.reset();
        timer_Set_BCN_TX_STATUS_RF_SILENCE.start();
        BCN_TX_STATUS = BCN_RF_SILENCE;  //Window of RF Silence: None of the Txs should be on.
        BCN_TX_MAIN_STATUS = 0;
        timer_Set_BCN_TX_STATUS_RF_SILENCE.stop();
    }
    t_i.stop();
    int end = t_i.read_us();
    pc_bcn.printf("The time required for FCTN_BCN_TX_MAIN is %d useconds\r\n", end-begin);
    pc_bcn.printf("The time required for FCTN_BCN_TX is %d useconds\r\n", endtx-begintx);
    /*
    pc_bcn.printf("The time required for Short_BCN is %d useconds\r\n", beginl-begins);
    pc_bcn.printf("The time required for Long_BCN is %d useconds\r\n", endtx-beginl);
    */    
    ERROR_CHECK = 0;
    BCN_TX_MAIN_STATUS = 0;
}

void Set_BCN_TX_STATUS(uint8_t STATUS)
{
    BCN_TX_STATUS = STATUS;
}

uint8_t check_Temperature()
{   
    uint8_t temperature;
    writereg(RF22_REG_0F_ADC_CONFIGURATION,0x00);//set ADC to temp measurement            
    writereg(RF22_REG_12_Temperature_Sensor_Calibration,0x20);//measure in degree celsius
    writereg(RF22_REG_0F_ADC_CONFIGURATION,0x80);//start adc
    wait(0.1);
    //if( readreg(RF22_REG_0F_ADC_CONFIGURATION) & 0x80 == 0x80 )
        {    
            temperature = readreg(RF22_REG_11_ADC_Value);
            temperature = (float)temperature*0.5 - 64;  //* 0.5 factor // to be checked
        }
    //else temperature = 0xFF;
   // temperature = (float)temperature*0.5 - 64;
   printf("\n\rthe vLKUE OF TEMPO %d",temperature);
    return temperature;
}

uint32_t timeout_count;
void BCN_TX() // main function for transmitting
{
    pc_bcn.printf("BCN_TX\n\r");
    
    writereg(RF22_REG_6E_TX_DATA_RATE,0x0A);
    writereg(RF22_REG_6F_TX_DATA_RATE,0x7C);//1280bps
    wait(0.02);      
                                                                           
    timeout_count = 10e5;
    clearTxBuf();     //writing data first time
    
    int byte_counter;
    uint8_t onebyte[4] = {0x81,0xA6,0xBE,0x4E};
    uint8_t zerobyte[4] = {0x7E,0x59,0x41,0xB1};
    for (byte_counter = 0; byte_counter <15 ; byte_counter++) // include condition in the foor loop itself
    {
         if(BCN_SPND_TX == 1) 
            {
             clearTxBuf();
             break;                                  //Check for flag update by COM
            } 
         else if( BCN_SW == 0 ) break;
         for(int j = 7; j >= 0; j--)
        {
            if(BCN_SPND_TX == 1) 
             {
                 clearTxBuf();
                 break;                                  //Check for flag update by COM
             }  
            else if( BCN_SW == 0 ) break;
            cs = 0;
            spi.write(0xFF);
            if((SHORT_HK_data[byte_counter] & (uint8_t) pow(2.0,j))!= pow(2.0,j))
            {
                //byte=0x00;
                spi.write(zerobyte[0]);
                spi.write(zerobyte[1]);
                spi.write(zerobyte[2]);
                spi.write(zerobyte[3]);
            }
            else
            { 
                //byte=0xFF;
                spi.write(onebyte[0]);
                spi.write(onebyte[1]);
                spi.write(onebyte[2]);
                spi.write(onebyte[3]);
            } 
            cs = 1;
            /*
            spi.write(byte);
            spi.write(byte);
            spi.write(byte);
            spi.write(byte); //Each bit is written 32 times
            */
           // byte_count+=4;
        
        }     
        
        if(byte_counter == 1)
            if(BCN_SPND_TX != 1 && BCN_SW == 1)                                  //Check for flag update by COM
            {          
                //Set to Tx mode
                writereg(RF22_REG_07_OPERATING_MODE1,0x08);       //txon
                wait(0.1);// takes time to set to tx mode hence the delay of 0.1.  
            }
        
        //testing level
        /*if(byte_counter > 0)
        while(1)if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x40) == 0x00)break;else
        {
            pc_bcn.printf("w_f_empty1\n\r");
            //reset_rfm(1);
        }*/
        
        
        //Check for fifoThresh
        
        if(byte_counter > 0)
            if(BCN_SPND_TX != 1 && BCN_SW ==1)                                  //Check for flag update by COM
            {
                wait_ms(25);
                while( timeout_count --)if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x20) == 0x20)break;else if(timeout_count == 1) reset_rfm(1);
                {                      
                    //pc_bcn.printf("w_f_empty\n");
                    //reset_rfm(1);
                }
                timeout_count = 10e5;
            }
                
       /* if(byte_counter%2==0 && byte_counter)
        while(1)if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x40) == 0x00)break;else 
        {
            pc_bcn.printf("W = %d\r\n",byte_counter);
        }*/
            //pc_bcn.printf("W = %d\r\n",byte_counter);    
    }   
    
    for(byte_counter = 15;byte_counter<149;byte_counter++) // include it in the loop itself
    {
        if(BCN_SPND_TX == 1) 
        {
             clearTxBuf();
             break;                                  //Check for flag update by COM
        } 
        else if( BCN_SW == 0 ) break;
        cs = 0;
        spi.write(0xFF);   
        spi.write(LONG_HK_data[BCN_LONG_MSG_TYPE][byte_counter-15]);
        cs = 1;
        
        if((byte_counter-15)%32==0 && BCN_SPND_TX == 0 && BCN_SW == 1)
        {   //Check for fifoThresh
            wait_ms(25);
            while(timeout_count--)if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x20) == 0x20)break;else if(timeout_count == 1) reset_rfm(1); 
            {
                //pc_bcn.printf("Reset\n");
                //reset_rfm(1);
            }
        }
        
    }
    wait_ms(70);
    
    if( BCN_SW == 1 )
    {
        //Check for fifoThresh
        while(timeout_count--)
            if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x40) == 0x00) break;
            else if(timeout_count == 1)
                if(BCN_SPND_TX != 1) reset_rfm(1);
        
        while(timeout_count--)if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x40) == 0x00)break;else if(timeout_count == 1) reset_rfm(1);
        {
            pc_bcn.printf("Waiting for fifo to empty\r\n");
        }
        
        //Check for packetsent interrupt
        while(timeout_count--)
            if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x04) == 0x04) break;
            else if(timeout_count == 1)
                if(BCN_SPND_TX != 1) reset_rfm(1);
        
        while(timeout_count--)if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x04) == 0x04)break;else if(timeout_count == 1) reset_rfm(1);
        
        //pc_bcn.printf("Short packet sent, bytes written = %d\r\n",byte_count);
        
        writereg(RF22_REG_07_OPERATING_MODE1,0x00);        //standby mode
    }
}

void reset_rfm(uint8_t fl)
{
    if (fl ==1 && ERROR_CHECK ==0)  
    {   BCN_FAIL_COUNT++;
        ERROR_CHECK=1;
        pc_bcn.printf("BCN_FAIL_COUNT+++\n");
    }
    else if(fl == 0)
    {
        BCN_FAIL_COUNT = 0;
        ERROR_CHECK=0;
    }
}
void writereg(uint8_t reg,uint8_t val)
{
    
    uint8_t count = 0; 
    for(;;count++)
    {
        int read_val =0; cs = 0;spi.write(reg | 0x80);spi.write(val);cs = 1;
        if(reg != 0x7 && reg != 0x58 && reg != 0xF) 
        {        
            read_val = readreg(reg);
            if (read_val == val)
            {
                break;    
            }
            else if(count == 2)
            {
                reset_rfm(1); pc_bcn.printf("reg = 0x%X\n",reg);break;
            }
            else init_spi();
        }
        else
        break;
    }
}   
uint8_t readreg(uint8_t reg)
{
    uint8_t val;cs = 0;spi.write(reg & ~0x80);val = spi.write(0);cs = 1;return val;
}
void clearTxBuf()
{
    writereg(RF22_REG_08_OPERATING_MODE2,0x01);
    writereg(RF22_REG_08_OPERATING_MODE2,0x00);
}
uint8_t setFrequency(double centre)
{
    uint8_t fbsel = 0x40;
    if (centre >= 480.0) {
        centre /= 2;
        fbsel |= 0x20;
    } 
    centre /= 10.0;
    double integerPart = floor(centre);
    double fractionalPart = centre - integerPart;
 
    uint8_t fb = (uint8_t)integerPart - 24; // Range 0 to 23
    fbsel |= fb;
    uint16_t fc = fractionalPart * 64000;
    writereg(RF22_REG_73_FREQUENCY_OFFSET1, 0);  // REVISIT
    writereg(RF22_REG_74_FREQUENCY_OFFSET2, 0);
    writereg(RF22_REG_75_FREQUENCY_BAND_SELECT, fbsel);
    writereg(RF22_REG_76_NOMINAL_CARRIER_FREQUENCY1, fc >> 8);
    writereg(RF22_REG_77_NOMINAL_CARRIER_FREQUENCY0, fc & 0xff);
    return 0;
}
void init_spi()
{
    cs=1;                          // chip must be deselected
    wait(0.1);
    spi.format(8,0);
    spi.frequency(10000000);       //10MHz SCLK
}
void Init_BEACON_HW()
{
    pc_bcn.printf("Init HW\n\r");
    ERROR_CHECK=0;
    wait(0.1);
    int BCN_INIT_COUNTER = 1;
    while(BCN_INIT_COUNTER)
    {
        init_spi();
        pc_bcn.printf("init spi\r\n");
        //should either have a flag for invalid SPI or discard this for actual case or add reset
        if (readreg(RF22_REG_00_DEVICE_TYPE) == 0x08)
        {
            pc_bcn.printf("spi connection valid\r\n");
            reset_rfm(0);
            
            timer_Set_BCN_TX_STATUS_SUCCESS.reset();
            timer_Set_BCN_TX_STATUS_SUCCESS.start();
            BCN_TX_STATUS = BCN_INIT_SUCCESS;
            timer_Set_BCN_TX_STATUS_SUCCESS.stop();
            
            break;
        }
        else if (BCN_INIT_COUNTER == 1)
        {
            pc_bcn.printf("error in spi connection\r\n");
            reset_rfm(1);
            writereg(RF22_REG_07_OPERATING_MODE1,0x80);        //sw_reset
            wait(0.1);                                         //takes time to reset          
        }
        else if (BCN_INIT_COUNTER == 2)
        {
            pc_bcn.printf("error in spi connection\r\n");
            reset_rfm(1);
            BCN_TX_SW_STATUS = 0b00000011;                      //Device disabled
            //reset BCN HW using switch here
        }
        else 
        {
            pc_bcn.printf("BCN_TX_FAILURE\r\n");
            
            timer_Set_BCN_TX_STATUS_FAILURE.reset();
            timer_Set_BCN_TX_STATUS_FAILURE.start();
            BCN_TX_STATUS = BCN_INIT_FAILURE;
            timer_Set_BCN_TX_STATUS_FAILURE.stop();
            
            break;
        }
        BCN_INIT_COUNTER++;
    }
    
    if(BCN_TX_STATUS == BCN_INIT_SUCCESS)
    {
        writereg(RF22_REG_07_OPERATING_MODE1,0x80);        //sw_reset
        wait(0.1);                    //takes time to reset                                  
    
        clearTxBuf();                                                                                                                        
        
        writereg(RF22_REG_07_OPERATING_MODE1,0x00);        //standby mode
           
        //txfifoalmostempty
        writereg(RF22_REG_7D_TX_FIFO_CONTROL2,30);
        
        //txfifoalmostfull
        writereg(RF22_REG_7C_TX_FIFO_CONTROL1,50);
        
    
        //Packet-engine registers
        writereg(RF22_REG_30_DATA_ACCESS_CONTROL,0x00); 
        
        writereg(RF22_REG_33_HEADER_CONTROL2,0x08);    
        writereg(RF22_REG_34_PREAMBLE_LENGTH,0x00);       
    
        writereg(RF22_REG_0B_GPIO_CONFIGURATION0,0x15); // TX state                        
        writereg(RF22_REG_0C_GPIO_CONFIGURATION1,0x12); // RX state                        
    
        setFrequency(435.0);
        
        int i=3;
        while(i--)
        if((readreg(RF22_REG_02_DEVICE_STATUS)& 0x08)!= 0x00)
            {
                setFrequency(435.0);
                if (i==1)
                {pc_bcn.printf("frequency not set properly\r\n");
                 reset_rfm(1);
                }
            }
    
        //set Modem Configuration
        writereg(RF22_REG_58,0x80);
        
        //Set Data rate - same for both long and short beacon
        
        writereg(RF22_REG_6E_TX_DATA_RATE,0x0A);
        writereg(RF22_REG_6F_TX_DATA_RATE,0x7C);//1280bps 
        writereg(RF22_REG_70_MODULATION_CONTROL1,0x20);//For data rates below 30kbps
        
          
        writereg(RF22_REG_71_MODULATION_CONTROL2,0x21);//0x21 = FIFO mode with ook demodulation
         
        
        //set tx power
        writereg(RF22_REG_6D_TX_POWER,0x07);    //20dbm
        
        //TX_packet_length written later
        ERROR_CHECK = 0;
        pc_bcn.printf("Done Init HW\n\r");
    }
}
bool Check_ACK_RECEIVED()
{
    if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x04) == 0x04)  
    {
        pc_bcn.printf("Packet sent: ACK received\r\n");
        return 1;   
    }
    else
    {
        pc_bcn.printf("Packet not sent\r\n");
        return 0;
    }
}

// to write in flash function moved to TCTM
void  FCTN_BCN_SPND_TX()
{
     printf("BCN_SPND\n\r");
     BCN_SPND_TX = 1;
     if( BCN_TX_MAIN_STATUS == 1 && BCN_TX_SW_STATUS == 1 )
     {
         writereg(RF22_REG_07_OPERATING_MODE1,0x00);        //standby mode
         if( readreg(RF22_REG_07_OPERATING_MODE1) & 0x08 == 0x08 )
         {
             BCN_SW = 0;                //active high
             BCN_TX_SW_STATUS = 3;
         }
     }
}

/*
int main()
{
    FCTN_BCN_INIT(); 
    
    loop.attach(&FCTN_BCN_TX_MAIN, 10.0);//in actual case its 30.0
    
    while(1);
    
}
*/