#include "mbed.h"
#include "rtos.h"
#include "pin_config.h"
#include "ACS.h"
#include "EPS.h"
#include "BCN.h"
#include "TCTM.h"

#define tm_len 134
#define tc_len 135
#define batt_heat_low 20
//***************************************************** flags *************************************************************//
uint32_t BAE_STATUS = 0x00000000;
uint32_t BAE_ENABLE = 0xFFFFFFFF;

//i2c//
char data_send_flag = 'h'; 

//.........acs...............//
char ACS_INIT_STATUS = 'q';
char ACS_DATA_ACQ_STATUS = 'q';
char ACS_ATS_STATUS = 'q';
char ACS_MAIN_STATUS = 'q';
char ACS_STATUS = 'q';

char ACS_ATS_ENABLE = 'q';
char ACS_DATA_ACQ_ENABLE = 'q';
char ACS_STATE = 'q';

//.....................eps...................//
//eps init
char EPS_INIT_STATUS = 'q';
char EPS_BATTERY_GAUGE_STATUS = 'q';
//eps main
char EPS_MAIN_STATUS = 'q';
char EPS_BATTERY_TEMP_STATUS = 'q';
char EPS_STATUS = 'q';

char EPS_BATTERY_HEAT_ENABLE = 'q';

//.......................global variables..................................................................// new hk structure- everything has to changed based on this
uint8_t BAE_data[74];  
char BAE_chardata[74];     
    

//*************************************Global declarations************************************************//
const int addr = 0x20;                                            //slave address 

Timer t_rfsilence;
Timer t_start;
Timer t_tc;
Timer t_tm;
Serial pc(USBTX, USBRX);
int power_flag_dummy=2;
float data[6];

extern float moment[3];
extern uint8_t BCN_FEN;
extern BAE_HK_actual actual_data;
extern BAE_HK_quant quant_data;
extern BAE_HK_min_max bae_HK_minmax;
extern BAE_HK_arch arch_data;

int write_ack = 1;
int read_ack = 1;
char telecommand[tc_len];
char* telemetry;

bool pf1check = 0;
bool pf2check = 0;
bool if1check = 0;
bool if2check = 0;

//*****************************************************Assigning pins******************************************************//
DigitalOut gpo1(PTC0); // enable of att sens2 switch
DigitalOut gpo2(PTC16); // enable of att sens switch
InterruptIn irpt_4m_mstr(PIN38);                                      //I2c interrupt from CDMS
DigitalOut irpt_2_mstr(PIN4);                                        //I2C interrupt to CDMS
I2CSlave slave (PIN1,PIN2);
DigitalOut batt_heat(PIN96);

//gpo1 = 0;
PwmOut PWM1(PIN93); //x                         //Functions used to generate PWM signal 
PwmOut PWM2(PIN94); //y
PwmOut PWM3(PIN95); //z                         //PWM output comes from pins p6

//........faults
//Polled Faults
DigitalIn pf1(PIN5);//Attitude Sensor 1 OC bar fault signal
DigitalIn pf2(PIN97);//Attitude Sensor 2 OC bar fault signal
DigitalIn pf3(PIN83);//Fault Bar for TRXY driver
 
//Interrupt based faults
//InterruptIn  ir1(PIN73);//Battery Gauge - Alert Bar Signal
InterruptIn  ir2(PIN72);//TRXY Driver TR switch Fault
InterruptIn  ir3(PIN89);//TRZ Driver Fault Bar
InterruptIn  ir4(PIN91);//TRZ Driver TR switch Fault
InterruptIn  ir5(PIN79);//CDMS - Switch Fault
InterruptIn  ir6(PIN80);//Beacon- Switch OC bar
InterruptIn  ir7(PIN42);//Charger IC - Fault Bar

DigitalOut TRXY_SW(PIN71);  //TR XY Switch
DigitalOut DRV_Z_EN(PIN88);    //Sleep pin of driver z
DigitalOut TRZ_SW(PIN40);  //TR Z Switch
DigitalOut CDMS_RESET(PIN7); // CDMS RESET
DigitalOut BCN_SW(PIN14);      //Beacon switch
DigitalOut DRV_XY_EN(PIN82);



/*****************************************************************Threads USed***********************************************************************************/

Thread *ptr_t_i2c;

/*********************************************************FCTN HEADERS***********************************************************************************/

void FCTN_ISR_I2C();
void FCTN_TM();
void F_ACS();
void F_EPS();
void F_BCN();

//*******************************************ACS THREAD**************************************************//
uint8_t iterP1;
uint8_t iterP2;
uint8_t iterI1;
uint8_t iterI2;

 
void F_ACS()
{
    if(pf1check == 1)
    {
        if(iterP1 >= 3)
        {
            gpo1 = 1;  // turn off ats1 permanently
            //FCTN_SWITCH_ATS(0);  // switch on ATS2    
        }
        else    
        {
        gpo1 = 0;
        iterP1++;
        }
    }
    if(pf2check == 1)
    {
        if(iterP1 >= 3)
        {
            gpo2 = 1;  // turn off ats2 permanently
            ACS_DATA_ACQ_ENABLE = 'd';
            ACS_STATE = '2' ; // check ACS_STATE = ACS_ZAXIS_MOMENT_ONLY    
        }
        else    
        {
        gpo2 = 0;
        iterP2++;
        }
    }
     if(if1check == 1)
    {
        if(iterI1 >= 3)
        {
            TRXY_SW = 0;  // turn off TRXY permanently
        }
        else    
        {
         TRXY_SW = 1;   //switch on TRXY
         iterI1++;
        }
    }    
    if(if2check == 1)
    {
        if(iterI2 >= 3)
        {
            TRZ_SW = 0;  // turn off TRZ permanently
            ACS_STATE = '2' ; // check ACS_STATE = ACS_ZAXIS_MOMENT_ONLY  
        }
        else    
        {
         TRZ_SW = 1;   //switch on Z
         iterI2++;
        }
    }
    
    //float b1[3]={-23.376,-37.56,14.739}, omega1[3]={-1.52,2.746,0.7629}, moment1[3]= {1.0498,-1.0535,1.3246};
    //b1[3] = {22, 22,10};
    //omega1[3] = {2.1,3.0,1.5};
    // gpo1 = 0;  // att sens2 switch is disabled
    // gpo2 = 0; // att sens switch is disabled
     
    
        
    //Thread::signal_wait(0x1);  
    ACS_MAIN_STATUS = 's'; //set ACS_MAIN_STATUS flag 
    PWM1 = 0;                     //clear pwm pins
    PWM2 = 0;                     //clear pwm pins
    PWM3 = 0;                     //clear pwm pins
    pc.printf("\n\rEntered ACS   %f\n",t_start.read());
    
    if(ACS_DATA_ACQ_ENABLE == 'e')// check if ACS_DATA_ACQ_ENABLE = 1?
    {
    FLAG();
    FCTN_ATS_DATA_ACQ(); //the angular velocity is stored in the first 3 values and magnetic field values in next 3
    pc.printf("gyro values\n\r"); //printing the angular velocity and magnetic field values
    for(int i=0; i<3; i++) 
    {
        pc.printf("%f\n\r",actual_data.AngularSpeed_actual[i]);
    }
    pc.printf("mag values\n\r");
    for(int i=0; i<3; i++) 
    {
        pc.printf("%f\n\r",actual_data.Bvalue_actual[i]);
    }
      //  for(int i=0;i<3;i++)
//    {
//    omega1[i]= data[i];
//    b1[i] = data[i+3];
//    }
    }//if ACS_DATA_ACQ_ENABLE = 1
     else
    {
        // Z axis actuation is the only final solution,
    }
    if(ACS_STATE == '0')        // check ACS_STATE = ACS_CONTROL_OFF?
    {
          printf("\n\r acs control off\n");
          FLAG();
          ACS_STATUS = '0';                // set ACS_STATUS = ACS_CONTROL_OFF
          PWM1 = 0;                     //clear pwm pins
          PWM2 = 0;                     //clear pwm pins
          PWM3 = 0;                     //clear pwm pins
    }
    else
    {
            if(actual_data.power_mode>1)
            
            {
                if(ACS_STATE == '2')   // check ACS_STATE = ACS_ZAXIS_MOMENT_ONLY 
                {
                    FLAG();
                    printf("\n\r z axis moment only\n");
                    ACS_STATUS = '2';                    // set ACS_STATUS = ACS_ZAXIS_MOMENT_ONLY   
                    //   FCTN_ACS_CNTRLALGO(b1, omega1);
                    moment[0] = 0;
                    moment[1] = 0;
                    moment[2] =1.3;// is a dummy value 
                    FCTN_ACS_GENPWM_MAIN(moment) ; 
                 }
                 else
                {
                if(ACS_STATE == '3') // check ACS_STATE = ACS_DATA_ACQ_FAILURE
                {
                     FLAG();
                     printf("\n\r acs data failure "); 
                     ACS_STATUS = '3';                    // set ACS_STATUS = ACS_DATA_ACQ_FAILURE
                        PWM1 = 0;                     //clear pwm pins
                        PWM2 = 0;                     //clear pwm pins
                        PWM3 = 0;                     //clear pwm pins
                 }
                 else
                 {
                     if(ACS_STATE == '4')       // check ACS_STATE = ACS_NOMINAL_ONLY
                        {
                            FLAG();
                            printf("\n\r nominal");
                            ACS_STATUS = '4';                    // set ACS_STATUS = ACS_NOMINAL_ONLY
                            FCTN_ACS_CNTRLALGO(actual_data.Bvalue_actual,actual_data.AngularSpeed_actual);
                            printf("\n\r moment values returned by control algo \n");
                            
                             moment[0] = 1;
                            moment[1] = 1.09;
                            moment[2] = 0.9;
                            for(int i=0; i<3; i++) 
                            {
                                printf("%f\t",moment[i]);
                            }
                            

                           FCTN_ACS_GENPWM_MAIN(moment) ;
                           //wait(2);
                            
                         //  PWM1 = 0.5;
                          //  PWM2 = 0.5;
                            //PWM3 = 0.5;   
                        }
                        else
                        {
                            if(ACS_STATE == '5')       // check ACS_STATE = ACS_AUTO_CONTROL
                            {
                                FLAG();
                                printf("\n\r auto control");
                                ACS_STATUS = '5';                    // set ACS_STATUS = ACS_AUTO_CONTROL
                                //FCTN_ACS_AUTOCTRL_LOGIC                    // gotta include this code
                            }
                            else
                            {
                                if(ACS_STATE == '6')       // check ACS_STATE = ACS_DETUMBLING_ONLY
                                {
                                    FLAG();
                                    printf("\n\r Entered detumbling \n");
                                    ACS_STATUS = '6';                    // set ACS_STATUS = ACS_DETUMBLING_ONLY  
                                    FCTN_ACS_CNTRLALGO(actual_data.Bvalue_actual,actual_data.AngularSpeed_actual);  // detumbling code has to be included
                                    FCTN_ACS_GENPWM_MAIN(moment) ; 
                                }
                                else
                                {
                                    FLAG();
                                    printf("\n\r invalid state");
                                    ACS_STATUS = '7' ;                    // set ACS_STATUS = INVALID STATE 
                                    PWM1 = 0;                     //clear pwm pins
                                    PWM2 = 0;                     //clear pwm pins
                                    PWM3 = 0;                     //clear pwm pins
                                }//else of invalid 
                            }//else of autocontrol 
                        }//else of nominal
                 }//else of data acg failure
                
                }//else fo z axis moment only
            }//if power >2
            else
            {
                FLAG();
                printf("\n\r low power");
                ACS_STATUS = '1';                    // set ACS_STATUS = ACS_LOW_POWER
                PWM1 = 0;                     //clear pwm pins
                PWM2 = 0;                     //clear pwm pins
                PWM3 = 0;                     //clear pwm pins
            }
    } //else for acs control off
    ACS_MAIN_STATUS = 'c'; //clear ACS_MAIN_STATUS flag 
        
}
//***************************************************EPS THREAD***********************************************//

void F_EPS()
{
    
        pc.printf("\n\rEntered EPS   %f\n",t_start.read());
        EPS_MAIN_STATUS = 's'; // Set EPS main status
        FCTN_BATT_TEMP_SENSOR_MAIN(actual_data.Batt_temp_actual);
          pc.printf("\n\r Battery temperature %f %f" ,actual_data.Batt_temp_actual[0], actual_data.Batt_temp_actual[1]);
          EPS_BATTERY_TEMP_STATUS = 's';          //set EPS_BATTERY_TEMP_STATUS
          if(EPS_BATTERY_HEAT_ENABLE == 'e')
          {
              if((actual_data.Batt_temp_actual[0] < batt_heat_low) && (actual_data.Batt_temp_actual[1] < batt_heat_low)) // to confirm
              {
                  batt_heat = 1;    //turn on battery heater
              }
              else
              {
                  batt_heat = 0;     //turn off battery heater
              }
              
           } 
          else if(EPS_BATTERY_HEAT_ENABLE == 'd')
          {
                EPS_STATUS = 1;//EPS_STATUS = EPS_BATTERY_HEATER_DISABLED
          }
        FCTN_BATTERYGAUGE_MAIN(actual_data.Batt_gauge_actual);
        if (actual_data.Batt_gauge_actual[1] == 200)   //data not received
        {
          actual_data.power_mode = 1;
          EPS_BATTERY_GAUGE_STATUS = 'c';           //clear EPS_BATTERY_GAUGE_STATUS
          
        }
        else
        {
          FCTN_EPS_POWERMODE(actual_data.Batt_gauge_actual[1]);            //updating power level 
          EPS_BATTERY_GAUGE_STATUS = 's';           //set EPS_BATTERY_GAUGE_STATUS
        }
       // if( Temperature data received)
        //{
          
          
      //  }
//        else
//        {
//          Set battery temp to XX  
//          EPS_BATTERY_TEMP_STATUS = 'c';          //clear EPS_BATTERY_TEMP_STATUS
//          EPS_STATUS = EPS_ERR_BATTERY_TEMP;
//        }
        FCTN_HK_MAIN();
       // printf("\n\r here");
        FCTN_APPEND_HKDATA();
        minMaxHkData();
        //printf("\n\r here");  
        EPS_MAIN_STATUS = 'c'; // clear EPS main status 

}

//**************************************************BCN THREAD*******************************************************************//

void F_BCN()
{
  
          pc.printf("\n\rEntered BCN   %f\n",t_start.read());
          
          P_BCN_TX_MAIN();
    
}

//**************************************************TCTM THREAD*******************************************************************//

void T_TC(void const * args)
{
      while(1)
    {
        Thread::signal_wait(0x4);
        wait_us(200);                                               // can be between 38 to 15700
        if( slave.receive() == 0)        
            slave.stop();     
        else if( slave.receive() == 1)                                     // slave writes to master
        {
             if(data_send_flag == 'h')
             {
                //FCTN_APPEND_HKDATA();
                // pc.printf("\n\r here");
                write_ack=slave.write(BAE_chardata,74); 
            }
            else if(data_send_flag == 't')
            {
                write_ack=slave.write(telemetry,tm_len);
                data_send_flag = 'h';
                irpt_2_mstr = 0;
            }       
        }
        else if( slave.receive()==3 ||  slave.receive()==2)             // slave read 
        {
           read_ack=slave.read(telecommand,tc_len);
           t_tc.start();
           //pc.printf("\n\rTELECOMMAND received from CDMS is %s \n",telecommand);
           pc.printf("\n\r Executing Telecommand \n"); 
           // FCTN_TC_DECODE((uint8_t*) telecommand);
           
           uint8_t* temp = FCTN_BAE_TM_TC((uint8_t*) telecommand);
           telemetry = (char*)temp;
          
           FCTN_TM();
            t_tc.stop();
           printf("\n\r time taken %d",t_tc.read_us());
            t_tc.reset();
            // for(int i = 0; i<134; i++)
            //pc.printf("%c", telemetry[i]);
        } 
       
      
    } 
}

void FCTN_TM()
{
    //irpt_2_mstr = 0; 
    data_send_flag = 't';
    pc.printf("\n\r Telemetry Generation \n");
    irpt_2_mstr = 1;   
}


//******************************************************* I2C *******************************************************************//

void FCTN_I2C_ISR()
{
     ptr_t_i2c->signal_set(0x4);
}


//***********************************************************FAULTS***************************************************************//
/*void ir1clear()
{
    actual_data.faultIr_status |= 0x01;   // alert
 
}*/


 
void ir2clear()
{
    actual_data.faultIr_status |= 0x02;
    TRXY_SW = 0;   // Switch off TR XY
    if1check = 1;
}
 
void ir3clear()
{
    actual_data.faultIr_status |= 0x04;
    DRV_Z_EN = 0;
    wait_us(1);
    DRV_Z_EN = 1;
 
}
 
void ir4clear()
{
    if2check = 1;
    actual_data.faultIr_status |= 0x08;
    TRZ_SW = 0;
}
 
void ir5clear()
{
    actual_data.faultIr_status |= 0x10;
    CDMS_RESET = 0;
    wait_us(1);
    CDMS_RESET = 1;
}
 
void ir6clear()
{
    actual_data.faultIr_status |= 0x20;
    BCN_SW = 0;
    wait_us(1);
    BCN_SW = 1;
}
 
void ir7clear()
{
    actual_data.faultIr_status |= 0x40;
}
uint8_t iter2=0,iter4 = 0; 



void pollfault()
{   
    
    
 
    if (pf1==0)                // OC_ATS1
    { 
        pf1check=1;
        actual_data.faultPoll_status |=0x01 ;
        gpo1 = 1;  // turn off ats1  // to be turned on next cycle in ACS
    }
    else actual_data.faultPoll_status &= 0xFE;
 
    if (pf2==0)
    {   
        pf2check=1;
        actual_data.faultPoll_status |=0x02 ;
        gpo2 = 1;  // turn off ats2  // turn on in ACS
    }
    else actual_data.faultPoll_status &= 0xFD;
 
    if (pf3==0)
    {   actual_data.faultPoll_status |=0x04 ;
        DRV_XY_EN = 0;
        wait_us(1);
        DRV_XY_EN = 1;
    }
    else actual_data.faultPoll_status &= 0xFB;
 
 
 
 
    /*if (ir1==1)
    {
        actual_data.faultIr_status &=0xFE;
    }*/
    if (ir2==1)
    {
        actual_data.faultIr_status &=0xFD;
    }
    if (ir3==1)
    {
        actual_data.faultIr_status &=0xFB;
    }
    if (ir4==1)
    {
        actual_data.faultIr_status &=0xF7;
    }
    if (ir5==1)
    {
        actual_data.faultIr_status &=0xEF;
    }
    if (ir6==1)
    {
        actual_data.faultIr_status &=0xDF;
    }if (ir7==1)
    {
        actual_data.faultIr_status &=0xBF;
    }
 
}
  

//------------------------------------------------------------------------------------------------------------------------------------------------
//SCHEDULER
//------------------------------------------------------------------------------------------------------------------------------------------------
uint8_t schedcount=1;
void T_SC(void const *args)
{    
    printf("\n\r in scheduler");
   
    if(schedcount == 7)                         //to reset the counter
    {
        schedcount = 1;
    }
    if(schedcount%1==0)
    {
       F_ACS();
    }
    
    if(schedcount%2==0)
    {
        //F_EPS();
    }
    if(schedcount%3==0)
    { 
       // F_BCN();
    }
    schedcount++;
    printf("\n\r exited scheduler");
}

Timer t_flag;
void FLAG()
{
    
//.............acs..................//    
    if(ACS_INIT_STATUS == 's')
        BAE_STATUS = BAE_STATUS | 0x00000080;  //set ACS_INIT_STATUS flag
    else if(ACS_INIT_STATUS == 'c')
        BAE_STATUS &= 0xFFFFFF7F;              //clear ACS_INIT_STATUS flag 
    
    if(ACS_DATA_ACQ_STATUS == 's')
        BAE_STATUS =BAE_STATUS | 0x00000100;     //set ACS_DATA_ACQ_STATUS flag
    else if(ACS_DATA_ACQ_STATUS == 'c')
        BAE_STATUS &= 0xFFFFFEFF;      //clear ACS_DATA_ACQ_STATUS flag    
    
    if(ACS_ATS_ENABLE == 'e')
        BAE_ENABLE |= 0x00000004;
    else if(ACS_ATS_ENABLE == 'd')
        BAE_ENABLE = BAE_ENABLE &0xFFFFFFFB | 0x00000004;
    
    if(ACS_DATA_ACQ_STATUS == 'f')
        BAE_STATUS |= 0x00000200;
    
    if(ACS_MAIN_STATUS == 's')
        BAE_STATUS = (BAE_STATUS | 0x00001000);     //set ACS_MAIN_STATUS flag
   else if(ACS_MAIN_STATUS == 'c')
        BAE_STATUS &= 0xFFFFEFFF;     //clear ACS_MAIN_STATUS flag 
    
    if(ACS_STATUS == '0')
        BAE_STATUS = (BAE_STATUS & 0xFFFF1FFF);                // set ACS_STATUS = ACS_CONTROL_OFF
    else if(ACS_STATUS == '1')
        BAE_STATUS =(BAE_STATUS & 0xFFFF1FFF) | 0x00002000;                    // set ACS_STATUS = ACS_LOW_POWER
    else if(ACS_STATUS == '2')
        BAE_STATUS = (BAE_STATUS & 0xFFFF1FFF)| 0x00004000;                    // set ACS_STATUS = ACS_ZAXIS_MOMENT_ONLY  
    else if(ACS_STATUS == '3') 
        BAE_STATUS = (BAE_STATUS & 0xFFFF1FFF) | 0x00006000;                    // set ACS_STATUS = ACS_DATA_ACQ_FAILURE
    else if(ACS_STATUS == '4')
        BAE_STATUS = (BAE_STATUS & 0xFFFF1FFF) | 0x00008000;                    // set ACS_STATUS = ACS_NOMINAL_ONLY
    else if(ACS_STATUS == '5')
        BAE_STATUS =(BAE_STATUS & 0xFFFF1FFF) | 0x0000A000;                    // set ACS_STATUS = ACS_AUTO_CONTROL
    else if(ACS_STATUS == '6')
        BAE_STATUS =(BAE_STATUS & 0xFFFF1FFF) | 0x0000C000;                    // set ACS_STATUS = ACS_DETUMBLING_ONLY  
    else 
        BAE_STATUS =(BAE_STATUS & 0xFFFF1FFF) | 0x0000E000;                    // set ACS_STATUS = INVALID STATE 
        
    if(ACS_STATE == '0')
        BAE_ENABLE = (BAE_ENABLE & 0xFFFFFF8F);                                         //ACS_STATE = ACS_CONTROL_OFF
    else if(ACS_STATE == '2')
        BAE_ENABLE = ((BAE_ENABLE & 0xFFFFFF8F)| 0x00000020);                              //   ACS_STATE = ACS_ZAXIS_MOMENT_ONLY  
    else if(ACS_STATE == '3')
        BAE_ENABLE = ((BAE_ENABLE & 0xFFFFFF8F)| 0x00000030);                              //  set ACS_STATUS = ACS_DATA_ACQ_FAILURE
    else if(ACS_STATE == '4')
        BAE_ENABLE = ((BAE_ENABLE & 0xFFFFFF8F)| 0x00000040);                              //  ACS_STATE = ACS_NOMINAL_ONLY
    else if(ACS_STATE == '5')
        BAE_ENABLE = ((BAE_ENABLE & 0xFFFFFF8F)| 0x00000050);                              //    ACS_STATE = ACS_AUTO_CONTROL
    else if(ACS_STATE == '6')
        BAE_ENABLE = ((BAE_ENABLE & 0xFFFFFF8F)| 0x00000060);                             //ACS_STATE = ACS_DETUMBLING_CONTROL
        
//...............eps......................//

    
if (EPS_INIT_STATUS=='s')                                  // Set EPS_INIT_STATUS
    BAE_STATUS |= 0x00010000;                     
else if(EPS_INIT_STATUS=='c')                              // Clear
    BAE_STATUS &= 0xFFFEFFFF;


if (EPS_MAIN_STATUS=='s')                              // Set EPS_MAIIN_STATUS
    BAE_STATUS |= 0x00040000;
else if(EPS_MAIN_STATUS=='c')                          // Clear
    BAE_STATUS &= 0xFFFBFFFF;


if (EPS_BATTERY_GAUGE_STATUS=='s')              // Set EPS_BATTERY_GAUGE_STATUS
    BAE_STATUS |= 0x00020000;
else if(EPS_BATTERY_GAUGE_STATUS=='c')          // Clear
    BAE_STATUS &= 0xFFFDFFFF;


if (EPS_BATTERY_TEMP_STATUS=='s')             // Set EPS_BATTERY_TEMP_STATUS
    BAE_STATUS |= 0x00080000;
else if(EPS_BATTERY_TEMP_STATUS=='c')       // Clear
    BAE_STATUS &= 0xFFF7FFFF;

if (EPS_STATUS==0)
    BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF);                             // Set EPS_ERR_BATTERY_TEMP
else if (EPS_STATUS==1)
    BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF)|0x00010000;           // Set EPS_BATTERY_HEATER_DISABLED
else if (EPS_STATUS==2)
    BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF)|0x00020000;           // Set EPS_ERR_HEATER_SWITCH_OFF
else if (EPS_STATUS==3)
    BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF)|0x00030000;          // Set EPS_ERR_HEATER_SWITCH_ON
else if (EPS_STATUS==4)
    BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF)|0x00040000;          // Set EPS_BATTERY_HEATER_OFF
else if (EPS_STATUS==5)
    BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF)|0x00050000;          // Set EPS_BATTERY_HEATER_ON   
    

    if(EPS_BATTERY_HEAT_ENABLE == 'e')
        BAE_ENABLE |= 0x00000080;
    else if(EPS_BATTERY_HEAT_ENABLE == 'd')
        BAE_ENABLE = BAE_ENABLE &0xFFFFFF7;    
    

   
    pc.printf("\n\r BAE status %x BAE ENABLE %x ",BAE_STATUS,BAE_ENABLE);
}

void FCTN_BAE_INIT()
{
    printf("\n\r Initialising BAE ");
    //..........intial status....//
    ACS_STATE = '4';
    ACS_ATS_ENABLE = 'e';
    ACS_DATA_ACQ_ENABLE = 'e';
    EPS_BATTERY_HEAT_ENABLE = 'e';
    DRV_XY_EN = 1;
    DRV_Z_EN = 1;
    TRZ_SW = 1;
    TRXY_SW = 1;
    //............................//
    FCTN_ACS_INIT();
    //FCTN_EPS_INIT();
    //P_BCN_INIT();

    
    FLAG();
}

int main()
{
    
    
    pc.printf("\n\r BAE Activated. Testing Version 1.1 \n");
    actual_data.power_mode=3;
    
   /* if (BCN_FEN == 0)                       //dummy implementation
    {
        pc.printf("\n\r RF silence ");
        P_BCN_FEN();
        t_rfsilence.start();//Start the timer for RF_Silence
        while(t_rfsilence.read() < RF_SILENCE_TIME); 
    }               
    */
    
    //ACS_INIT_STATUS = 'c';
    //ACS_DATA_ACQ_STATUS = 'c';
    gpo1 = 0;
    FLAG();
    FCTN_BAE_INIT();
    
    
    //...i2c..
    //strcpy(telemetry,"This is telemetry THis is sample telemetry. ffffffffffffffffffffffffffffff  end");
    slave.address(addr);
    irpt_2_mstr = 0;
    
    ptr_t_i2c = new Thread(T_TC);
    ptr_t_i2c->set_priority(osPriorityHigh);
        
    irpt_4m_mstr.enable_irq();
    irpt_4m_mstr.rise(&FCTN_I2C_ISR);
   // ir1.fall(&ir1clear);   //Battery Gauge - Alert Bar Signal
   
   
    /*ir2.fall(&ir2clear);   //TRXY Driver TR switch Fault
    ir3.fall(&ir3clear);   //TRZ Driver Fault Bar
    ir4.fall(&ir4clear);   //TRZ Driver TR switch Fault
    ir5.fall(&ir5clear);   //CDMS - Switch Fault
    ir6.fall(&ir6clear);   //Beacon- Switch OC bar
    ir7.fall(&ir7clear);   //Charger IC - Fault Bar
    
    */
    
    RtosTimer t_sc_timer(T_SC,osTimerPeriodic);               // Initiating the scheduler thread
    t_sc_timer.start(10000);
    t_start.start();
    pc.printf("\n\rStarted scheduler %f\n\r",t_start.read()); 
    
    gpo1 = 0;  // att sens2 switch is enabled
    //FCTN_BAE_INIT();
    while(1);                                                   //required to prevent main from terminating
}
