#include "mbed.h"
#include "rtos.h"
Serial pc(USBTX,USBRX);
InterruptIn irpt_4m_mstr(D11);                                      //I2c interrupt from CDMS
DigitalOut irpt_2_mstr(D12);                                        //I2C interrupt to CDMS
I2CSlave slave (D14,D15);

const int addr = 0x20;                                            //slave address 
char data_receive;
char data_send;
Thread *ptr_t_i2c;

Timer t;                  // time taken from isr to reach i2c function
Timer t1;
  bool write_ack = 1;
        bool read_ack = 1;
        char data;
        char length = 1;
void T_I2C_SLAVE(void const * args)
{
     while(1)
    {
        Thread::signal_wait(0x1);
        wait_us(100);                                               // can be between 38 to 15700
        //printf("\n\r check 1\n");
        t.stop();
        if( slave.receive() == 0) 
            //slave.stop();                  
        if( slave.receive() == 1)                                     // slave writes to master
        {
            t1.start();
            write_ack=slave.write(&data,length);       
            t1.stop();      
            //slave.stop();    
        }
        if( slave.receive()==3 ||  slave.receive()==2)             // slave read 
        {
            t1.start();
            read_ack=slave.read(&data,length);
            t1.stop();
            //slave.stop();
        }   
        printf("\n \r %d %d\n",t.read_us(),t1.read_us());
        t.reset();
        t1.reset(); 
        
        if(write_ack == 0)
            printf("\n\rData sent to CDMS is %c\n",data);
        if(read_ack == 0)
            printf("\n\r Data received from CDMS is %c \n",data);
    }
}


void FCTN_ISR_I2C()
{
     ptr_t_i2c->signal_set(0x1); 
     t.start();
}

int main()
{
   printf("\n\r SLAVE ACTIVATED\n");
   slave.address(addr);
   //slave.frequency(100000);  
   ptr_t_i2c = new Thread(T_I2C_SLAVE);
   irpt_4m_mstr.enable_irq();
   //irpt_4m_mstr.mode(PullDown);
   irpt_4m_mstr.rise(&FCTN_ISR_I2C);
   
}