#include "mbed.h"
#include "rtos.h"

Serial pc(USBTX,USBRX);
InterruptIn irpt_4m_slv(D12);                                      //I2c interrupt from CDMS
DigitalOut irpt_2_slv(D11);                                        //I2C interrupt to CDMS
I2C master(D14,D15);

const int addr = 0x20;                                            //slave address 
char data_receive;
char data_send;

void FCTN_ISR_I2C();                                              //ISR for I2C


void FCTN_ISR_I2C()
{
     //ptr_t_i2c->signal_set(0x1); 
}

//void FCTN_I2C_MASTER(char * data,int length)

Timer t;

void FCTN_MASTER_WRITE()
{   
    bool write_ack = true;
    char data = pc.getc();
    irpt_2_slv = 1;
    t.start();
    write_ack = master.write(addr|0x00,&data,1);
    t.stop();
    printf("\n\r %d\n",t.read_us());
    t.reset();
    
    if (write_ack == 0)
    printf("\n\r Data sent by master %c\n",data);
    else
    printf("\n\r Data not sent\n");
    irpt_2_slv = 0;
}

int main()
{
  printf("\n\r MASTER ACTIVATED\n");
  master.frequency(100000);  
  //ptr_t_i2c = new Thread(T_I2C_MASTER);
  irpt_2_slv = 0;
  irpt_4m_slv.enable_irq();
  irpt_4m_slv.mode(PullDown);
  irpt_4m_slv.rise(&FCTN_ISR_I2C);
  while(1)
  {
      FCTN_MASTER_WRITE();
  }
}