#include "mbed.h"
#include "rtos.h"
#include "pin_config.h"
#include "ACS.h"
#include "EPS.h"
#include "BCN.h"
Serial pc(USBTX,USBRX);

#include "TCTM.h"
#define tm_len 134
#define tc_len 135
#define batt_heat_low 20
#define print 1
#define PRINT2 1
#define baby 1
#define baby2 1
#define SBC 1

Timer timer_FCTN_ACS_GENPWM_MAIN;
Timer timer_FCTN_ACS_CNTRLALGO;
Timer timer_FCTN_BAE_INIT;
Timer timer_FLASH_INI;
Timer timer_FCTN_ACS_INIT;
Timer timer_FCTN_EPS_INIT;
Timer timer_FCTN_BCN_INIT;
Timer timer_F_ACS;
Timer timer_FCTN_ATS_DATA_ACQ;
extern Timer timer_SENSOR_INIT;
extern Timer timer_CONFIG_UPLOAD;
extern Timer timer_SENSOR_DATA_ACQ;
extern Timer timer_controlmodes;

Timer timer_F_ESP;
Timer timer_minMaxHkData;
Timer timer_FCTN_APPEND_HKDATA;
Timer timer_FCTN_EPS_HANDLE_CDMS_FAULT;
Timer timer_FCTN_EPS_HANDLE_HW_FAULTS;
Timer timer_FCTN_HK_MAIN;
Timer timer_FCTN_BATTERYGAUGE_MAIN;
Timer timer_FCTN_BATT_TEMP_SENSOR_MAIN;
extern Timer timer_alertFlags;
extern Timer timer_soc;
extern Timer timer_FCTN_BATTERYGAUGE_INIT;

Timer timer_F_BCN;
Timer timer_FCTN_BCN_TX_MAIN;
extern Timer timer_Init_BEACON_HW;
extern Timer timer_Set_BCN_TX_STATUS_DISABLED;
extern Timer timer_Set_BCN_TX_STATUS_SUSPENDED;
extern Timer timer_Set_BCN_TX_STATUS_RF_SILENCE;
extern Timer timer_Set_BCN_TX_STATUS_SUCCESS;
extern Timer timer_Set_BCN_TX_STATUS_FAILURE;

#define DISABLE_WDOG 0;

void kick_WDOG()
{
    SIM->SRVCOP=0x55;
    SIM->SRVCOP=0xAA;
    printf("\n\rkicked");
}

void init_WDOG()
{
    SIM->COPC=0x0C;  
    kick_WDOG();
}

DigitalOut time_wdog(PIN68,0);// for determining the time between code

//**********************************************GLOBAL RTOS TIMER*********************************************************//
RtosTimer *BAE_STANDBY_STATUS_TIMER;

//bcn heater rtostimers=============================================================================
RtosTimer *HTR_OFF=NULL;
RtosTimer *HTR_CYCLE=NULL;
RtosTimer *HTR_DLY=NULL;

//UPTIME  TIMERS
Timer BAE_uptime;
Timer I2C_last;

void RETURN_UPTIME(float time, uint8_t *day,uint8_t *hour,uint8_t *min)
{
    *day = time/(3600*24);
    time = (int)time % (3600*24);
    *hour = time/(3600);
    time = (int)time % (3600);
    *min = time/60;    
}

extern DigitalOut BTRY_HTR_ENABLE;
int eps_btg_read_flag;  // flag to check I2C ack on reading from BTG
int eps_btg_writ_flag;  // flag to check I2C ack on writing from BTG

uint8_t HTR_CYCLE_COUNTS=0;         //Count of heater cycles
uint8_t HTR_CYCLE_START_DLY=0;      //EPS_HTR_DLY_TIMER timer duration in minutes
uint8_t HTR_ON_DURATION=0;          //EPS_HTR_OFF timer duration in minutes
uint16_t HTR_CYCLE_PERIOD =0;       //EPS_HTR_CYCLE timer duration - MSB minutes, LSB seconds
uint8_t HTR_CYCLE_COUNTER = 0 ; 

uint32_t HTR_CYCLE_PERIOD_DECODER()    //To convert HTR_CYCLE_PERIOD to millisecs
{
    uint8_t PERIOD_mins, PERIOD_secs;
    //pc.printf("\n\r FCTN_HTR_CYCLE_PERIOD");
    PERIOD_secs = HTR_CYCLE_PERIOD;
    PERIOD_mins = HTR_CYCLE_PERIOD >> 8;
    uint32_t period = 1000*((int)PERIOD_mins * 60 + (int)PERIOD_secs);
    
    return period;
}

void FCTN_EPS_HTR_CYCLE(void const *arg)
{
    BTRY_HTR_ENABLE = 1;//assuming its active high check
    //pc.printf("\n\r on kar diya");
    //pc.printf("\n\r FCTN_EPS_HTR_CYCLE");
    //tim.reset();
    //tim.start();
    //HTR_OFF->start(((uint32_t)HTR_ON_DURATION)*1000);
    HTR_OFF->start((int)HTR_ON_DURATION*60*1000);
}

void FCTN_EPS_HTR_DLY(void const* arg)
{
    BTRY_HTR_ENABLE = 1;
    HTR_CYCLE_COUNTER = 0;
    HTR_OFF->start(((int)HTR_ON_DURATION*60*1000));
    //pc.printf("\n\r on kar diya");
    //pc.printf("\n\r FCTN_EPS_HTR_DLY");
    //tim.start();
    HTR_CYCLE->start((uint32_t)HTR_CYCLE_PERIOD_DECODER);
}

void FCTN_EPS_HTR_OFF(void const *arg)
{
    BTRY_HTR_ENABLE = 0;
    //tim.stop();
    //pc.printf("\n\r off kar diya");
    //pc.printf("\n\r the timer value is %f",tim.read());
    //tim.reset();
    if(HTR_CYCLE_COUNTS != 0xFF)
    {
        HTR_CYCLE_COUNTER++;
        if( HTR_CYCLE_COUNTER == (int)HTR_CYCLE_COUNTS)//HTR_CYCLE_COUNTS )
            HTR_CYCLE->stop();
    }
}

//====================================================================================================

//fctn to pass the data to bcn long type
//uint8_t CDMS_HK_data[134]; now implemented as LONG_HK_data[0][134];
uint8_t LONG_HK_data[2][134];
void FCTN_CDMS_HK_TC(uint8_t tc[])
{
    for(int i=0;i<134;i++)
        LONG_HK_data[0][i] = tc[i];    
}

uint8_t BAE_STANDBY=0x07;// as Bcn Acs Eps last three bits BAE order ,  refer to switch off.//old convection now *****0***** means off

void BAE_STANDBY_STATUS_RESET(const void* arg)
{
    printf("\n\rBAE standby reset to 0x00");
    BAE_STANDBY=0x07;
}


/*no problem in first stopping and then starting even when for the first time*/
void BAE_STANDBY_TIMER_RESET()
{
    BAE_STANDBY_STATUS_TIMER->stop();
    BAE_STANDBY_STATUS_TIMER->start(30000);//20 min ie 20*60=1200 sec or 1200,000 milisec but for testing setting it to 30sec
}

extern void gen_I_TM();

//***************  FLAGS ****************************//
uint32_t BAE_STATUS = 0x00000000;
uint32_t BAE_ENABLE = 0xFFFFFFFF;

//i2c//
char data_send_flag = 'h'; 
//uint8_t BAE_MNG_I2C_STATUS = 0;

//BAE
uint8_t BAE_INIT_STATUS=0;
uint8_t BAE_MNG_I2C_STATUS=0;


//ACS
uint8_t ACS_INIT_STATUS = 0;
uint8_t ACS_DATA_ACQ_STATUS = 0;
uint8_t ACS_ATS_STATUS = 0x73;
uint8_t ACS_MAIN_STATUS = 0;
uint8_t ACS_STATUS = 0;
uint8_t ACS_DETUMBLING_ALGO_TYPE = 0;
uint8_t ACS_ATS_ENABLE = 1;
uint8_t ACS_DATA_ACQ_ENABLE = 1;
uint8_t ACS_STATE = 3;

extern uint16_t ACS_MM_X_COMSN;
extern uint16_t ACS_MM_Y_COMSN;
extern uint16_t ACS_MG_X_COMSN;
extern uint16_t ACS_MG_Y_COMSN;
extern uint16_t ACS_MM_Z_COMSN;
extern uint16_t ACS_MG_Z_COMSN;

extern uint8_t controlmode_mms;
extern uint8_t B_SCZ_ANGLE;
//BCN
extern uint8_t BCN_FEN;
extern void FCTN_BCN_FEN(void const *args);
extern void LONG_BCN_DATA(uint8_t* );
extern uint16_t gencrc16_for_me();//for calculating the crc of baehk data before sendingkk as including crc causes problem
extern DigitalOut BTRY_HTR_ENABLE;


Timeout timeout_bcn;
/*long beacon data/sending*/
/*be sure it is created in bcn.cpp*/

//EPS
uint8_t EPS_INIT_STATUS = 0;
uint8_t EPS_BATTERY_GAUGE_STATUS = 0;
uint8_t EPS_MAIN_STATUS = 0;
uint8_t EPS_BTRY_TMP_STATUS = 0;/// to be diss
uint8_t EPS_STATUS = 7; //invalid status
uint8_t EPS_BTRY_HTR = 0;

uint8_t EPS_BTRY_HTR_AUTO = 1;
extern uint8_t EPS_SOC_LEVEL_12;
extern uint8_t EPS_SOC_LEVEL_23;
extern uint8_t EPS_BAT_TEMP_LOW;
extern uint8_t EPS_BAT_TEMP_HIGH;
extern uint8_t EPS_BAT_TEMP_DEFAULT;
float EPS_BTRY_TMP_AVG;
extern DigitalOut BTRY_HTR_ENABLE;

//extern void FCTN_BATTERYGAUGE_MAIN(float*Battery_parameters);


//**********************GLOBAL DECLARATIONS********************************//

//CDMS
//eps cdms fault
uint8_t CDMS_SW_STATUS;
DigitalIn CDMS_OC_FAULT(PIN79);
bool CDMS_SW_ENABLE;
int CDMS_FAULT_COUNTER = 0;


//BAE                                           new hk structure- everything has to changed based on this
char BAE_chardata[74];
// uint8_t LONG_HK_data[2][134];
//uint8_t BAE_HK_data[134];  now known as LONG_HK_data[1][i];  
uint8_t BAE_RESET_COUNTER;// INITIALIZATION or do you want to initialize evertime the main is reset? or is it same     
uint16_t BAE_I2C_COUNTER = 0;//change/apply
//uint8_t BAE_STANDBY=0x00;// as Bcn Acs Eps last three bits BAE order , 1old convection refer to switch off. chnaged now 0 means offfffffffff FU==

//BCN
//uint16_t BCN_TX_MAIN_COUNTER = 0;
uint8_t BCN_LONG_MSG_TYPE = 1;

DigitalIn BCN_TX_OC_FAULT(PIN80);
int BCN_TX_FAULT_COUNTER;   

//ACS
uint16_t ACS_MAIN_COUNTER = 0;

//eps hw faults
//uint8_t ACS_TR_Z_SW_STATUS;
DigitalOut ACS_TR_Z_ENABLE(PIN40,0);        //SWITCH
DigitalIn ACS_TR_Z_OC_FAULT(PIN91);
DigitalIn ACS_TR_Z_FAULT(PIN89);            //Driver IC fault
int ACS_TR_Z_FAULT_COUNTER = 0;


InterruptIn irpt_4m_mstr(PIN38);                                      //I2c interrupt from CDMS
DigitalOut irpt_2_mstr(PIN4);                                        //I2C interrupt to CDMS




//uint8_t ACS_TR_XY_SW_STATUS;
DigitalOut ACS_TR_XY_ENABLE(PIN71,0);
DigitalIn ACS_TR_XY_OC_FAULT(PIN77);
DigitalIn ACS_TR_XY_FAULT(PIN83);            //Driver IC fault
int ACS_TR_XY_FAULT_COUNTER = 0;

//bool ACS_ATS1_ENABLE;
DigitalIn ACS_ATS1_OC_FAULT(PIN39);
int ACS_TS1_FAULT_COUNTER = 0;

//bool ACS_ATS2_ENABLE;
DigitalIn ACS_ATS2_OC_FAULT(PIN41);
int ACS_ATS2_FAULT_COUNTER;

//EPS
int EPS_MAIN_COUNTER = 0;


//GEN DEC FOR TESTING or to be DECIDED whre to ASSIGN HERE 
const int addr = 0x20;                                            //slave address 
Timer t_rfsilence;
Timer t_start;
/*defined as of now to check execution time*/
/*remember to remove them*/
Timer t_acs;
Timer t_eps;
//Timer t_tc;
Timer t_tm;

int power_flag_dummy=2;
float data[6];


//*************EXTERN PARA********

//BAE

extern BAE_HK_actual actual_data;
extern BAE_HK_quant quant_data;
extern BAE_HK_min_max bae_HK_minmax;
extern BAE_HK_arch arch_data;


//BCN
extern uint8_t BCN_FEN;
extern uint8_t BCN_TX_SW_STATUS;
extern uint8_t BCN_SPND_TX;


//TCTM
extern uint8_t telemetry[tm_len];


//ACS
extern uint8_t ACS_TR_Z_SW_STATUS;
extern uint8_t ACS_TR_XY_SW_STATUS;
extern float gyro_data[3];
extern float mag_data[3];
extern float moment[3];
extern float b_old[3];  // Unit: Tesla
extern float db[3];
extern uint8_t flag_firsttime;
extern uint8_t ACS_MAG_TIME_DELAY;
extern uint8_t ACS_DEMAG_TIME_DELAY;
extern uint16_t ACS_Z_FIXED_MOMENT;

int write_ack;
int read_ack;
char telecommand[tc_len];


bool pf1check = 0;
bool pf2check = 0;
bool if1check = 0;
bool if2check = 0;

//ASSIGNING PINS//
DigitalOut ATS1_SW_ENABLE(PIN90,1); // enable of att sens2 switch
DigitalOut ATS2_SW_ENABLE(PIN61,0); // enable of att sens switch
////InterruptIn irpt_4m_mstr(PIN38);                                      //I2c interrupt from CDMS
////DigitalOut irpt_2_mstr(PIN4);                                        //I2C interrupt to CDMS
I2CSlave slave (PIN1,PIN2);///pin1 pin2
//DigitalOut batt_heat(PIN96);

//ATS1_SW_ENABLE = 0;
PwmOut PWM1(PIN93); //x                         //Functions used to generate PWM signal 
PwmOut PWM2(PIN94); //y
PwmOut PWM3(PIN95); //z                         //PWM output comes from pins p6

//........faults
//Polled Faults
//DigitalIn pf1(PIN5);//Attitude Sensor 1 OC bar fault signal
//DigitalIn pf2(PIN97);//Attitude Sensor 2 OC bar fault signal
//DigitalIn pf3(PIN83);//Fault Bar for TRXY driver
 
 
DigitalOut DRV_XY_EN(PIN82,0); // DRV XY en
//DigitalOut TRXY_SW(PIN71,0);  //TR XY Switch
DigitalOut DRV_Z_EN(PIN88,0);    //Sleep pin of driver z        //DISABLE  by default
//DigitalOut TRZ_SW(PIN40,0);  //TR Z Switch

DigitalOut CDMS_RESET(PIN7,1); // CDMS RESET

DigitalOut CDMS_OC_ENA(PIN70,1);

DigitalOut BCN_SW(PIN64,1); // PIN changed to 64 (previous 65 )              //IN TEMPORARY SBC
//DigitalOut BCN_SW(PIN14,1);      //Beacon switch  //IN QM SBC, TO BE CHANGED

//================================================================================
//default flash array some filler bits added (detail in MMS file)
//uint32_t ARR_INITIAL_VAL[8]={0x73532600,0x505A4141,0x1A1A1400,0x00000000,0x00000000,0x00000000,0xCBA20000,0x00000000};//to be done
uint32_t ARR_INITIAL_VAL[8]={0x7C532600,0x505A4141,0x1A1A1400,0x001E0028,0x001E0028,0x00320032,0xCBA2010A,0x00000000};//to be done

void FLASH_INI()
{
    uint32_t read[8]; 
    for(int i=0;i<8;i++)
        {  
            read[i] = FCTN_BAE_RD_FLASH_ENTITY(i);
            //printf("\n\r val is read after starting %x  ",read[i]);
        }
            
    if(read[0] == -1)
        for(int j=0;j<8;j++)
            {   
                FCTN_BAE_WR_FLASH(j,ARR_INITIAL_VAL[j]); 
                ACS_ATS_STATUS  = ARR_INITIAL_VAL[0]>>24;
                ACS_TR_XY_SW_STATUS = ((uint8_t)(ARR_INITIAL_VAL[0]>>22))&0x03;
                ACS_TR_Z_SW_STATUS = (ARR_INITIAL_VAL[0]>>20)&0x03;
                ACS_STATE = (ARR_INITIAL_VAL[0]>>16)&0x0F;
                //pc.pc.printf("\n\r acs state in starting is %x",ACS_STATE);
                ACS_DETUMBLING_ALGO_TYPE = (ARR_INITIAL_VAL[0]>>15)&0x01;
                BCN_TX_SW_STATUS = 1;//((uint8_t)(ARR_INITIAL_VAL[0]>>14))&0x03;
                BCN_SPND_TX = ((uint8_t)(ARR_INITIAL_VAL[0]>>12))&0x01;
                BCN_FEN = ((uint8_t)(ARR_INITIAL_VAL[0]>>11))&0x01;
                BCN_LONG_MSG_TYPE = ((uint8_t)(ARR_INITIAL_VAL[0]>>10))&0x01;
                EPS_BTRY_HTR_AUTO = ((uint8_t)(ARR_INITIAL_VAL[0]>>9))&0x03;//EPS_BATTERY_HEATER_ENABLE
                //now one spares in telemetry[5]
                
                //updating the reset counter
                BAE_RESET_COUNTER = ((uint8_t)(ARR_INITIAL_VAL[0]));
                EPS_SOC_LEVEL_12 = (uint8_t)(ARR_INITIAL_VAL[1]>>24); 
                EPS_SOC_LEVEL_23 = (uint8_t)(ARR_INITIAL_VAL[1]>>16);
                ACS_MAG_TIME_DELAY = (uint8_t)(ARR_INITIAL_VAL[1]>>8);
                ACS_DEMAG_TIME_DELAY = (uint8_t)ARR_INITIAL_VAL[1];
                        
                EPS_BAT_TEMP_LOW = (uint8_t)(ARR_INITIAL_VAL[2]>>24);
                EPS_BAT_TEMP_HIGH = (uint8_t)(ARR_INITIAL_VAL[2]>>16);
                EPS_BAT_TEMP_DEFAULT = (uint8_t)(ARR_INITIAL_VAL[2]>>8);
                                                                            
                ACS_MM_X_COMSN = (uint16_t)(ARR_INITIAL_VAL[3]>>16);                                                                
                ACS_MM_Y_COMSN = (uint16_t)ARR_INITIAL_VAL[3];
                                                                            
                ACS_MG_X_COMSN = (uint16_t)(ARR_INITIAL_VAL[4]>>16);
                ACS_MG_Y_COMSN = (uint16_t)ARR_INITIAL_VAL[4];
                                                                        
                ACS_MM_Z_COMSN = (uint16_t)(ARR_INITIAL_VAL[5]>>16);
                ACS_MG_Z_COMSN = (uint16_t)ARR_INITIAL_VAL[5];
                                                                            
                ACS_Z_FIXED_MOMENT = (uint16_t)(ARR_INITIAL_VAL[6]>>16);//assignvalues 
                                 
        } 
    else
       {
        for(int j=0;j<8;j++)
            {   
                read[j] = FCTN_BAE_RD_FLASH_ENTITY(j);
            }
        ACS_ATS_STATUS  = read[0]>>24;
        ACS_TR_XY_SW_STATUS = ((uint8_t)(read[0]>>22))&0x03;
        ACS_TR_Z_SW_STATUS = (read[0]>>20)&0x03;
        ACS_STATE = (read[0]>>16)&0x0F;
        //pc.printf("\n\r acs state in starting is %x",ACS_STATE);
        ACS_DETUMBLING_ALGO_TYPE = (read[0]>>15)&0x01;
        BCN_TX_SW_STATUS = 1;//((uint8_t)(read[0]>>13))&0x03;
        BCN_SPND_TX = ((uint8_t)(read[0]>>12))&0x01;
        BCN_FEN = ((uint8_t)(read[0]>>11))&0x01;
        BCN_LONG_MSG_TYPE = ((uint8_t)(read[0]>>10))&0x01;
        EPS_BTRY_HTR_AUTO = ((uint8_t)(read[0]>>9))&0x01;//EPS_BATTERY_HEATER_ENABLE
        //now one spares in telemetry[5]
        
        //updating the reset counter
        BAE_RESET_COUNTER = ((uint8_t)(read[0]))+1;
        read[0]=(read[0]&0xffffff00) | (uint32_t)BAE_RESET_COUNTER;
        FCTN_BAE_WR_FLASH(0,read[0]);
        pc.printf("\n\r reset counter %d",BAE_RESET_COUNTER);
        
                
        EPS_SOC_LEVEL_12 = (uint8_t)(read[1]>>24); 
        EPS_SOC_LEVEL_23 = (uint8_t)(read[1]>>16);
        ACS_MAG_TIME_DELAY = (uint8_t)(read[1]>>8);
        ACS_DEMAG_TIME_DELAY = (uint8_t)read[1];
                
        EPS_BAT_TEMP_LOW = (uint8_t)(read[2]>>24);
        EPS_BAT_TEMP_HIGH = (uint8_t)(read[2]>>16);
        EPS_BAT_TEMP_DEFAULT = (uint8_t)(read[2]>>8);
                                                                    
        ACS_MM_X_COMSN = (uint16_t)(read[3]>>16);                                                                
        ACS_MM_Y_COMSN = (uint16_t)read[3];
                                                                    
        ACS_MG_X_COMSN = (uint16_t)(read[4]>>16);
        ACS_MG_Y_COMSN = (uint16_t)read[4];
                                                                
        ACS_MM_Z_COMSN = (uint16_t)(read[5]>>16);
        ACS_MG_Z_COMSN = (uint16_t)read[5];
                                                                    
        ACS_Z_FIXED_MOMENT = (uint16_t)(read[6]>>16);//assignvalues 
            
        }
    
}
//================================================================================



/*****************************************************************Threads USed***********************************************************************************/
Thread *ptr_t_i2c;


/*********************************************************FCTN HEADERS***********************************************************************************/
void FCTN_ISR_I2C();
void FCTN_TM();
void F_ACS();
void F_EPS();
void F_BCN();

//I2C
uint32_t pdir_tc1,pdir_tc2,pdir_tm1,pdir_tm2,pdir_ss1,pdir_ss2;//variables used to verify i2c working
uint16_t crc16_check;
void I2C_busreset()
{
    PORTE->PCR[1] &= 0xfffffffb;
    PORTE->PCR[0] &= 0xfffffffb;
    I2C1->C1 &= 0x7f;
    SIM->SCGC4 &= 0xffffff7f;
    SIM->SCGC4 |= 0x00000080;
    I2C1->C1 |= 0x80;  
    PORTE->PCR[1] |= 0x00000004;
    PORTE->PCR[0] |= 0x00000004;    
    wait_ms(1);
}

//*******************************************ACS THREAD**************************************************//
uint8_t iterP1;
uint8_t iterP2;
uint8_t iterI1;
uint8_t iterI2;

//FLOAT TO UINT_8 CONVERSION FUNCTION
extern uint8_t float_to_uint8(float min,float max,float val);

//#define print 0   

void F_ACS()
{
    ACS_MAIN_COUNTER++;
    //time_wdog = 1;   
    pc.printf("Entered ACS.\n\r");

    ACS_MAIN_STATUS = 1; //set ACS_MAIN_STATUS flag 
    //FLAG();
    
    PWM1 = 0;                     //clear pwm pins
    PWM2 = 0;                     //clear pwm pins
    PWM3 = 0;                     //clear pwm pins
    
    wait_ms(ACS_DEMAG_TIME_DELAY);
    ACS_DATA_ACQ_STATUS = (uint8_t) FCTN_ATS_DATA_ACQ();     
    
    //#if print
        //printing the angular speed and magnetic field values
        pc.printf("gyro values\n\r"); 
        for(int i=0; i<3; i++) 
            {
                pc.printf("%f\n\r",actual_data.AngularSpeed_actual[i]);
            }
    
        pc.printf("mag values\n\r");
        for(int i=0; i<3; i++) 
            {
                pc.printf("%f\n\r",actual_data.Bvalue_actual[i]);
            }
    //#endif
    
    for(int i=0;i<3;i++)
        {
            mag_data[i] = actual_data.Bvalue_actual[i]/1000000;
            gyro_data[i] = actual_data.AngularSpeed_actual[i]*3.14159/180;
        }
        
    float b_inclination = mag_data[2]/sqrt(mag_data[0]*mag_data[0]+mag_data[1]*mag_data[1]+mag_data[2]*mag_data[2]);
    
    if(b_inclination <0)
    {
        b_inclination = (-1)*b_inclination;
    }
    B_SCZ_ANGLE = (uint8_t)(b_inclination*16);
    if( b_inclination >= 16)
    {
        B_SCZ_ANGLE = 0x0F;
    }
    if(b_inclination <=0)
    {
        B_SCZ_ANGLE = 0x00;
    }
    //printf("POWER MODE is : %d\r\n",actual_data.power_mode);
    
    if(ACS_STATE == 0)                      // check ACS_STATE = ACS_CONTROL_OFF?
        {
            #if print
                pc.printf("\n\r acs control off\n");
            #endif
            ACS_STATUS = 0;                // set ACS_STATUS = ACS_CONTROL_OFF
            ACS_MAIN_STATUS = 0;
            return;
        }
    else if((actual_data.power_mode<=2)||( (( ACS_STATE)&0x08) == 0x08))
        {
            //#if print
                pc.printf("\n\r Low Power \n\r");
            //#endif
            DRV_Z_EN = 0;
            DRV_XY_EN = 0;
            ACS_TR_Z_ENABLE = 0;
            ACS_TR_XY_ENABLE = 0;
            ACS_STATUS = 1;                    // set ACS_STATUS = ACS_LOW_POWER
            ACS_MAIN_STATUS = 0;
            return;
        
        }
    else if(ACS_TR_Z_SW_STATUS != 1)
        {
            pc.printf("\n\r Z disabled \n\r");
            DRV_Z_EN = 0;
            DRV_XY_EN = 0;
            ACS_TR_Z_ENABLE = 0;
            ACS_TR_XY_ENABLE = 0;
            ACS_STATUS = 2;                 // set ACS_STAUS = ACS_TRZ_DISABLED
            ACS_MAIN_STATUS = 0;
            return;       
        }
    else if(ACS_TR_XY_SW_STATUS != 1)
        {   
            pc.printf("\n\r Z only \n\r");              
            DRV_Z_EN = 1;
            DRV_XY_EN = 0;
             ACS_TR_Z_ENABLE = 1;
    ACS_TR_XY_ENABLE = 0;
            ACS_STATUS = 3;                 // set ACS_STAUS = ACS_TRXY_DISABLED , Z axis only
            moment[0] = 0;
            moment[1] = 0;
            moment[2] = ACS_Z_FIXED_MOMENT;                 // is a dummy value 
            
            //timer_FCTN_ACS_GENPWM_MAIN.start();
            FCTN_ACS_GENPWM_MAIN(moment) ;
            //timer_FCTN_ACS_GENPWM_MAIN.stop();
            //pc.printf("\n\r the timer_FCTN_ACS_GENPWM_MAIN is %f",timer_FCTN_ACS_GENPWM_MAIN.read());
            ACS_MAIN_STATUS = 0;
            return;
        }
    else if((ACS_DATA_ACQ_STATUS == 0)||(ACS_DATA_ACQ_STATUS == 1))
        {
            
            pc.printf("\n\r Z only no data \n\r");
            DRV_Z_EN = 1;
            DRV_XY_EN = 0;
             ACS_TR_Z_ENABLE = 1;
    ACS_TR_XY_ENABLE = 0;
            ACS_STATUS = 3;                 // set Set ACS_STATUS = ACS_DATA_ACQN_FAILURE , Z axis only
            
            moment[0] = 0;
            moment[1] = 0;
            moment[2] = ACS_Z_FIXED_MOMENT;                 // is a dummy value 
            
            //timer_FCTN_ACS_GENPWM_MAIN.start();
            FCTN_ACS_GENPWM_MAIN(moment) ;
            //timer_FCTN_ACS_GENPWM_MAIN.stop();
            //pc.printf("\n\r the timer_FCTN_ACS_GENPWM_MAIN is %f",timer_FCTN_ACS_GENPWM_MAIN.read());
            
            ACS_MAIN_STATUS = 0;
            return; 
        }
    else if((ACS_STATE == 1)||(ACS_STATE == 9))
        {
            pc.printf("\n\r Z only by state \n\r");
            DRV_Z_EN = 1;
            DRV_XY_EN = 0;
             ACS_TR_Z_ENABLE = 1;
    ACS_TR_XY_ENABLE = 0;
            ACS_STATUS = 3;                 // set ACS_STAUS = ACS_TRXY_DISABLED by ACS_STATE i.e Z axis only
            
            moment[0] = 0;
            moment[1] = 0;
            moment[2] = ACS_Z_FIXED_MOMENT;                 // 1.3 is a dummy value 
            FCTN_ACS_GENPWM_MAIN(moment) ;
                
            ACS_MAIN_STATUS = 0;
            return;
        }
    else if(ACS_DATA_ACQ_STATUS == 2)           // MM only is available
        {
            pc.printf("\n\r MM only BDOT \n\r");
            DRV_Z_EN = 1;
            DRV_XY_EN = 1;
             ACS_TR_Z_ENABLE = 1;
    ACS_TR_XY_ENABLE = 1;
                              
            ACS_STATUS = 4;                 // set Set ACS_STATUS = ACS_BDOT_CONTROL
            ACS_DETUMBLING_ALGO_TYPE = 0x01;
            FCTN_ACS_CNTRLALGO(moment,mag_data,gyro_data,0x00,0x01,ACS_DETUMBLING_ALGO_TYPE);
            controlmode_mms=0x00;
            #if print    
                pc.printf("\n\r Moment values returned by control algo \n");
            #endif
            for(int i=0; i<3; i++) 
                {
                    pc.printf("%f\t",moment[i]);
                }
            FCTN_ACS_GENPWM_MAIN(moment) ; 
            ACS_MAIN_STATUS = 0;
            return;  
        }
    else if((ACS_STATE == 2)||(ACS_STATE == 10))                     // Nominal mode
        {
            #if print
                pc.printf("\n\r Nominal mode \n");
            #endif
            DRV_Z_EN = 1;
            DRV_XY_EN = 1;            
            ACS_TR_Z_ENABLE = 1;
    ACS_TR_XY_ENABLE = 1;
            
            //timer_FCTN_ACS_CNTRLALGO.start();   
            FCTN_ACS_CNTRLALGO(moment,mag_data,gyro_data,0x01,0x00,ACS_DETUMBLING_ALGO_TYPE);
            //timer_FCTN_ACS_CNTRLALGO.stop();
            //pc.printf("\n\r the timer_FCTN_ACS_GENPWM_MAIN is %f",timer_FCTN_ACS_CNTRLALGO.read());
            
            controlmode_mms = 0x01;
            #if print    
                pc.printf("\n\r Moment values returned by control algo \n");
            #endif
            for(int i=0; i<3; i++) 
                {
                    pc.printf("%f\t",moment[i]);
                }
                
            //timer_FCTN_ACS_GENPWM_MAIN.start();    
            FCTN_ACS_GENPWM_MAIN(moment) ;  
            //timer_FCTN_ACS_GENPWM_MAIN.stop();
            //pc.printf("\n\r the timer_FCTN_ACS_CNTRLALGO is %f",timer_FCTN_ACS_GENPWM_MAIN.read());
            
            ACS_MAIN_STATUS = 0;
            return; 
        }
    else if((ACS_STATE == 3)||(ACS_STATE == 11))                     // Auto Control
        {
            #if print
                pc.printf("\n\r Auto control mode \n");
            #endif 
            DRV_Z_EN = 1;
            DRV_XY_EN = 1;
            ACS_TR_Z_ENABLE = 1;
    ACS_TR_XY_ENABLE = 1;              
            
            timer_FCTN_ACS_CNTRLALGO.start();   
            FCTN_ACS_CNTRLALGO(moment,mag_data,gyro_data,0x00,0x00,ACS_DETUMBLING_ALGO_TYPE);
            timer_FCTN_ACS_CNTRLALGO.stop();
            //pc.printf("\n\r the timer_FCTN_ACS_CNTRLALGO is %f",timer_FCTN_ACS_CNTRLALGO.read());
            
            controlmode_mms = 0x00;
            #if print
                pc.printf("\n\r Moment values returned by control algo \n");
                for(int i=0; i<3; i++) 
                    {
                        pc.printf("%f\t",moment[i]);
                    }
            #endif
            pc.printf("\r\n");
            timer_FCTN_ACS_GENPWM_MAIN.start();
            FCTN_ACS_GENPWM_MAIN(moment) ;// set ACS_STATUS in function
            timer_FCTN_ACS_GENPWM_MAIN.stop();
            //pc.printf("\n\r the timer_FCTN_ACS_GENPWM_MAIN is %f",timer_FCTN_ACS_GENPWM_MAIN.read());
            
            ACS_MAIN_STATUS = 0;
            return; 
        }
    else if((ACS_STATE == 4)||(ACS_STATE == 12))                     // Detumbling
        {
            pc.printf("\n\r Detumbling \n\r");
            DRV_Z_EN = 1;
            DRV_XY_EN = 1;
            ACS_TR_Z_ENABLE = 1;
    ACS_TR_XY_ENABLE = 1;       
            FCTN_ACS_CNTRLALGO(moment,mag_data,gyro_data,0x00,0x01,ACS_DETUMBLING_ALGO_TYPE);
            controlmode_mms = 0x00;
            FCTN_ACS_GENPWM_MAIN(moment) ;  
            ACS_MAIN_STATUS = 0;
            return; 
        }
    ACS_STATUS = 7;                    //INVALID_STATE
    DRV_Z_EN = 0;
    ACS_TR_Z_ENABLE = 0;
    ACS_TR_XY_ENABLE = 0;
    DRV_XY_EN = 0;    
    ACS_MAIN_STATUS = 0; //clear ACS_MAIN_STATUS flag 
}


//***************************************************EPS THREAD***********************************************//


void F_EPS()
{
      float eps_btry_temp;
      pc.printf("\n\rEntered EPS   %f\n\r",t_start.read());
      EPS_MAIN_STATUS = 1; // Set EPS main status
      EPS_MAIN_COUNTER++;
      
      timer_FCTN_BATT_TEMP_SENSOR_MAIN.reset();
      timer_FCTN_BATT_TEMP_SENSOR_MAIN.start();
      FCTN_BATT_TEMP_SENSOR_MAIN(actual_data.Batt_temp_actual);
      timer_FCTN_BATT_TEMP_SENSOR_MAIN.stop();
      
      pc.printf("Battery temperature %f %f\n\r" ,actual_data.Batt_temp_actual[0], actual_data.Batt_temp_actual[1]);
      EPS_BTRY_TMP_AVG = ( actual_data.Batt_temp_actual[0] + actual_data.Batt_temp_actual[1] )/2.0;
      if(abs(actual_data.Batt_temp_actual[0] - actual_data.Batt_temp_actual[1]) > 10)
      {
          EPS_BTRY_TMP_STATUS = 0;          //clear EPS_BTRY_TMP_STATUS
          eps_btry_temp = (float) EPS_BAT_TEMP_DEFAULT;
      }
      else   
      {
          EPS_BTRY_TMP_STATUS = 1;          //set EPS_BTRY_TMP_STATUS
          eps_btry_temp = EPS_BTRY_TMP_AVG;
      }
         
      if(EPS_BTRY_HTR_AUTO == 0)
          EPS_STATUS = 1;                   //EPS_BATTERY_HEATER_DISABLED
      else if( EPS_BTRY_TMP_STATUS == 0 )
      {
          BTRY_HTR_ENABLE = 0;
          EPS_BTRY_HTR = 0;
          EPS_STATUS = 0;                   //Set EPS_ERR_BATTERY_TEMP
      }
      else
      {
            if( EPS_BTRY_HTR == 1 && eps_btry_temp >= EPS_BAT_TEMP_HIGH )
            {
              BTRY_HTR_ENABLE = 0;
              EPS_BTRY_HTR = 0;
              EPS_STATUS = 4;               //Set EPS_BATTERY_HEATER_OFF
            }
            else if( EPS_BTRY_HTR == 0 && eps_btry_temp < EPS_BAT_TEMP_LOW )
            {
              BTRY_HTR_ENABLE = 1;
              EPS_BTRY_HTR = 1;
              EPS_STATUS = 5;               //Set EPS_BATTERY_HEATER_ON
            }
      }  
 
        unsigned short statusreg = read(REG_STATUS);
        if( EPS_BATTERY_GAUGE_STATUS == 0 ) reset();
        if( read(REG_STATUS)  & 0x0100 == 0x0100 )     //checking if Reset Indicator bit is set
        {
            pc.printf("REG_STATUS = %d\r\n",read(REG_STATUS));    
            FCTN_BATTERYGAUGE_INIT();
        } 
        timer_FCTN_BATTERYGAUGE_MAIN.reset();
        timer_FCTN_BATTERYGAUGE_MAIN.start();
        int BTG_MAIN_FLAG = FCTN_BATTERYGAUGE_MAIN(actual_data.Batt_gauge_actual, eps_btry_temp);
        timer_FCTN_BATTERYGAUGE_MAIN.stop();
        
        if( BTG_MAIN_FLAG == 0 )                      //Data not received
            {
              actual_data.power_mode = 1;
              EPS_BATTERY_GAUGE_STATUS = 0;           //clear EPS_BATTERY_GAUGE_STATUS 
            }
        else
            {
              FCTN_EPS_POWERMODE(actual_data.Batt_gauge_actual[1]);            //updating power level 
              EPS_BATTERY_GAUGE_STATUS = 1;           //set EPS_BATTERY_GAUGE_STATUS
            }
        
        timer_FCTN_HK_MAIN.reset();
        timer_FCTN_HK_MAIN.start();
        FCTN_HK_MAIN();
        timer_FCTN_HK_MAIN.stop();
       // pc.printf("ere");
       
        timer_FCTN_EPS_HANDLE_HW_FAULTS.reset();
        timer_FCTN_EPS_HANDLE_HW_FAULTS.start();
        FCTN_EPS_HANDLE_HW_FAULTS();
        timer_FCTN_EPS_HANDLE_HW_FAULTS.stop();
       
        timer_FCTN_EPS_HANDLE_CDMS_FAULT.reset();
        timer_FCTN_EPS_HANDLE_CDMS_FAULT.start();
        FCTN_EPS_HANDLE_CDMS_FAULT();
        timer_FCTN_EPS_HANDLE_CDMS_FAULT.stop();
        
        timer_FCTN_APPEND_HKDATA.reset();
        timer_FCTN_APPEND_HKDATA.start();
        FCTN_APPEND_HKDATA();
        timer_FCTN_APPEND_HKDATA.stop();
        
        timer_minMaxHkData.reset();
        timer_minMaxHkData.start();
        minMaxHkData();
        timer_minMaxHkData.stop();
        
        //pc.printf("ere");  
        EPS_MAIN_STATUS = 0; // clear EPS main status 
 
}
 

//**************************************************BCN THREAD*******************************************************************//

void F_BCN()
{
    pc.printf("\n\rEntered BCN   %f\n",t_start.read());
    //BCN_TX_MAIN_COUNTER=+1;  
    
    timer_FCTN_BCN_TX_MAIN.reset();
    timer_FCTN_BCN_TX_MAIN.start();
    FCTN_BCN_TX_MAIN();
    timer_FCTN_BCN_TX_MAIN.stop();
}

//**************************************************TCTM THREAD*******************************************************************//

//===================================================================
void T_TC(void const * args)
{   
    while(1)
    {  
        Thread::signal_wait(0x4);
        wait_us(300);
                 
        BAE_MNG_I2C_STATUS =1 ;
        //I2C_last.reset();
        //I2C_last.start();
       // pc.printf("\n\r intrpet");
        if( slave.receive() == 0)
        {
            pdir_ss1=PTE->PDIR;                                         /////////edited
            irpt_2_mstr = 0;
            data_send_flag = 'h';                
            slave.stop();                
            if(((pdir_ss1 & 0x00000003)!=3))        //check if bus has freezed
            {                  
                I2C_busreset();                                         /////////edited
            }
            pdir_ss2=PTE->PDIR;
            pc.printf("\n\rSlave not addressed");
            pc.printf("\n\rPTE->DIR = 0x%08X",pdir_ss1);                
            #if PRINT2
            pc.printf("\n\rPTE->DIR = 0x%08X",pdir_ss2);
            #endif
        }
        else if( slave.receive() == 1)                                     // slave writes to master
        {
            BAE_I2C_COUNTER++;                                                      //////////edited
           // pc.printf("\n\r writing....");// changed
            if(data_send_flag == 'h') //to be renamed as BAE_I2C_STATUS
            {
                irpt_2_mstr =1;   
                //pc.printf("\n\r hk ");                                  //wait till cdms code is changed
                FCTN_APPEND_HKDATA();
                uint8_t i2c_count =0;
                //crc is already being added
                write_ack=slave.write((char*)BAE_chardata,134);
                wait_ms(1);    //for correct values of register to be updated
                pdir_tm1=PTE->PDIR;
                irpt_2_mstr = 0;                             
                if(write_ack==0)// wait till cdms code is changed
                {
                    /*checking the tc timings*/
                   // time_wdog = 1;
                    
                    while(((pdir_tm1 & 0x00000003)!=3)&& i2c_count<10)
                    {
                        wait_ms(1);
                        pdir_tm1=PTE->PDIR;
                        i2c_count++;
                    }                    
                    if(((pdir_tm1 & 0x00000003)==3))
                    {                  
                        pc.printf("\n\rWrite HK success");
                       // data_send_flag = 'h';
                        irpt_2_mstr = 0;
                        I2C_last.reset();
                        I2C_last.start();                                //////////edited
                    }
                    else
                    {
                        #if baby
                        pc.printf("\n\rWrite HK failed");
                        pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm1);
                        #endif
                        wait_ms(20); //should be atleast 7ms for correct operation but fix this value as 20ms
                        I2C_busreset();
                        #if baby2
                        pdir_tm2 = PTE->PDIR;
                        pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm2);
                        #endif                   
                    }
                }
                else
                {                    
                    #if baby1
                    pc.printf("\n\rWrite Ack failed(HK)");
                    pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm1);
                    #endif
                    I2C_busreset();
                    #if baby2
                    pdir_tm2 = PTE->PDIR;
                    pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm2);
                    #endif
                }
                i2c_count=0;
            }
            else if (data_send_flag == 't') //else if(telecommand[1]&0xC0 == 't')
            {
                uint8_t i2c_count =0;
                write_ack=slave.write((char*)telemetry,134);                        ////////edited(size)
                wait_ms(1);    //for correct values of register to be updated
                pdir_tm1=PTE->PDIR;
                irpt_2_mstr = 0;
                data_send_flag = 'h'; 
               // pc.printf("\n\r h set here");              
                if(write_ack==0)
                {
                    while(((pdir_tm1 & 0x00000003)!=3)&& i2c_count<10)
                    {
                        wait_ms(1);
                        pdir_tm1=PTE->PDIR;
                        i2c_count++;
                    }                    
                    if(((pdir_tm1 & 0x00000003)==3))
                    {                  
                        pc.printf("\n\rWrite TM success");
                        I2C_last.reset();
                        I2C_last.start();
                    }
                    else
                    {
                        #if baby
                        pc.printf("\n\rWrite TM failed");
                        pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm1);
                        #endif
                        wait_ms(20); //should be atleast 7ms for correct operation but fix this value as 20ms
                        I2C_busreset();
                        #if baby2
                        pdir_tm2 = PTE->PDIR;
                        pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm2);
                        #endif
                    }
                } 
                else
                {
                    #if baby
                    pc.printf("\n\rWrite Ack failed");
                    pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm1);
                    #endif
                    I2C_busreset();
                    #if baby2
                    pdir_tm2 = PTE->PDIR;
                    pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm2);                   
                    #endif
                }
                i2c_count=0;                  
            } 
           // else
           // pc.printf("\n\r hey something wrong");                  
        }
        else if( slave.receive()==3 ||  slave.receive()==2)             // slave read 
        {
            BAE_I2C_COUNTER++;
            
            /*checking the tc timings*/
            time_wdog = 1;
            
            uint8_t i2c_count = 0;            
            read_ack=slave.read((char *)telecommand,135);    //read() function returns acknowledgement
            wait_ms(1);
            pdir_tc1=PTE->PDIR;            
            if(read_ack==0)     //read() says it was successful
            {
                while(((pdir_tc1 & 0x00000003)!=3)&& i2c_count<10)//checking if SDA and SCL lines are logic 0 and not more than 10 times(10ms)
                {
                    wait_ms(1);
                    pdir_tc1=PTE->PDIR;
                    i2c_count++;
                }                    
                if(((pdir_tc1 & 0x00000003)==3))
                {
                    //pc.printf("\n\n\rRead TC success");
                    if(telecommand[0] == 0x00)                          /////////////edited
                        {
                            FCTN_CDMS_HK_TC((uint8_t*) telecommand);        /////////////edited
                            data_send_flag = 'h';
                            pc.printf("\n\n\rRead LBCN QM is comming");
                            I2C_last.reset();
                            I2C_last.start();      
                        }                            
                    else                   
                    {
                        pc.printf("\n\r Read TC SUCESS");
                        FCTN_BAE_TM_TC((uint8_t*) telecommand);
                        data_send_flag = 't';
                        irpt_2_mstr = 1;
                        I2C_last.reset();
                        I2C_last.start();
                      
                    }
                }
                else     //either or both of SDA and SCL lines low
                {
                    #if baby
                    pc.printf("\n\rRead TC failed");
                    pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm1);
                    #endif
                    I2C_busreset();
                    #if baby2
                    pdir_tm2 = PTE->PDIR;                    
                    pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm2);
                    #endif
                    gen_I_TM();
                    data_send_flag = 't';
                    irpt_2_mstr = 1;                                    /////////////added
                }
            }
            else //read() says it was not successful
            {                
                #if baby
                pc.printf("\n\rRead Ack failed");
                pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm1);                
                #endif
                I2C_busreset();
                #if baby2
                pdir_tm2 = PTE->PDIR;
                pc.printf("\n\rPTE->PDIR = 0x%08X",pdir_tm2);
                #endif
                //pc.printf("\n\r no data case");
                gen_I_TM();
                data_send_flag = 't';  
                irpt_2_mstr = 1;                                            /////////////added
            }
            i2c_count = 0;
        }     
        BAE_MNG_I2C_STATUS=0;
    }
}

void FCTN_TM()
{ 
    data_send_flag = 't';
    pc.printf("\n\r Telemetry Generation \n");
    irpt_2_mstr = 1;   
}


//******************************************************* I2C *******************************************************************//

void FCTN_I2C_ISR()
{
    ptr_t_i2c->signal_set(0x4);
}


//***********************************************************FAULTS***************************************************************//

uint8_t iter2=0,iter4 = 0; 

void pollfault()
{   
    //if (ACS_ATS1_OC_FAULT==0)                // OC_ATS1
    if(0)
        { 
            pf1check=1;
            actual_data.faultPoll_status |=0x01 ;
            ATS1_SW_ENABLE = 1;  // turn off ats1  // to be turned on next cycle in ACS
        }
    else 
        actual_data.faultPoll_status &= 0xFE;
    
    //if(ACS_ATS2_OC_FAULT==0)
    if(0)
        {   
            pf2check=1;
            actual_data.faultPoll_status |=0x02 ;
            ATS2_SW_ENABLE = 1;  // turn off ats2  // turn on in ACS
        }
    else 
        actual_data.faultPoll_status &= 0xFD;
 
    if (ACS_TR_XY_FAULT==0)
        {   
            actual_data.faultPoll_status |=0x04 ;
            DRV_XY_EN = 0;
            wait_us(1);
            DRV_XY_EN = 1;
        }
    else 
        actual_data.faultPoll_status &= 0xFB;
}
  
//------------------------------------------------------------------------------------------------------------------------------------------------
//SCHEDULER
//------------------------------------------------------------------------------------------------------------------------------------------------

uint8_t schedcount=1;
void T_SC(void const *args)
{    
    #if print
        pc.printf("\n\r in scheduler");
    #endif
   /*if keeping thish many cases creates a problem then make 3 seperate flagvariable i.e bae_standby_acs so on that will make it easy.!!!*/
    if(schedcount == 13)                         //to reset the counter
        schedcount = 1;
    if(schedcount%1==0)
        {
            if( BAE_STANDBY==0x02 || BAE_STANDBY==0x03 || BAE_STANDBY==0x06 || BAE_STANDBY==0x07)
                {
                    pc.printf("\n reahed here working till stage one acs");
                    pc.printf("\nSTATE IS !!!!!! = %x !!\n",ACS_STATE);
                    timer_F_ACS.reset();
                    timer_F_ACS.start();
                    F_ACS();
                    timer_F_ACS.stop();
                    /*pc.printf("\n\r timer_F_ACS is %f",timer_F_ACS.read());
                    pc.printf("\n\r timer_SENSOR_INIT is %f",timer_SENSOR_INIT.read());
                    pc.printf("\n\r timer_CONFIG_UPLOAD is %f",timer_CONFIG_UPLOAD.read());
                    pc.printf("\n\r timer_SENSOR_DATA_ACQ is %f",timer_SENSOR_DATA_ACQ.read());
                    pc.printf("\n\r timer_FCTN_ACS_GENPWM_MAIN is %f",timer_FCTN_ACS_GENPWM_MAIN.read());
                    pc.printf("\n\r timer_FCTN_ACS_CNTRLALGO is %f",timer_FCTN_ACS_CNTRLALGO.read());
                    pc.printf("\n\r timer_controlmodes is %f",timer_controlmodes.read());
                    */
                    //time_wdog = 0;
                }
    
        }
    if(schedcount%4==0)
        {   
            if( BAE_STANDBY==0x01 || BAE_STANDBY==0x03 || BAE_STANDBY==0x05 || BAE_STANDBY==0x07)
                {
                    pc.printf("\n reahed here working till stage one eps");
                    //time_wdog = 1;
                    timer_F_ESP.reset();
                    timer_F_ESP.start();
                    F_EPS();
                    timer_F_ESP.stop();
                    pc.printf("\n\r timer_F_ESP is %f",timer_F_ESP.read());
                   /* pc.printf("\n\r timer_FCTN_BATTERYGAUGE_INIT is %f",timer_FCTN_BATTERYGAUGE_INIT.read());
                    pc.printf("\n\r timer_alertFlags is %f",timer_alertFlags.read());
                    pc.printf("\n\r timer_soc is %f",timer_soc.read());
                    pc.printf("\n\r timer_FCTN_BATT_TEMP_SENSOR_MAIN is %f",timer_FCTN_BATT_TEMP_SENSOR_MAIN.read());
                    pc.printf("\n\r timer_FCTN_BATTERYGAUGE_MAIN is %f",timer_FCTN_BATTERYGAUGE_MAIN.read());
                    pc.printf("\n\r timer_FCTN_HK_MAIN is %f",timer_FCTN_HK_MAIN.read());
                    pc.printf("\n\r timer_FCTN_EPS_HANDLE_HW_FAULTS is %f",timer_FCTN_EPS_HANDLE_HW_FAULTS.read());
                    pc.printf("\n\r timer_FCTN_EPS_HANDLE_CDMS_FAULT is %f",timer_FCTN_EPS_HANDLE_CDMS_FAULT.read());
                    pc.printf("\n\r timer_FCTN_APPEND_HKDATA is %f",timer_FCTN_APPEND_HKDATA.read());
                    pc.printf("\n\r timer_minMaxHkData is %f",timer_minMaxHkData.read());
                    */
                }
            //time_wdog = 0;
        }
    if(schedcount%6==0)
        {
            if(BAE_STANDBY==0x04 || BAE_STANDBY==0x05 || BAE_STANDBY==0x06 || BAE_STANDBY==0x07)
                {    
                    pc.printf("\n reahed here working till stage one bcn");
                    //  time_wdog = 0;
                    timer_F_BCN.reset();
                    timer_F_BCN.start();
                    F_BCN();
                    timer_F_BCN.stop();
                    /*pc.printf("\n\r timer_F_BCN is %f",timer_F_BCN.read());
                    pc.printf("\n\r timer_Init_BEACON_HW is %f",timer_Init_BEACON_HW.read());
                    pc.printf("\n\r timer_FCTN_BCN_TX_MAIN is %f",timer_FCTN_BCN_TX_MAIN.read());
                    pc.printf("\n\r timer_Set_BCN_TX_STATUS_SUCCESS is %f",timer_Set_BCN_TX_STATUS_SUCCESS.read());
                    pc.printf("\n\r timer_Set_BCN_TX_STATUS_FAILURE is %f",timer_Set_BCN_TX_STATUS_FAILURE.read());
                    pc.printf("\n\r timer_Set_BCN_TX_STATUS_DISABLED is %f",timer_Set_BCN_TX_STATUS_DISABLED.read());
                    pc.printf("\n\r timer_Set_BCN_TX_STATUS_SUSPENDED is %f",timer_Set_BCN_TX_STATUS_SUSPENDED.read());
                    pc.printf("\n\r timer_Set_BCN_TX_STATUS_RF_SILENCE is %f",timer_Set_BCN_TX_STATUS_RF_SILENCE.read());
                */}
        }
    schedcount++;
    #if print
        printf("\n\r exited scheduler h");
        printf("\n\r time taken %f",t_start.read());
    #endif
}


Timer t_flag;


void FLAG()
{
    
//I2C
    //if(BAE_MNG_I2C_STATUS == 1)
    //    BAE_STATUS = BAE_STATUS | 0x10000000;
    //else if(BAE_MNG_I2C_STATUS == 0)
    //    BAE_STATUS &= 0xEFFFFFF;

//.............bae..................//
    if(BAE_INIT_STATUS == 1)
        BAE_STATUS = BAE_STATUS | 0x00000001; //BAE_STATUS |= 0x00000001;
    else if(BAE_INIT_STATUS == 0)
        BAE_STATUS &= 0xFFFFFFFE;
        
    if(BAE_MNG_I2C_STATUS == 1)   
        BAE_STATUS = BAE_STATUS | 0x00000002;
    if(BAE_MNG_I2C_STATUS == 0)   
        BAE_STATUS &= 0xFFFFFFFD;    

//.............acs..................//    
    if(ACS_INIT_STATUS == 1)
        BAE_STATUS = BAE_STATUS | 0x00000080;  //set ACS_INIT_STATUS flag
    else if(ACS_INIT_STATUS == 0)
        BAE_STATUS &= 0xFFFFFF7F;              //clear ACS_INIT_STATUS flag 
    
    if(ACS_DATA_ACQ_STATUS == 1)
        BAE_STATUS =BAE_STATUS | 0x00000100;     //set ACS_DATA_ACQ_STATUS flag
    else if(ACS_DATA_ACQ_STATUS == 0)
        BAE_STATUS &= 0xFFFFFEFF;      //clear ACS_DATA_ACQ_STATUS flag    
    
    if(ACS_ATS_ENABLE == 1)
        BAE_ENABLE |= 0x00000004;
    else if(ACS_ATS_ENABLE == 0)
        BAE_ENABLE = BAE_ENABLE &0xFFFFFFFB | 0x00000004;
    
    if(ACS_DATA_ACQ_STATUS == 'f')
        BAE_STATUS |= 0x00000200;
    
    if(ACS_MAIN_STATUS == 1)
        BAE_STATUS = (BAE_STATUS | 0x00001000);     //set ACS_MAIN_STATUS flag
   else if(ACS_MAIN_STATUS == 0)
        BAE_STATUS &= 0xFFFFEFFF;     //clear ACS_MAIN_STATUS flag 
    
    if(ACS_STATUS == '0')
        BAE_STATUS = (BAE_STATUS & 0xFFFF1FFF);                // set ACS_STATUS = ACS_CONTROL_OFF
    else if(ACS_STATUS == '1')
        BAE_STATUS =(BAE_STATUS & 0xFFFF1FFF) | 0x00002000;                    // set ACS_STATUS = ACS_LOW_POWER
    else if(ACS_STATUS == '2')
        BAE_STATUS = (BAE_STATUS & 0xFFFF1FFF)| 0x00004000;                    // set ACS_STATUS = ACS_ZAXIS_MOMENT_ONLY  
    else if(ACS_STATUS == '3') 
        BAE_STATUS = (BAE_STATUS & 0xFFFF1FFF) | 0x00006000;                    // set ACS_STATUS = ACS_DATA_ACQ_FAILURE
    else if(ACS_STATUS == '4')
        BAE_STATUS = (BAE_STATUS & 0xFFFF1FFF) | 0x00008000;                    // set ACS_STATUS = ACS_NOMINAL_ONLY
    else if(ACS_STATUS == '5')
        BAE_STATUS =(BAE_STATUS & 0xFFFF1FFF) | 0x0000A000;                    // set ACS_STATUS = ACS_AUTO_CONTROL
    else if(ACS_STATUS == '6')
        BAE_STATUS =(BAE_STATUS & 0xFFFF1FFF) | 0x0000C000;                    // set ACS_STATUS = ACS_DETUMBLING_ONLY  
    else 
        BAE_STATUS =(BAE_STATUS & 0xFFFF1FFF) | 0x0000E000;                    // set ACS_STATUS = INVALID STATE 
        
    if(ACS_STATE == '0')
        BAE_ENABLE = (BAE_ENABLE & 0xFFFFFF8F);                                         //ACS_STATE = ACS_CONTROL_OFF
    else if(ACS_STATE == '2')
        BAE_ENABLE = ((BAE_ENABLE & 0xFFFFFF8F)| 0x00000020);                              //   ACS_STATE = ACS_ZAXIS_MOMENT_ONLY  
    else if(ACS_STATE == '3')
        BAE_ENABLE = ((BAE_ENABLE & 0xFFFFFF8F)| 0x00000030);                              //  set ACS_STATUS = ACS_DATA_ACQ_FAILURE
    else if(ACS_STATE == '4')
        BAE_ENABLE = ((BAE_ENABLE & 0xFFFFFF8F)| 0x00000040);                              //  ACS_STATE = ACS_NOMINAL_ONLY
    else if(ACS_STATE == '5')
        BAE_ENABLE = ((BAE_ENABLE & 0xFFFFFF8F)| 0x00000050);                              //    ACS_STATE = ACS_AUTO_CONTROL
    else if(ACS_STATE == '6')
        BAE_ENABLE = ((BAE_ENABLE & 0xFFFFFF8F)| 0x00000060);                             //ACS_STATE = ACS_DETUMBLING_CONTROL
        
//...............eps......................//
    if (EPS_INIT_STATUS==1)                                  // Set EPS_INIT_STATUS
        BAE_STATUS |= 0x00010000;                     
    else if(EPS_INIT_STATUS==0)                              // Clear
        BAE_STATUS &= 0xFFFEFFFF;


    if (EPS_MAIN_STATUS==1)                              // Set EPS_MAIIN_STATUS
        BAE_STATUS |= 0x00040000;
    else if(EPS_MAIN_STATUS==0)                          // Clear
        BAE_STATUS &= 0xFFFBFFFF;


    if (EPS_BATTERY_GAUGE_STATUS==1)              // Set EPS_BATTERY_GAUGE_STATUS
        BAE_STATUS |= 0x00020000;
    else if(EPS_BATTERY_GAUGE_STATUS==0)          // Clear
        BAE_STATUS &= 0xFFFDFFFF;

    if (EPS_BTRY_TMP_STATUS==1)             // Set EPS_BATTERY_TEMP_STATUS
        BAE_STATUS |= 0x00080000;
    else if(EPS_BTRY_TMP_STATUS==0)       // Clear
        BAE_STATUS &= 0xFFF7FFFF;

    if (EPS_STATUS==0)
        BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF);                             // Set EPS_ERR_BATTERY_TEMP
    else if (EPS_STATUS==1)
        BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF)|0x00010000;           // Set EPS_BATTERY_HEATER_DISABLED
    else if (EPS_STATUS==2)
        BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF)|0x00020000;           // Set EPS_ERR_HEATER_SWITCH_OFF
    else if (EPS_STATUS==3)
        BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF)|0x00030000;          // Set EPS_ERR_HEATER_SWITCH_ON
    else if (EPS_STATUS==4)
        BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF)|0x00040000;          // Set EPS_BATTERY_HEATER_OFF
    else if (EPS_STATUS==5)
        BAE_STATUS = (BAE_STATUS & 0xFF8FFFFF)|0x00050000;          // Set EPS_BATTERY_HEATER_ON   
    
    if(EPS_BTRY_HTR_AUTO == 1)
        BAE_ENABLE |= 0x00000080;
    else if(EPS_BTRY_HTR_AUTO == 0)
        BAE_ENABLE = BAE_ENABLE &0xFFFFFF7;    
    
    #if print
        pc.printf("\n\r BAE status %x BAE ENABLE %x ",BAE_STATUS,BAE_ENABLE); 
    #endif
}


void FCTN_BAE_INIT()
{
    #if print
        printf("\n\r Initialising BAE _________________________________________________________________________________");
    #endif
    BAE_INIT_STATUS=1;
    FLAG();
    
    //..........intial status....//
    ACS_STATE = 4;
    ACS_ATS_ENABLE = 1;
    ACS_DATA_ACQ_ENABLE = 1;
    EPS_BTRY_HTR_AUTO = 1;
    actual_data.power_mode=3;
    
    //............intializing pins................//
    ATS1_SW_ENABLE = 1;
    ATS2_SW_ENABLE = 1;

    DRV_XY_EN = 1;
    DRV_Z_EN = 1;
    ACS_TR_Z_ENABLE = 1;
    ACS_TR_XY_ENABLE = 1;

    //time_wdog = 1;
    
    kick_WDOG();
    pc.printf("\n\r lvl1");
    
    //...........order mentioned in flow chart.................//
    timer_FCTN_BAE_INIT.reset();
    timer_FCTN_BAE_INIT.start();
    FCTN_ACS_INIT();
    timer_FCTN_BAE_INIT.stop();
    pc.printf("\n\r timer_FCTN_BAE_INIT is %f",timer_FCTN_BAE_INIT.read());
    
    timer_FCTN_EPS_INIT.reset();
    timer_FCTN_EPS_INIT.start();
    FCTN_EPS_INIT();
    timer_FCTN_EPS_INIT.stop();
    pc.printf("\n\r timer_FCTN_EPS_INIT is %f",timer_FCTN_EPS_INIT.read());
    
    timer_FCTN_BCN_INIT.reset();
    timer_FCTN_BCN_INIT.start();
    FCTN_BCN_INIT();
    timer_FCTN_BCN_INIT.stop();
    pc.printf("\n\r timer_FCTN_BCN_INIT is %f",timer_FCTN_BCN_INIT.read());
    
    //uint32_t data_flash=FCTN_BAE_RD_FLASH_ENTITY(0);/*sending the 0 entity as in mms tc/tm bae_reset_counter is present in first 32 bits */
    //uint32_t data_modify=data_flash & 0x000000FF;
    //data_modify +=1;
    //data_modify |=data_flash;
    //FCTN_BAE_WR_FLASH(0,data_modify);
    //#if print
    //    printf("\n\rthe number of reset %d",data_modify);
    //#endif
    BAE_INIT_STATUS=0;
    FLAG();
}


int main()
{
    //BAE_uptime.reset();
    BAE_uptime.start();
    //time_wdog = 1;
    pc.printf("\n\r BAE Activated. Testing Version 1.2 \n");
    //FLASH_INI();
    
    time_wdog=1;
    timer_FCTN_BAE_INIT.start();
    FCTN_BAE_INIT();
    timer_FCTN_BAE_INIT.stop();
    pc.printf("\n\r timer_FCTN_BAE_INIT is %f",timer_FCTN_BAE_INIT.read());
    
    time_wdog=0;
    
    //time_wdog = 0;

    slave.address(addr);
    irpt_2_mstr = 0;
    
    ptr_t_i2c = new Thread(T_TC);
    ptr_t_i2c->set_priority(osPriorityHigh);////osPriorityRealtime
        
    irpt_4m_mstr.enable_irq();
    irpt_4m_mstr.rise(&FCTN_I2C_ISR);
    
    RtosTimer t_sc_timer(T_SC,osTimerPeriodic);               // Initiating the scheduler thread
    t_sc_timer.start(5000);
    t_start.start();
    
    #if print
        pc.printf("\n\rStarted scheduler %f\n\r",t_start.read()); 
    #endif
    /*if one defines it dynamically then one has to take care that the destuct function is calle everytime BAE resets otheriwse it will lead to memory leakage*/
    //BAE_STANDBY_STATUS_TIMER = new RtosTimer(BAE_STANDBY_STATUS_RESET,osTimerOnce);    
    /*static allocation*/
    RtosTimer STANDBY_TIMER(BAE_STANDBY_STATUS_RESET,osTimerOnce);
    BAE_STANDBY_STATUS_TIMER=&STANDBY_TIMER;
    
    RtosTimer bcn_start_timer(FCTN_BCN_FEN,osTimerOnce);
    /*later change it to 30 min 1800 seconds*/
    bcn_start_timer.start(20000);
   
   //BCN HTR TIMERS
    RtosTimer EPS_HTR_OFF_TIMER(FCTN_EPS_HTR_OFF, osTimerOnce);
    HTR_OFF=&EPS_HTR_OFF_TIMER;
    
    RtosTimer EPS_HTR_CYCLE_TIMER(FCTN_EPS_HTR_CYCLE, osTimerPeriodic);
    HTR_CYCLE=&EPS_HTR_CYCLE_TIMER;
    
    RtosTimer EPS_HTR_DLY_TIMER(FCTN_EPS_HTR_DLY,osTimerOnce);
    HTR_DLY=&EPS_HTR_DLY_TIMER;
    
    timer_FLASH_INI.start();
    FLASH_INI();
    timer_FLASH_INI.stop();
    pc.printf("\n\r timer_FCTN_BAE_INIT is %f",timer_FCTN_BAE_INIT.read());
   
while(1);                                                   //required to prevent main from terminating

}