#include "EPS.h"
#include "pin_config.h"
#include "iostream"
/***********************************************global variable declaration***************************************************************/
extern uint32_t BAE_STATUS;
extern uint32_t BAE_ENABLE;
extern uint8_t BAE_data[74];
extern char BAE_chardata[74];   

//m_I2C.frequency(10000)
const char RCOMP0= 0x97;// don't know what it is now 
BAE_HK_actual actual_data;
BAE_HK_quant quant_data;
BAE_HK_min_max bae_HK_minmax;
BAE_HK_arch arch_data;


//......................................Peripheral declarations.........................................................//
Serial pc_eps(USBTX,USBRX);

I2C m_I2C(PIN85,PIN84);
DigitalOut TRXY(TRXY_DR_EN);            //active high
DigitalOut TRZ(TRZ_DR_EN);              //active high
DigitalOut EN3V3A(ENBL3V3A);
DigitalOut EN_BTRY_HT(BATT_HEAT);
//DigitalIn BTRY_HT_OUTPUT(BATT_HEAT_OUTPUT);
//AnalogIn Vbatt_ang(VBATT);
AnalogIn Batt_voltage(PIN20);   //Battery voltage

SPI spi_bt(PIN99,PIN100,PIN98); //MOSI,MISO,SLK // battery temp something 3
DigitalOut ssn1(PIN19); //Slave select1 // low line master talks
DigitalOut ssn2(PIN21);//Slave select2
//DigitalOut PS(PTB0);
//DigitalOut HS(PTB1);

AnalogIn CurrentInput(PIN54); // Input from Current Multiplexer //PIN54
AnalogIn VoltageInput(PIN53); // Input from Voltage Multiplexer //PIN53
AnalogIn BAE_temp_sensor(PIN55); //Input from BAE temp sensor

/*mux for reading value one by one*/
DigitalOut SelectLinea3 (PIN46); // MSB of Select Lines
DigitalOut SelectLinea2 (PIN45);
DigitalOut SelectLinea1 (PIN44);
DigitalOut SelectLinea0 (PIN43); // LSB of Select Lines

DigitalOut SelectLineb3 (PIN56); // MSB of Select Lines
DigitalOut SelectLineb2 (PIN57);
DigitalOut SelectLineb1 (PIN58);
DigitalOut SelectLineb0 (PIN59); // LSB of Select Lines

//*********************************************************flags********************************************************//
extern uint8_t EPS_INIT_STATUS ;
extern uint8_t EPS_BATTERY_GAUGE_STATUS ;
extern uint8_t EPS_MAIN_STATUS;
extern uint8_t EPS_BATTERY_TEMP_STATUS ;
extern uint8_t EPS_STATUS ;

extern uint8_t EPS_BATTERY_HEATER_ENABLE ;

//eps cdms fault
extern uint8_t CDMS_SW_STATUS;
extern bool CDMS_OC_FAULT;
extern bool CDMS_SW_ENABLE;
extern int CDMS_FAULT_COUNTER;

//eps hw faults

extern uint8_t ACS_TR_Z_SW_STATUS;
extern bool ACS_TR_Z_ENABLE;
extern bool ACS_TR_Z_OC_FAULT;
extern bool ACS_TR_Z_FAULT;            //Driver IC fault
extern int ACS_TR_Z_FAULT_COUNTER;

extern uint8_t ACS_TR_XY_SW_STATUS;
extern bool ACS_TR_XY_ENABLE;
extern bool ACS_TR_XY_OC_FAULT;
extern bool ACS_TR_XY_FAULT;            //Driver IC fault
extern int ACS_TR_XY_FAULT_COUNTER;

extern uint8_t ACS_ATS1_SW_STATUS;
extern bool ACS_ATS1_ENABLE;
extern bool ACS_ATS1_OC_FAULT;
extern int ACS_ATS1_FAULT_COUNTER;

extern uint8_t ACS_ATS2_SW_STATUS;
extern bool ACS_ATS2_ENABLE;
extern bool ACS_ATS2_OC_FAULT;
extern int ACS_ATS2_FAULT_COUNTER;

extern uint8_t BCN_TX_SW_STATUS;
extern bool BCN_TX_ENABLE;
extern bool BCN_TX_OC_FAULT;
extern int BCN_TX_FAULT_COUNTER;


//........................................... FUCTIONS.................................................//

void FCTN_EPS_INIT()
{
    printf("\n\r eps init \n");
    EPS_INIT_STATUS = 1 ;             //set EPS_INIT_STATUS flag
    // FLAG();
    FCTN_BATTERYGAUGE_INIT();
    EN3V3A = 1;                             //enable dc dc converter A  
    char value=alertFlags(); // initialization part of battery gauge
    unsigned short value_u= (short int )value;
    value_u &=0x0001;                     
    if(value_u ==0x0001)                       // battery gauge not initialised
    {
        actual_data.power_mode = 1;
        EPS_BATTERY_GAUGE_STATUS = 0;               //clear EPS_BATTERY_GAUGE_STATUS
    }
    else
    {
        actual_data.Batt_gauge_actual[1] = soc();
        actual_data.Batt_voltage_actual = Batt_voltage.read()*3.3; //1 corresponds to 3.3 scaling factor
        FCTN_EPS_POWERMODE(actual_data.Batt_gauge_actual[1]);
        EPS_BATTERY_GAUGE_STATUS = 1;               //set EPS_BATTERY_GAUGE_STATUS
    }
   
    FCTN_BATTTEMP_INIT();
    EPS_BATTERY_GAUGE_STATUS = 1;
    
    EPS_INIT_STATUS = 0 ;             //clear EPS_INIT_STATUS flag

}

void FCTN_EPS_HANDLE_CDMS_FAULT()
{   //Variable names from MMS structure, if not, marked as //Temp name
    if(CDMS_SW_STATUS == 0b11)          //powered on and oc fault
        if(!CDMS_OC_FAULT)   
           CDMS_SW_STATUS = 0b01;       //powered on and working
    else
    {
        if(CDMS_SW_STATUS == 0b10)      //powered off and oc fault        
            CDMS_SW_ENABLE = 1;         //Temp name
        if(CDMS_OC_FAULT == 0)
        {
            CDMS_FAULT_COUNTER = 0;     //Temp name
            CDMS_SW_STATUS = 0b01;      //powered on and working
        }
        else
        {
            CDMS_FAULT_COUNTER++;
            if(CDMS_FAULT_COUNTER == 3)
                CDMS_SW_STATUS = 0b11;  //powered on and oc fault
            else
            {
                CDMS_SW_ENABLE = 0;         //power OFF switch
                CDMS_SW_STATUS = 0b10;      //powered off and oc fault   
            }
        }
    }     
}

void FCTN_EPS_HANDLE_HW_FAULTS()
{   //Variable names from MMS structure, if not, marked as //Temp name
    
    //--------ACS_TR_Z--------//
    if(ACS_TR_Z_SW_STATUS != 0b11)          //!disabled
    {
        if(ACS_TR_Z_SW_STATUS == 0b10)      //oc fault and powered off
            ACS_TR_Z_ENABLE = 1;
        if(ACS_TR_Z_OC_FAULT || ACS_TR_Z_FAULT)
        {
            ACS_TR_Z_ENABLE = 0;
            ACS_TR_Z_FAULT_COUNTER++;       //Temp name
            if(ACS_TR_Z_FAULT_COUNTER == 3)
                ACS_TR_Z_SW_STATUS = 0b11;  //disabled
                //update in flash as default state at bootup
            else ACS_TR_Z_SW_STATUS = 0b10; //oc fault and powered off
        }
        else
        {
            ACS_TR_Z_SW_STATUS = 0b01;      //powered on and working;
            //update in flash also
            ACS_TR_Z_FAULT_COUNTER = 0;
        }
    }
    
    //--------ACS_TR_XY--------//
    //Same as ACS_TR_Z, just replace Z with XY
    
    //--------ACS_ATS1--------//
    //Same as ACS_ATS2
    
    //--------ACS_ATS2--------//
    if(ACS_ATS2_SW_STATUS & 0b1100 != 0b1100)          //!disabled
    {
        if(ACS_ATS2_SW_STATUS & 0b1100 == 0b1000)      //oc fault and powered off
            ACS_ATS2_ENABLE = 1;                       //Temp name
        if(ACS_ATS2_OC_FAULT)
        {
            ACS_ATS2_ENABLE = 0;
            ACS_ATS2_FAULT_COUNTER++;                  //Temp name
            if(ACS_ATS2_FAULT_COUNTER == 3)
                ACS_ATS2_SW_STATUS = ACS_ATS2_SW_STATUS | 0b1100;  //disabled
                //update in flash as default state at bootup
            else 
            {
                ACS_ATS2_SW_STATUS = ACS_ATS2_SW_STATUS | 0b1000; //setting to 10xx
                ACS_ATS2_SW_STATUS = ACS_ATS2_SW_STATUS & 0b1011; //oc fault and powered off
            }
        }
        else
        {
            if(ACS_ATS2_SW_STATUS & 0b1100 == 0b1000)             //Device oc fault?
                ACS_ATS2_ENABLE = 0;
            ACS_ATS2_SW_STATUS = ACS_ATS2_SW_STATUS & 0b0011;     //working but powered off
            //Update in flash also
            ACS_ATS2_FAULT_COUNTER = 0;
        }
    }
    
    //--------BCN_TX----------//
    if(BCN_TX_SW_STATUS != 0b11)          //!disabled
    {
        if(BCN_TX_SW_STATUS == 0b10)      //oc fault and powered off
            BCN_TX_ENABLE = 1;            //Temp name
        if(BCN_TX_OC_FAULT)
        {
            BCN_TX_ENABLE = 0;
            BCN_TX_FAULT_COUNTER++;       //Temp name
            if(BCN_TX_FAULT_COUNTER == 3)
                BCN_TX_SW_STATUS = 0b11;  //disabled
                //update in flash as default state at bootup
            else BCN_TX_SW_STATUS = 0b10; //oc fault and powered off
        }
        else
        {
            BCN_TX_SW_STATUS = 0b01;      //powered on and working;
            //update in flash also
            BCN_TX_FAULT_COUNTER = 0;
        }
    }
    
}

//----------------------------------------------------Power algo code--------------------------------------------------------------------//
/*update the power modes*/

void FCTN_EPS_POWERMODE(float soc)              //dummy algo
{
    if(soc >= 80)
        actual_data.power_mode = 4;
    else if(soc >= 70 & soc < 80)
        actual_data.power_mode = 3;
    else if(soc >= 60 & soc < 70)
        actual_data.power_mode = 2;
    else if(soc < 60)
        actual_data.power_mode = 1;
}

//...................................................HK...........................................//
/*reading values*/

void FCTN_HK_MAIN()
{
    int Iteration=0;

    SelectLinea0=0;
    SelectLinea1=0;
    SelectLinea2=0;
    SelectLinea3=0;

    SelectLineb0=0;
    SelectLineb1=0;
    SelectLineb2=0;
    SelectLineb3=0;
    
      //collecting data
    for(Iteration=0; Iteration<16; Iteration++)
    {
            actual_data.voltage_actual[Iteration]=VoltageInput.read();
            actual_data.current_actual[Iteration]=CurrentInput.read();
           
            SelectLinea0=!(SelectLinea0);
            if(Iteration%2==1)
                SelectLinea1=!(SelectLinea1);
            if(Iteration%4==3)
                SelectLinea2=!(SelectLinea2);
            if(Iteration%8==7)
                SelectLinea3=!(SelectLinea3);
                int s0,s1,s2,s3;
            s0=SelectLineb0=SelectLinea0;
            s1=SelectLineb1=SelectLinea2;
            s2=SelectLineb2=SelectLinea2;
            s3=SelectLineb3=SelectLinea3;
            printf("\n\r  %d %d %d %d", s0,s1,s2,s3);

    }
      for(Iteration=0; Iteration<16; Iteration++)
    {
        if(Iteration==14)
            actual_data.voltage_actual[Iteration]= (-90.7*3.3*actual_data.voltage_actual[Iteration])+190.1543;
        else
            actual_data.voltage_actual[Iteration]= actual_data.voltage_actual[Iteration]*3.3*5.63;
    }
        
    for(Iteration=0;Iteration<12;Iteration++){
        if(Iteration<8)
            actual_data.current_actual[Iteration]= actual_data.current_actual[Iteration]*3.3/(50*rsens);
        else
            actual_data.current_actual[Iteration]=actual_data.current_actual[Iteration]*3.3;
            int resistance;       
             
            resistance=24000*actual_data.current_actual[Iteration]/(3.3-actual_data.current_actual[Iteration]);
            if(actual_data.current_actual[Iteration]>1.47) 
            {
                actual_data.current_actual[Iteration]=3694/log(24.032242*resistance);
            }
            else{
                
                actual_data.current_actual[Iteration]=3365.4/log(7.60573*resistance);
            }
    }
    actual_data.BAE_temp_actual=(-90.7*3.3*actual_data.BAE_temp_actual)+190.1543;
    
    actual_data.Batt_voltage_actual=Batt_voltage.read()*3.3*5.63;

    //quantizing data
    for(Iteration=0; Iteration<16; Iteration++){

        if(Iteration==14)
            quant_data.voltage_quant[Iteration]=quantiz(tstart,tstep,actual_data.voltage_actual[Iteration]);
        else
            quant_data.voltage_quant[Iteration]=quantiz(vstart,vstep,actual_data.voltage_actual[Iteration]);
        
    }
    for(Iteration=0;Iteration<12;Iteration++){
        if(Iteration<8)
            quant_data.current_quant[Iteration]=quantiz(cstart,cstep,actual_data.current_actual[Iteration]);
        else
            quant_data.current_quant[Iteration]=quantiz(tstart_thermistor,tstep_thermistor,actual_data.current_actual[Iteration]);
     }       
    for(Iteration=0;Iteration<2;Iteration++){
        
        quant_data.Batt_temp_quant[Iteration]=quantiz(tstart,tstep,actual_data.Batt_temp_actual[Iteration]);
    }
    
    quant_data.Batt_gauge_quant[0]=quantiz(vcell_start,vcell_step,actual_data.Batt_gauge_actual[0]);
    quant_data.Batt_gauge_quant[1]=quantiz(soc_start,soc_step,actual_data.Batt_gauge_actual[1]);
    quant_data.Batt_gauge_quant[2]=quantiz(crate_start,crate_step,actual_data.Batt_gauge_actual[2]);
    quant_data.Batt_gauge_alerts=actual_data.Batt_gauge_actual[3];
    
    quant_data.BAE_temp_quant=quantiz(tstart,tstep,actual_data.BAE_temp_actual);
    
    for(Iteration=0;Iteration<3;Iteration++){
        quant_data.AngularSpeed_quant[Iteration]=actual_data.AngularSpeed_actual[Iteration];
        printf("\n\r w value %f",quant_data.AngularSpeed_quant[Iteration]);
    }
    
    for(Iteration=0;Iteration<3;Iteration++){
        quant_data.Bvalue_quant[Iteration]=actual_data.Bvalue_actual[Iteration];
        printf("\n\r b value %f",quant_data.Bvalue_quant[Iteration]);
    }
    
    quant_data.Batt_voltage_quant=quantiz(vstart,vstep,actual_data.Batt_voltage_actual);
    
    
    arch_data.Batt_1_temp=quant_data.Batt_temp_quant[0];
    arch_data.Batt_2_temp=quant_data.Batt_temp_quant[1];
    arch_data.EPS_PCB_temp=quant_data.voltage_quant[14];
    arch_data.Batt_SOC=quant_data.Batt_gauge_quant[1];
    arch_data.power_mode=actual_data.power_mode;
    arch_data.faultPoll_status=actual_data.faultPoll_status;
    arch_data.faultIr_status=actual_data.faultIr_status;
    arch_data.Batt_voltage=quant_data.Batt_voltage_quant;    
    printf("\n\r in hk");
    
}

void FCTN_APPEND_HKDATA()
{
    // quantized data
    for (int i=0;i<16;i++)
        BAE_data[i] = quant_data.voltage_quant[i];
    for (int i=16;i<28;i++)
        BAE_data[i] = quant_data.current_quant[i-16];
    BAE_data[28] = quant_data.Batt_temp_quant[0];
    BAE_data[29] = quant_data.Batt_temp_quant[1]; 
    BAE_data[30] = quant_data.Batt_gauge_quant[1]; 
    BAE_data[31] = quant_data.Batt_gauge_quant[1]; 
    BAE_data[32] = quant_data.Batt_gauge_quant[1]; 
    FCTN_CONVERT_FLOAT(quant_data.Batt_gauge_alerts,&BAE_data[33]);
    BAE_data[37] = quant_data.BAE_temp_quant;
    FCTN_CONVERT_FLOAT(quant_data.AngularSpeed_quant[0],&BAE_data[38]); 
    //printf("\n\r outside %d %d %d %d", BAE_data[38],BAE_data[39],BAE_data[40],BAE_data[41]);
    //std:: cout << "\n\r uint8  outside " << BAE_data[38] << '\t' << BAE_data[39] << '\t' << BAE_data[40] << '\t' << BAE_data[41] <<std::endl; 
    FCTN_CONVERT_FLOAT(quant_data.AngularSpeed_quant[1],&BAE_data[42]); 
    //std:: cout << "\n\r uint8  outside " << BAE_data[42] << '\t' << BAE_data[43] << '\t' << BAE_data[44] << '\t' << BAE_data[45] <<std::endl;
    // printf("\n\r outside %d %d %d %d", BAE_data[42],BAE_data[43],BAE_data[44],BAE_data[45]);
    FCTN_CONVERT_FLOAT(quant_data.AngularSpeed_quant[2],&BAE_data[46]); 
     //printf("\n\r outside %d %d %d %d", BAE_data[46],BAE_data[47],BAE_data[48],BAE_data[49]);
    //std:: cout << "\n\r uint8  outside " << BAE_data[46] << '\t' << BAE_data[47] << '\t' << BAE_data[48] << '\t' << BAE_data[49] <<std::endl;
    FCTN_CONVERT_FLOAT(quant_data.Bvalue_quant[0],&BAE_data[50]); 
    FCTN_CONVERT_FLOAT(quant_data.Bvalue_quant[1],&BAE_data[54]); 
    FCTN_CONVERT_FLOAT(quant_data.Bvalue_quant[2],&BAE_data[58]); 
    BAE_data[62] = quant_data.Batt_voltage_quant;
    BAE_data[63] = (uint8_t)actual_data.power_mode;      
    BAE_data[64] = actual_data.faultPoll_status; 
    BAE_data[65] = actual_data.faultIr_status;
    // archived data
    BAE_data[66] = arch_data.Batt_1_temp;            //verify if uint8_t is right
    BAE_data[67] = arch_data.Batt_2_temp; 
    BAE_data[68] = arch_data.EPS_PCB_temp;
    BAE_data[69] = arch_data.Batt_SOC;           
    BAE_data[70] = (uint8_t)arch_data.power_mode;
    BAE_data[71] = arch_data.faultPoll_status; 
    BAE_data[72] = arch_data.faultIr_status;
    BAE_data[73] = arch_data.Batt_voltage;
    for(int i=0; i<73;i++)
        BAE_chardata[i] = (char)BAE_data[i];
    BAE_chardata[73] = '\0';
    printf("\n\r bae ats data %c %c %c", BAE_chardata[38],BAE_chardata[39],BAE_chardata[40]);
    printf("\n\r BAE data is %s", BAE_chardata);
    
}

uint8_t quantiz(float start,float step,float x)
{
    int y=(x-start)/step;
    if(y<=0)y=0;
    if(y>=255)y=255;
    return y;
}

bool firstCount=true;  // goes to EPS init


void saveMin(char x,char y){
    if(y<x){
        x=y;
    }

}
void saveMax(char x,char y){
    if (y>x)
    {
       x=y;
    }
}


void minMaxHkData(){
    if(firstCount==true){
        for (int i = 0; i < 16; ++i){    
        bae_HK_minmax.voltage_min[i] = quant_data.voltage_quant[i];
        bae_HK_minmax.voltage_max[i] = quant_data.voltage_quant[i];
        }
        for (int i = 0; i < 12; ++i){    
        bae_HK_minmax.current_min[i] = quant_data.current_quant[i];
        bae_HK_minmax.current_max[i] = quant_data.current_quant[i];   
        }

        for (int i = 0; i < 2; ++i){    
        bae_HK_minmax.Batt_temp_min[i] = quant_data.Batt_temp_quant[i];
        bae_HK_minmax.Batt_temp_max[i] = quant_data.Batt_temp_quant[i];
        }    
        for (int i = 0; i < 3; ++i){    
        bae_HK_minmax.Batt_gauge_min[i] = quant_data.Batt_gauge_quant[i];
        bae_HK_minmax.Batt_gauge_max[i] = quant_data.Batt_gauge_quant[i];
        }
        for (int i = 0; i < 3; ++i){    
        bae_HK_minmax.AngularSpeed_min[i] = quant_data.AngularSpeed_quant[i];
        bae_HK_minmax.AngularSpeed_max[i] = quant_data.AngularSpeed_quant[i];
        }
        for (int i = 0; i < 3; ++i){    
        bae_HK_minmax.Bvalue_min[i] = quant_data.Bvalue_quant[i];
        bae_HK_minmax.Bvalue_max[i] = quant_data.Bvalue_quant[i];
        }
        bae_HK_minmax.BAE_temp_min=quant_data.BAE_temp_quant;
        bae_HK_minmax.BAE_temp_max=quant_data.BAE_temp_quant;
        bae_HK_minmax.Batt_voltage_min=quant_data.Batt_voltage_quant;
        bae_HK_minmax.Batt_voltage_max=quant_data.Batt_voltage_quant;
          
    } 
    else {
        for (int i = 0; i < 16; ++i)
        {
            saveMin(bae_HK_minmax.voltage_min[i],quant_data.voltage_quant[i]);
            saveMax(bae_HK_minmax.voltage_max[i],quant_data.voltage_quant[i]);
        }
        for (int i = 0; i < 12; ++i)
        {
            saveMin(bae_HK_minmax.current_min[i],quant_data.current_quant[i]);
            saveMax(bae_HK_minmax.current_max[i],quant_data.current_quant[i]);
        }
        
        for (int i = 0; i < 2; ++i)
        {
            saveMin(bae_HK_minmax.Batt_temp_min[i],quant_data.Batt_temp_quant[i]);
            saveMax(bae_HK_minmax.Batt_temp_max[i],quant_data.Batt_temp_quant[i]);
        }
        for (int i = 0; i < 3; ++i)
        {
            saveMin(bae_HK_minmax.Batt_gauge_min[i], quant_data.Batt_gauge_quant[i]);
            saveMax(bae_HK_minmax.Batt_gauge_max[i], quant_data.Batt_gauge_quant[i]);
        }
        for (int i = 0; i < 3; ++i)
        {
            saveMin(bae_HK_minmax.AngularSpeed_min[i], quant_data.AngularSpeed_quant[i]);
            saveMax(bae_HK_minmax.AngularSpeed_max[i], quant_data.AngularSpeed_quant[i]);
        }
        for (int i = 0; i < 3; ++i)
        {
            saveMin(bae_HK_minmax.Bvalue_min[i], quant_data.Bvalue_quant[i]);
            saveMax(bae_HK_minmax.Bvalue_max[i], quant_data.Bvalue_quant[i]);
        }
        saveMin(bae_HK_minmax.BAE_temp_min,quant_data.BAE_temp_quant);
        saveMax(bae_HK_minmax.BAE_temp_max,quant_data.BAE_temp_quant);
        saveMin(bae_HK_minmax.Batt_voltage_min,quant_data.Batt_voltage_quant);
        saveMin(bae_HK_minmax.Batt_voltage_max,quant_data.Batt_voltage_quant);        
          
        
    }   
    firstCount=false;
}


//............................................BATTERY GAUGE......................................//
void FCTN_BATTERYGAUGE_INIT()
{
        disable_sleep();
        disable_hibernate();
        socChangeAlertEnabled(true); //enabling alert on soc changing by 1%
        emptyAlertThreshold(32);//setting empty alert threshold to 32% soc
        vAlertMinMaxThreshold();//set min, max value of Valrt register
        vResetThresholdSet();//set threshold voltage for reset
        vResetAlertEnabled(true);//enable alert on reset for V < Vreset
}

void FCTN_BATTERYGAUGE_MAIN(float Battery_parameters[4])
{
        printf("\n\r battery gauge \n");

        float temp=30;    //=Battery_temp  (from temp sensor on battery board)       //value of battery temperature in C currently given a dummy value. Should be updated everytime.
        tempCompensation(temp);
    
        
        Battery_parameters[0]=vcell();
        Battery_parameters[1]=soc();
        Battery_parameters[2]=crate();
       
        printf("\nVcell=%f",vcell());       //remove this for final code
        printf("\nSOC=%f",soc());           //remove this for final code
        printf("\nC_rate=%f",crate());      //remove this for final code

       
        if (alerting()== true)       //alert is on
        {   
            Battery_parameters[3]=alertFlags();
            clearAlert();//clear alert
            clearAlertFlags();//clear all alert flags
        }
        
}

unsigned short read(char reg)
    {
         
         //Create a temporary buffer
        char buff[2];
 
        //Select the register
        m_I2C.write(m_ADDR, &reg, 1, true);
 
        //Read the 16-bit register
        m_I2C.read(m_ADDR, buff, 2);
 
        //Return the combined 16-bit value
        return (buff[0] << 8) | buff[1];
    }
 

 

    
    void write(char reg, unsigned short data)
    {
        //Create a temporary buffer
        char buff[3];
 
        //Load the register address and 16-bit data
        buff[0] = reg;
        buff[1] = data >> 8;
        buff[2] = data;
 
        //Write the data
        m_I2C.write(m_ADDR, buff, 3);
    }
   
 
 
    // Command the MAX17049 to perform a power-on reset
    void reset()
    {
        //Write the POR command
        write(REG_CMD, 0x5400);
    }
    
    // Command the MAX17049 to perform a QuickStart
     void quickStart()
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_MODE);
  
        //Set the QuickStart bit
        value |= (1 << 14);
 
        //Write the value back out
        write(REG_MODE, value);
    }
    
    
   //disable sleep
   void disable_sleep()
    {
        unsigned short value = read(REG_MODE);
        value &= ~(1 << 13);
        write(REG_MODE, value);
    }
  
    //disable the hibernate  of the MAX17049
    void disable_hibernate()
    {
        write(REG_HIBRT, 0x0000);
    }
  
    
    // Enable or disable the SOC 1% change alert on the MAX17049
    void socChangeAlertEnabled(bool enabled)
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_CONFIG);
 
        //Set or clear the ALSC bit
        if (enabled)
            value |= (1 << 6);
        else
            value &= ~(1 << 6);
 
        //Write the value back out
        write(REG_CONFIG, value);
} 


void compensation(char rcomp)
{
    //Read the current 16-bit register value
    unsigned short value = read(REG_CONFIG);
 
    //Update the register value
    value &= 0x00FF;
    value |= rcomp << 8;
 
    //Write the value back out
    write(REG_CONFIG, value);
}

 
void tempCompensation(float temp)
{
    //Calculate the new RCOMP value
    char rcomp;
    if (temp > 20.0) {
        rcomp = RCOMP0 + (temp - 20.0) * -0.5;
    } else {
        rcomp = RCOMP0 + (temp - 20.0) * -5.0;
    }
 
    //Update the RCOMP value
    compensation(rcomp);
}

  // Command the MAX17049 to de-assert the ALRT pin
    void clearAlert()
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_CONFIG);
 
        //Clear the ALRT bit
        value &= ~(1 << 5);
 
        //Write the value back out
        write(REG_CONFIG, value);
    }
  
 
    //Set the SOC empty alert threshold of the MAX17049
    void emptyAlertThreshold(char threshold)
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_CONFIG);
 
        //Update the register value
        value &= 0xFFE0;
        value |= 32 - threshold;
 
        //Write the 16-bit register
        write(REG_CONFIG, value);
    }
    
    // Set the low and high voltage alert threshold of the MAX17049
    void vAlertMinMaxThreshold()
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_VALRT);
 
        //Mask off the old value
    
                value = 0x96D2;
     
        //Write the 16-bit register
        write(REG_VALRT, value);
    }

    
    // Set the reset voltage threshold of the MAX17049
    void vResetThresholdSet()
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_VRESET_ID);
 
        //Mask off the old //value
        value &= 0x00FF;//Dis=0
 
        value |= 0x9400;//corresponding to 2.5 V
    
 
        //Write the 16-bit register
        write(REG_VRESET_ID, value);
    }
    
    
    // Enable or disable the voltage reset alert on the MAX17049
     void vResetAlertEnabled(bool enabled)
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_STATUS);
    
        //Set or clear the EnVR bit
        if (enabled)
            value |= (1 << 14);
        else
            value &= ~(1 << 14);
 
        //Write the value back out
        write(REG_STATUS, value);
    }
 
    //Get the current alert flags on the MAX17049
    //refer datasheet-status registers section to decode it.
    char alertFlags()
    {
        //Read the 16-bit register value
        unsigned short value = read(REG_STATUS);
 
        //Return only the flag bits
        return (value >> 8) & 0x3F;
    }
    
    // Clear all the alert flags on the MAX17049
    void clearAlertFlags()
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_STATUS);
 
        //Clear the specified flag bits
        value &= ~( 0x3F<< 8);
 
        //Write the value back out
        write(REG_STATUS, value);
    }
    
    // Get the current cell voltage measurement of the MAX17049
    float vcell()
    {
        
        //Read the 16-bit raw Vcell value
        unsigned short value = read(REG_VCELL);
 
        //Return Vcell in volts
        return value * 0.000078125*2;
    }
    
    // Get the current state of charge measurement of the MAX17049 as a float
    float soc()
    {
      
         //Create a temporary buffer
        char buff[2];
         int ack = 1;
        //Select the register
        char reg = REG_SOC;         // cannot pass the hash defined values directly
        m_I2C.write(m_ADDR, &reg, 1, true);
        
 
        //Read the 16-bit register
       
        ack = m_I2C.read(m_ADDR, buff, 2);
            
        printf("\n\r acknow %d", ack);
 
        //Return SOC in percent
        if(ack == 0)
        return ((buff[0] << 8) | buff[1]) * 0.00390625;
        else 
        return 200;
    }
    
   
 
    // Get the current C rate measurement of the MAX17049
    float crate()
    {
        //Read the 16-bit raw C/Rate value
        short value = read(REG_CRATE);
 
        //Return C/Rate in %/hr
        return value * 0.208;
    }
    
    // Determine whether or not the MAX17049 is asserting the ALRT pin
    bool alerting()
    {
        //Read the 16-bit register value
        unsigned short value = read(REG_CONFIG);
 
        //Return the status of the ALRT bit
        if (value & (1 << 5))
            return true;
        else
            return false;
    }
    
//.............................Battery board Temp sensor........................//
void FCTN_BATTTEMP_INIT()
{
    ssn1=1;ssn2=1;
    //PS=0;
    //HS=0;
    spi_bt.format(8,3);
    spi_bt.frequency(1000000);
    EPS_BATTERY_TEMP_STATUS = 1;
} 

void FCTN_BATT_TEMP_SENSOR_MAIN(float temp[2])
{
    uint8_t MSB, LSB;
    int16_t bit_data;
    float sensitivity=0.0078125;   //1 LSB = sensitivity degree celcius
    wait_ms(320);
    ssn1=0;

    spi_bt.write(0x80);//Reading digital data from Sensor 1
    LSB = spi_bt.write(0x00);//LSB first
    wait_ms(0);
    MSB = spi_bt.write(0x00);
    wait_ms(10);
    pc_eps.printf("%d %d\n",MSB,LSB);
    bit_data= ((uint16_t)MSB<<8)|LSB;
    wait_ms(10);
    temp[0]=(float)bit_data*sensitivity;//Converting into decimal value 
    ssn1=1;
    wait_ms(10);
    ssn2=0;//Reading data from sensor 2
    spi_bt.write(0x80);
    LSB = spi_bt.write(0x00);
    wait_ms(10);
    MSB = spi_bt.write(0x00);
    wait_ms(10);
    bit_data= ((int16_t)MSB<<8)|LSB;
    wait_ms(10);
    temp[1]=(float)bit_data*sensitivity;
    ssn2=1;
    
}