
#include "BCN.h"
#include <stdio.h>
#include "pin_config.h"
//Check the pin names
//Takes max 4.3 sec in void FCTN_BCN_TX_MAIN() (temp.calc. + long_beacon + short_beacon) 

Serial pc_bcn(USBTX, USBRX);        //tx,rx
SPI spi(PIN16, PIN17, PIN15);              // mosi, miso, sclk 
DigitalOut cs(PIN6);                //slave select or chip select
Timer t_i;
Timeout rf_sl_timeout;
Ticker loop;


//GLOBAL VARIABLES
uint8_t BCN_INIT_STATUS = 0;
uint8_t BCN_TX_MAIN_STATUS = 0;
uint8_t BCN_TX_STATUS = 0;
uint8_t BCN_TX_EN = 1;              //hardcoding for now    //check where is this variable toggled??
uint8_t BCN_FEN = 0;                //hardcoding for now    //write this value to flash
uint8_t BCN_STANDBY = 0;            //hardcoding for now    //check where is this variable toggled??
uint8_t BCN_TS_BUFFER = 0;              // For Temperature 
uint8_t BCN_FAIL_COUNT=0;

void FCTN_BCN_INIT()
{
    pc_bcn.printf("FCTN_BCN_INIT\n");
    BCN_INIT_STATUS = 1;
    if(BCN_FEN == 0)
        rf_sl_timeout.attach(&FCTN_BCN_FEN, 30);
    Init_BEACON_HW();
    BCN_INIT_STATUS = 0;
}
void FCTN_BCN_FEN()
{
    pc_bcn.printf("FCTN_FEN\n");
    BCN_FEN = 1;//write this value to flash
}
void FCTN_BCN_TX_MAIN()
{
    pc_bcn.printf("FCTN_BCN_TX_MAIN\n");
    t_i.start();
    int begin = t_i.read_us();
    BCN_TX_MAIN_STATUS = 1;
    
    if(BCN_FEN == 1)
    {
        if(BCN_TX_EN == 1)
        {
            //Measure and store BCN temperature in BCN_TS_BUFFER
            BCN_TS_BUFFER = check_Temperature();
            pc_bcn.printf("\n\ntemperature = %d\n\n",BCN_TS_BUFFER);
            //Get BCN_HK data from BCN HW(SPI) //Store BCN_HK data in BCN_HK_BUFFER
            if(BCN_STANDBY == 1 )
            {
                Set_BCN_TX_STATUS(BCN_TX_STANDBY);
                BCN_TX_MAIN_STATUS = 0;
                
                // break;
            }
            else
            {       
                    //transmit short beacon and long beacon
                    //SHORT_BCN_TX();
                    LONG_BCN_TX();
                    
                    if(Check_ACK_RECEIVED() == 1)
                    {
                        Set_BCN_TX_STATUS(BCN_TX_SUCCESS);
                        BCN_TX_MAIN_STATUS = 0;   
                    }
                    else
                    {
                        Set_BCN_TX_STATUS(BCN_TX_FAILURE);
                        BCN_TX_MAIN_STATUS = 0;
                        BCN_FAIL_COUNT+=1;
                        
                    }
             }
        }
        else
        {
            Set_BCN_TX_STATUS(BCN_TX_DISABLED);
            BCN_TX_MAIN_STATUS = 0;
        }
    }
    else
    {
        Set_BCN_TX_STATUS(BCN_RF_SILENCE);  //Window of RF Silence: None of the Txs should be on.
        BCN_TX_MAIN_STATUS = 0;
    }
    t_i.stop();
    int end = t_i.read_us();
    pc_bcn.printf("The time required for FCTN_BCN_TX_MAIN is %d useconds\r\n", end-begin);
    
}

void Set_BCN_TX_STATUS(uint8_t STATUS)
{
    BCN_TX_STATUS = STATUS;
}

uint8_t check_Temperature()
{   
    uint8_t temperature;
    writereg(RF22_REG_0F_ADC_CONFIGURATION,0x00);            
    writereg(RF22_REG_12_Temperature_Sensor_Calibration,0x20);
    writereg(RF22_REG_0F_ADC_CONFIGURATION,0x80);
    wait(0.1);
    temperature = readreg(RF22_REG_11_ADC_Value);
    temperature = (float)temperature*0.5 - 64;
    return temperature;
}

void SHORT_BCN_TX()
{
    writereg(RF22_REG_6E_TX_DATA_RATE,0x01);
    writereg(RF22_REG_6F_TX_DATA_RATE,0x50);//160bps
    writereg(RF22_REG_3E_PACKET_LENGTH,SHORT_TX_DATA); //short packet length 
    wait(0.02);      
                                                                           
    uint32_t timeout_count = 10e5;
    //extract values from short_beacon[]
    
    struct Short_beacon
    {
        uint8_t Voltage[1];
        uint8_t AngularSpeed[2];
        uint8_t SubsystemStatus[1];
        uint8_t Temp[3];
        uint8_t ErrorFlag[1];
    }Shortbeacon = { {0x88}, {0x99, 0xAA} , {0xAA},{0xAA,0xDD,0xEE}, {0x00} };
    
    //filling hk data
    //uint8_t short_beacon[] = { 0xAB, 0x8A, 0xE2, 0xBB, 0xB8, 0xA2, 0x8E,Shortbeacon.Voltage[0],Shortbeacon.AngularSpeed[0], Shortbeacon.AngularSpeed[1],Shortbeacon.SubsystemStatus[0],Shortbeacon.Temp[0],Shortbeacon.Temp[1],Shortbeacon.Temp[2],Shortbeacon.ErrorFlag[0]};
    uint8_t short_beacon[] = { 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,Shortbeacon.Voltage[0],Shortbeacon.AngularSpeed[0], Shortbeacon.AngularSpeed[1],Shortbeacon.SubsystemStatus[0],Shortbeacon.Temp[0],Shortbeacon.Temp[1],Shortbeacon.Temp[2],Shortbeacon.ErrorFlag[0]};
           
    clearTxBuf();     
    //writing data first time
    int byte = 0;
    cs = 0;
    spi.write(0xFF);   

    for (int byte_counter = 0; byte_counter <15 ; byte_counter++)
    {
        for(int j = 3; j >= 0 ; j--)
        {
            if((short_beacon[byte_counter] & (uint8_t) pow(2.0,(j*2+1)))!= pow(2.0,(j*2+1)))
            {
                byte=0x00;
            }
            else
            { 
                byte=0xF0;
            }  
            if((short_beacon[byte_counter] & (uint8_t) pow(2.0,j*2))!= pow(2.0,j*2))
            {
                byte=byte | 0x00;
            }
            else
            { 
               byte=byte | 0x0F;
            }
            spi.write(byte);
         }
    }   
    
    cs = 1;
    
    //Set to Tx mode
    writereg(RF22_REG_07_OPERATING_MODE1,0x08);//*
    wait(0.1);  
    //Check for fifoThresh
    while(timeout_count--)if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x20) == 0x20)break;
    timeout_count=10e5;
    
    //Check for packet_sent
    while(timeout_count--)if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x04) == 0x04)break;
    
    //pc_bcn.printf("Short packet sent\r\n");
    
    writereg(RF22_REG_07_OPERATING_MODE1,0x00);        //standby mode
    
}
void LONG_BCN_TX()
{
    writereg(RF22_REG_6E_TX_DATA_RATE,0x08);
    writereg(RF22_REG_6F_TX_DATA_RATE,0x31);//1000 bps
    writereg(RF22_REG_3E_PACKET_LENGTH,LONG_TX_DATA); //long packet length
    wait(0.02);                                                           
    uint32_t timeout_count=10e5;
   
    //get long_beacon array
    
    uint8_t Long_beacon[125];
    for(int i = 0;i<125;)
    {
        Long_beacon[i++] = 0xAA;
    }
   
   
   
    
    //setModeIdle();
    clearTxBuf();     
    //writing data first time
    cs = 0;
    spi.write(0xFF);   
    for(int i=0; i<60;i++)
    {
        spi.write(Long_beacon[i]);
    }
    cs = 1;
    
    //Set to Tx mode
    writereg(RF22_REG_07_OPERATING_MODE1,0x08);//*
    wait(0.1);
    
    //Check for fifoThresh
    while(timeout_count--)if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x20) == 0x20)break;
    timeout_count=10e5;
    
    cs = 0;
    spi.write(0xFF);   
    for(int i=60; i<125;i++)
    {
        spi.write(Long_beacon[i]);
    }
    cs = 1;
    wait(0.1);
    //Check for fifoThresh
    while(timeout_count--)if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x20) == 0x20)break;
    timeout_count=10e5;
    
    //Check for packetsent interrupt
    while(timeout_count--)if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x04) == 0x04)break;
         
    //pc_bcn.printf("Long packet sent\r\n");
    
    writereg(RF22_REG_07_OPERATING_MODE1,0x00);        //standby mode
}
void reset_rfm()
{
    FCTN_BCN_INIT();
}
void writereg(uint8_t reg,uint8_t val)
{
    uint8_t count = 0; 
    for(;;count++)
    {
        int read_val =0; cs = 0;spi.write(reg | 0x80);spi.write(val);cs = 1;
        if(reg != 0x7 && reg != 0x58 && reg != 0xF) 
        {        
            read_val = readreg(reg);
            if (read_val == val)
            {
                break;    
            }
            else if(count == 5)
            {
                reset_rfm(), printf("reg = 0x%X\n",reg);break;
            }
        }
        else
        break;
    }
}   
uint8_t readreg(uint8_t reg)
{
    uint8_t val;cs = 0;spi.write(reg & ~0x80);val = spi.write(0);cs = 1;return val;
}
void clearTxBuf()
{
    writereg(RF22_REG_08_OPERATING_MODE2,0x01);
    writereg(RF22_REG_08_OPERATING_MODE2,0x00);
}
uint8_t setFrequency(double centre)
{
    uint8_t fbsel = 0x40;
    if (centre >= 480.0) {
        centre /= 2;
        fbsel |= 0x20;
    } 
    centre /= 10.0;
    double integerPart = floor(centre);
    double fractionalPart = centre - integerPart;
 
    uint8_t fb = (uint8_t)integerPart - 24; // Range 0 to 23
    fbsel |= fb;
    uint16_t fc = fractionalPart * 64000;
    writereg(RF22_REG_73_FREQUENCY_OFFSET1, 0);  // REVISIT
    writereg(RF22_REG_74_FREQUENCY_OFFSET2, 0);
    writereg(RF22_REG_75_FREQUENCY_BAND_SELECT, fbsel);
    writereg(RF22_REG_76_NOMINAL_CARRIER_FREQUENCY1, fc >> 8);
    writereg(RF22_REG_77_NOMINAL_CARRIER_FREQUENCY0, fc & 0xff);
    return 0;
}


void Init_BEACON_HW()
{
    wait(0.1);
    cs=1;                          // chip must be deselected
    wait(0.1);
    spi.format(8,0);
    spi.frequency(10000000);       //10MHz SCLK
    
    //should either have a flag for invalid SPI or discard this for actual case or add reset
    if (readreg(RF22_REG_00_DEVICE_TYPE) == 0x08)
        pc_bcn.printf("spi connection valid\r\n");
    else
        {pc_bcn.printf("error in spi connection\r\n");
        reset_rfm();
        }
    
    writereg(RF22_REG_07_OPERATING_MODE1,0x80);        //sw_reset
    wait(0.1);                    //takes time to reset                                  

    clearTxBuf();                                                                                                                        
    
    writereg(RF22_REG_07_OPERATING_MODE1,0x00);        //standby mode
       
    //txfifoalmostempty
    writereg(RF22_REG_7D_TX_FIFO_CONTROL2,30);

    //Packet-engine registers
    writereg(RF22_REG_30_DATA_ACCESS_CONTROL,0x00); 
    
    writereg(RF22_REG_33_HEADER_CONTROL2,0x08);    
    writereg(RF22_REG_34_PREAMBLE_LENGTH,0x00);       

    writereg(RF22_REG_0B_GPIO_CONFIGURATION0,0x15); // TX state                        
    writereg(RF22_REG_0C_GPIO_CONFIGURATION1,0x12); // RX state                        

    setFrequency(435.0);

    if((readreg(RF22_REG_02_DEVICE_STATUS)& 0x08)!= 0x00)
        {
            pc_bcn.printf("frequency not set properly\r\n");
            reset_rfm();
        }

    //set Modem Configuration
    //writereg(RF22_REG_1C_IF_FILTER_BANDWIDTH,0xdf);
    //writereg(RF22_REG_1F_CLOCK_RECOVERY_GEARSHIFT_OVERRIDE,0x03);
    //writereg(RF22_REG_20_CLOCK_RECOVERY_OVERSAMPLING_RATE,0x39);
    //writereg(RF22_REG_21_CLOCK_RECOVERY_OFFSET2,0x20);                     
    //writereg(RF22_REG_22_CLOCK_RECOVERY_OFFSET1,0x68);           //updated 20 to 25 reg values from excel sheet for 1.2 Khz freq. deviation,fsk
    //writereg(RF22_REG_23_CLOCK_RECOVERY_OFFSET0,0xdc);
    //writereg(RF22_REG_24_CLOCK_RECOVERY_TIMING_LOOP_GAIN1,0x00);
    //writereg(RF22_REG_25_CLOCK_RECOVERY_TIMING_LOOP_GAIN0,0x6B);
    //writereg(RF22_REG_2C_OOK_COUNTER_VALUE_1,0x2C);
    //writereg(RF22_REG_2D_OOK_COUNTER_VALUE_2,0x11);    //not required for fsk (OOK counter value)
    //writereg(RF22_REG_2E_SLICER_PEAK_HOLD,0x2A);         //??
    writereg(RF22_REG_58,0x80);
    //writereg(RF22_REG_69_AGC_OVERRIDE1,0x60);
    
    //Data rate set later
      
    writereg(RF22_REG_70_MODULATION_CONTROL1,0x20);
    writereg(RF22_REG_71_MODULATION_CONTROL2,0x21);//ook = 0x21
    
    //set tx power
    writereg(RF22_REG_6D_TX_POWER,0x07);    //20dbm
    
    //TX_packet_length written later
}
bool Check_ACK_RECEIVED()
{
    if((readreg(RF22_REG_03_INTERRUPT_STATUS1) & 0x04) == 0x04)  
    {
        printf("Packet sent: ACK received\r\n");
        return 1;   
    }
    else
    {
        pc_bcn.printf("Packet not sent\r\n");
        return 0;
    }
}
