#ifndef EEPROM_H
#define EEPROM_H

//#include "pinconfig.h"
//#include "eeprom.h"
//#include "DefinitionsAndGlobals.h"
#define ee_scl PIN86
#define ee_sda PIN87
#define check 10

//EEPROM e2prom(ee_sda, ee_scl, 0, EEPROM::T24C512); // T24C1024 for 1Mbit EEPROM
EEPROM e2prom(ee_sda, ee_scl, 0x0, EEPROM::T24C512);

int32_t INITIAL_EEPROM[29] = {1,1,1,80000,1,0,0,0,0,1,1,20,85,20,30,3,24,1,0,0,0,0,0,0,0,0,0,0,0};
//int32_t INITIAL_EEPROM[32] = {1,0,1,0,1,0,1,0,1,35001,0xff,300,85,20,20,3,0x80000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

uint32_t flasharray_thres[32];
uint32_t flasharray_thres_1[32];

void I2C_EEPROM_busreset()
{
    gPC.printf("\n\rChecking");
    PORTC->PCR[10] &= 0xfffffffb;    //Enabling high slew rates for SDA and SCL lines
    PORTC->PCR[11] &= 0xfffffffb;    //Enabling high slew rates for SDA and SCL lines
    I2C1->C1 &= 0x7f;               //Disabling I2C module
    SIM->SCGC4 &= 0xffffff7f;       //Disabling clock to I2C module
    SIM->SCGC4 |= 0x00000080;       //Enabling clock to I2C module
    I2C1->C1 |= 0x80;               //Enabling I2C module
    PORTC->PCR[10] |= 0x00000004;    //Disabling high slew rates for SDA and SCL lines
    PORTC->PCR[11] |= 0x00000004;    //Disabling high slew rates for SDA and SCL lines
    Thread::wait(1);                //Wait for all I2C registers to be updates to their their values
}

void mcpy(uint32_t *a2,int8_t *a1,int n){
    
    *a2=0;
    for (int i=0;i<n;i++){
        *(a2) += *(a1+i);
        if(i<n-1){
        *(a2)=(*(a2))<<8;
        //printf("%d\n",*(a2));
        }
    }
    
}

void rmcpy(uint8_t *a1,uint32_t *a2,int n){
    
    for (int i=0;i<n;i++){
        *(a1+i) = (*(a2))>>((n*8)-(8*(i+1)));
    }
    
}

void WRITE_TO_EEPROM(uint32_t address, int32_t data_block)
{
    e2prom.write(address*4+10,data_block);
    wait_us(1);
}

void THRES_WRITE_TO_EEPROM(uint16_t mid, uint32_t* thres_data,int val)
{
    int8_t data[128] = {0};
    //memcpy(data,thres_data,128);
    if(val == 1 )
        memcpy(data,thres_data,128);
    if(val == 2)
        memcpy(data,thres_data,48);
    if(val == 3)
        memcpy(data,thres_data,80);
    if(mid <11 & mid >1)
    {
        e2prom.write((uint32_t)(mid-1)*128,data,128);
    }    
}

void WRITE_PMS_TO_EEPROM(uint16_t pmid, uint32_t* thres_data)
{
    int8_t data[128];
    memcpy(data,thres_data,128);
    
    if(pmid <7 & pmid >0)
    {
        e2prom.write((uint32_t)(1280 + (pmid-1)*128),data,128);
    }    
}

void UPDATE_PMS_ENTRY(uint32_t address, uint32_t data_block)
{
    e2prom.write((1280 + (address*4)),data_block);
    wait_us(1);
}

uint32_t READ_FROM_EERPOM(uint32_t address)
{
    int32_t data;
    e2prom.read(address*4+10, data);
    wait_ms(10);
    return (uint32_t)data;
}

void THRES_READ_FROM_EEPROM(uint16_t mid, uint32_t* data32,int val)
{
    int8_t data[128];
    if(mid<11 & mid >1)
    {
    e2prom.read((uint32_t)(mid-1)*128,data,128);
    }
    if(val == 1 )
        memcpy(data32,data,128);
    if(val == 2)
        memcpy(data32,data,48);
    if(val == 3)
        memcpy(data32,data,80);
    /*for(int i=0;i<32;i++){
        mcpy(data32+i,data+4*i,4);
        }*/
    wait_ms(10);
}    

void READ_PMS_FROM_EEPROM(uint16_t pmid, uint32_t* data32)
{
    int8_t data[128];
    if(pmid<7 & pmid > 0)
    {
    e2prom.read((uint32_t)(1280 + (pmid-1)*128),data,128);
    }
    memcpy(data32,data,128);
    /*for(int i=0;i<32;i++){
        mcpy(data32+i,data+4*i,4);
        }*/
    wait_ms(10);
}    
    
void INIT_EEPROM()
{
     // To be commented starts
    int32_t test_buffer;
    test_buffer = READ_FROM_EERPOM(17);
    // test_buffer = 0;
   // e2prom.ready();
  //  e2prom.read(2,test_buffer);

    if(test_buffer != 1)
    {
        if(test_buffer == 0)
            {
                for(int i=0;i<29;i++)
                    WRITE_TO_EEPROM( i, INITIAL_EEPROM[i]);
                WRITE_TO_EEPROM(17,0x01);   
                gPC.printf("Initializing EEPROM - Day 0\n\r");
            }
        if(test_buffer == 2)
            {
                for(int i=0;i<29;i++)
                    WRITE_TO_EEPROM( i, INITIAL_EEPROM[i]);
                WRITE_TO_EEPROM( 5, 1);
                WRITE_TO_EEPROM(17,0x01); 
                gPC.printf("Initializing EEPROM - Reset EEPROM Paramters only\n\r");
            }
    }
  
    // To be commented ends*/
    gPC.printf("Reading intial parametrs from EEPROM\n");
    
   EPS_V_A_EN_STATUS = READ_FROM_EERPOM(0);
   BAE_STATUS = READ_FROM_EERPOM(1); 
   SD_STATUS = READ_FROM_EERPOM(2);
    //PL_STATUS = read[3];
    SD_LIB_BLK_CURRENT = READ_FROM_EERPOM(3);
    PL_BEE_SW_STATUS = READ_FROM_EERPOM(4);
    //PL_EPS_LATCH_SW_EN = read[4];
    RTC_INIT_STATUS = READ_FROM_EERPOM(5);
    CDMS_RTC_DISABLE = READ_FROM_EERPOM(6);
    CDMS_RESET_COUNTER = READ_FROM_EERPOM(7);
    TIME_LATEST_CDSMS_RESET = READ_FROM_EERPOM(8);
    COM_TC_BYTES_LIMIT = READ_FROM_EERPOM(9);
    COM_RX_CURRENT_MAX = READ_FROM_EERPOM(10);
    COM_RX_DISABLE_TIMEOUT = READ_FROM_EERPOM(11);
    COM_PA_TMP_HIGH = 85;//read[12];
    COM_PA_RECOVERY_TIMEOUT = READ_FROM_EERPOM(13);
    COM_SESSION_TIMEOUT = READ_FROM_EERPOM(14);
    COM_RSSI_MIN = READ_FROM_EERPOM(15);
    PL_STATE = READ_FROM_EERPOM(16);
    
    THRES_READ_FROM_EEPROM(0x0002,flasharray_thres,1);
    for(uint8_t z=0;z<24;z++)
         scp_threshold_m0[z] = flasharray_thres[z] ;
    for(uint8_t z=24;z<32;z++)
         scp_threshold_m0[z+8] = flasharray_thres[z] ;
    
    THRES_READ_FROM_EEPROM(0x0003,scp_threshold_m0+(40),2);
    
    THRES_READ_FROM_EEPROM(0x0004,scp_threshold_m1,1);
    
    THRES_READ_FROM_EEPROM(0x0005,scp_threshold_m1+(32),3);
    
    THRES_READ_FROM_EEPROM(0x0006,flasharray_thres,2); 
    scp_threshold_m0_1[7] = flasharray_thres[0];
    scp_threshold_m0_1[5] = flasharray_thres[1] ;
    scp_threshold_m0_1[8] = flasharray_thres[2] ;
    scp_threshold_m0_1[6] = flasharray_thres[3] ;
    for(uint8_t z=0;z<5;z++)
        scp_threshold_m0_1[z] = flasharray_thres[z+4] ;
    scp_sfp_threshold_m0_2[0] = flasharray_thres[9]  ;
    scp_sfp_threshold_m0_2[1] = flasharray_thres[10] ;
    scp_sfp_threshold_m0_2[2] = flasharray_thres[11] ;
    
     THRES_READ_FROM_EEPROM(0x0007,flasharray_thres,1);
    for(uint8_t z=0;z<24;z++)
         sfp_threshold_m0[z] = flasharray_thres[z] ;
    for(uint8_t z=24;z<32;z++)
         sfp_threshold_m0[z+8] = flasharray_thres[z] ;
    
    THRES_READ_FROM_EEPROM(0x0008,sfp_threshold_m0+(40),2);
    
    THRES_READ_FROM_EEPROM(0x0009,sfp_threshold_m1,1);
    
    THRES_READ_FROM_EEPROM(0x000A,sfp_threshold_m1+(32),3);
    
    /*READ_PMS_FROM_EEPROM(0x0001, pl_block);
    
    READ_PMS_FROM_EEPROM(0x0002, pl_block + (32));
    
    READ_PMS_FROM_EEPROM(0x0003, pl_block + (64));              //Uncomment and test this after all other PMS functionality has been verified
    
    READ_PMS_FROM_EEPROM(0x0004, pl_block + (96));
    
    READ_PMS_FROM_EEPROM(0x0005, pl_block + (128));
    
    READ_PMS_FROM_EEPROM(0x0006, pl_block + (160));*/
    
    
    gPC.printf("0 = \r%d\n\r", READ_FROM_EERPOM(0));
    gPC.printf("1 = %d\n\r", READ_FROM_EERPOM(1));
    gPC.printf("2 = %d\n\r", READ_FROM_EERPOM(2));
    gPC.printf("3 = %d\n\r", READ_FROM_EERPOM(3));
    gPC.printf("4 = %d\n\r", READ_FROM_EERPOM(4));
    gPC.printf("5 = %d\n\r", READ_FROM_EERPOM(5));
    gPC.printf("6= %d\n\r", READ_FROM_EERPOM(6));
    gPC.printf("7= %d\n\r", READ_FROM_EERPOM(7));
    gPC.printf("8= %d\n\r", READ_FROM_EERPOM(8));
    gPC.printf("9= %d\n\r", READ_FROM_EERPOM(9));
    gPC.printf("10= %d\n\r", READ_FROM_EERPOM(10));
    gPC.printf("11= %d\n\r", READ_FROM_EERPOM(11));
    gPC.printf("12= %d\n\r", READ_FROM_EERPOM(12));
    gPC.printf("13= %d\n\r", READ_FROM_EERPOM(13));
    gPC.printf("14= %d\n\r", READ_FROM_EERPOM(14));
    gPC.printf("15= %d\n\r", READ_FROM_EERPOM(15));
    gPC.printf("16 = %u\n\r", READ_FROM_EERPOM(16));
    gPC.printf("test buffer 17 = %u\n\r", READ_FROM_EERPOM(17));
    
 
   // SD_LIB_BLK_CURRENT        = READ_FROM_EERPOM(16); 
    // added by samp
 
    
}

/*===================================================MMS Functions=================================================*/

void FCTN_CDMS_WR_S_EEPROM(uint16_t mid,uint32_t datablock);

void FCTN_CDMS_WR_S_EEPROM(uint16_t mid,uint32_t datablock)
{
    if(mid == 0x0100)
    {
        WRITE_TO_EEPROM(11,(datablock>>16) & 0x000000FF);
        WRITE_TO_EEPROM(13,(datablock>>8) & 0x000000FF);
        WRITE_TO_EEPROM(14,datablock & 0x000000FF);
    }
    else if(mid == 0x0101)
    {
        WRITE_TO_EEPROM(12,(datablock>>16) & 0x000000FF);
        WRITE_TO_EEPROM(10,(datablock>>8) & 0x000000FF);
        WRITE_TO_EEPROM(15,datablock & 0x000000FF);
    }
    else if(mid == 0x0102)
    {
        WRITE_TO_EEPROM(9,datablock & 0x0000FFFF);
    }
    else if(mid == 0x0103)
    {
        WRITE_TO_EEPROM(6,datablock & 0x00000001);
    }
    else if(mid == 0x0104)
    {
        WRITE_TO_EEPROM(17,datablock & 0x00000001);
    } 
}

#endif