#include <mbed.h>

#define tstart -40
#define tstep 8
#define tstep_thermistor 8                 //verify everything!!
#define tstart_thermistor -40
#define vstart 3.3
#define vstep 0.84667
#define cstart 0.0691
#define cstep 0.09133
#define vcell_start 5                       //check
#define vcell_step 0.0133                   //check
#define soc_start 0
#define soc_step 0.3921
#define crate_start 0                   //check
#define crate_step 1                     //check
#define AngularSpeed_start 0             //check
#define AngularSpeed_step 0.1            //check
#define rsens 0.025


#define m_ADDR       (0x6C)   //slave address

 //I2C register addresses 
#define REG_VCELL        0x02
#define REG_SOC          0x04
#define REG_MODE         0x06
#define REG_VERSION      0x08
#define REG_HIBRT        0x0A
#define REG_CONFIG       0x0C
#define REG_VALRT        0x14
#define REG_CRATE        0x16
#define REG_VRESET_ID    0x18
#define REG_STATUS       0x1A
#define REG_TABLE        0x40
#define REG_CMD          0xFE

//.............Power switching..........
#define TRXY_DR_EN PIN82                  //torque rod driver enable
#define TRZ_DR_EN  PIN88  
#define ENBL3V3A PIN33
//#define VBATT PIN20
#define BATT_HEAT PIN96
//#define BATT_HEAT_OUTPUT 
extern void FCTN_CONVERT_FLOAT(float input, uint8_t* output);
//PARAMETER VALUE //change
//#define EPS_BAT_TEMP_LOW 0
//#define EPS_BAT_TEMP_HIGH 55
//#define EPS_BAT_TEMP_DEFAULT 20 

void FCTN_EPS_INIT();
void FCTN_EPS_HANDLE_CDMS_FAULT();
void FCTN_EPS_HANDLE_HW_FAULTS();

void FCTN_EPS_POWERMODE(float soc) ;

void FCTN_HK_MAIN();
void FCTN_APPEND_HKDATA();
uint8_t quantiz(float start,float step,float x);

void saveMin();
void saveMax();
void minMaxHkData();

void FCTN_BATTERYGAUGE_INIT();
int FCTN_BATTERYGAUGE_MAIN(float*Battery_parameters, float temp);

// unsigned short read_soc(char , bool );
unsigned short read_soc(char,bool ack);
unsigned short read(char reg);
int write(char reg, unsigned short data);
void reset();       //not used
void quickStart();      //not used
void disable_sleep();
void disable_hibernate();
void socChangeAlertEnabled(bool);
int compensation(char rcomp);
int tempCompensation(float temp);
void clearAlert();
void emptyAlertThreshold(char threshold);
void vAlertMinMaxThreshold();
void vResetThresholSet();
void vResetAlertEnabled(bool enabled);
char alertFlags();
void clearAlertFlags();
float vcell();
float soc();
float crate();
bool alerting();
void vResetThresholdSet();

void FCTN_BATTTEMP_INIT();
void FCTN_BATT_TEMP_SENSOR_MAIN(float*);

typedef struct BAE_HK_actual{
    float voltage_actual[16];
    float current_actual[12];
    float Batt_temp_actual[2];
    float Batt_gauge_actual[4];
    float BAE_temp_actual;
    char power_mode;      
    uint8_t faultPoll_status; 
    uint8_t faultIr_status;
    
    //changed
    int16_t bit_data_acs_mm[3];
    int16_t bit_data_acs_mg[3];
    
    float AngularSpeed_actual[3];//required for algo   
    float Bvalue_actual[3];//required for algo
    float Batt_voltage_actual;
    /*changed 1.0*/
    //uint16_t Batt_voltage_data;   
   
}BAE_HK_actual;

typedef struct BAE_HK_quant{
    uint8_t voltage_quant[16];      //power_mode + faults should be appended to sd card 
    uint8_t current_quant[12];
    uint8_t Batt_temp_quant[2];
    //uint8_t Batt_gauge_quant[3];       // why only 3 here??
    float Batt_gauge_alerts;  //why is this float??
    uint8_t BAE_temp_quant;

    float AngularSpeed_quant[3];   
    float Bvalue_quant[3];  
    
    uint8_t Batt_voltage_quant;  
}BAE_HK_quant;

typedef struct BAE_HK_arch{         //power_mode + faults should be appended to sd card 
    
    uint8_t Batt_1_temp;            //verify if uint8_t is right
    uint8_t Batt_2_temp; 
    uint8_t EPS_PCB_temp;
    uint8_t Batt_SOC;           
    char power_mode;
    uint8_t faultPoll_status; 
    uint8_t faultIr_status;
    uint8_t Batt_voltage;
    
    //char Batt_voltage2;
    // char Digital power bus voltage;
    

}BAE_HK_arch;

typedef struct BAE_HK_min_max{
    uint8_t voltage_max[16];
    uint8_t current_max[16];
    uint8_t Batt_voltage_max;
    uint8_t BAE_temp_max;     
    
    //battery soc  
    uint8_t Batt_SOC_max;
    
    uint8_t Batt_temp_max[2];//bcn temp also included?
    //uint8_t Batt_gauge_max[3];//what is the use.
    
    uint16_t bit_data_acs_mm_max[3];
    uint16_t bit_data_acs_mg_max[3];
    uint8_t BCN_TEMP_max;
    //below no longer valid
    /*uint16_t Bvalue_max[3];
    uint16_t AngularSpeed_max[3];       
    */  

    uint8_t voltage_min[16];
    uint8_t current_min[16];
    uint8_t Batt_voltage_min;
    uint8_t BAE_temp_min;
    uint8_t Batt_SOC_min;
    
    uint8_t Batt_temp_min[3];//includes bcn temp
    uint8_t BCN_TEMP_min;
    
    //uint8_t Batt_gauge_min[3];
    
    uint16_t bit_data_acs_mm_min[3];
    uint16_t bit_data_acs_mg_min[3];   
          

}BAE_HK_min_max;

