#ifndef PID_H
#define PID_H

#include "mbed.h"

class PID
{
public:
    PID(float p = 0, float i = 0, float d = 0, float t = 1, float max = 1.0, bool pid_mode = false, Timer *T = NULL);
    void setParameter(float p = 0, float i = 0, float d = 0, float t = 1, float max = 1.0);
    void start();
    void reset();
    bool isConvergence(float timer_range);
    
    float output; //計算された出力値が入る　

    float *sensor, *target; //センサーと目標値を示す変数のポインタ 外側から引っ張ってくる
    float allowable_error;
    
private:
    Timer *timer;
    Ticker pidTimer;
    float kp, ki, kd, delta_t;
    float abs_max_output; //outputの100%を定義
    bool pid_mode;   //0:位置型, 1:速度型
    float integral;
    float error[3];   //現在の誤差, 前回の誤差, 前々回の誤差
    float last_target;
    double start_time;
    void _compute();
    float _gurd(float val);
};
#endif
