#include "mbed.h"
#include "PID.h"

/*p,i,d:ゲイン設定　t:制御ループ時間 max:ourputの最大値*/
PID::PID(float p, float i, float d, float t, float max, bool mode, Timer *T)
{
    timer = T;
    kp = p; ki = i; kd = d; delta_t = t;
    abs_max_output = max;
    pid_mode = mode;
    integral = 0;
    allowable_error = 0;
    
}
void PID::setParameter(float p, float i, float d, float t, float max)
{
    kp = p; ki = i; kd = d; delta_t = t;
    abs_max_output = max;
    integral = 0;
}

/*計算のための割り込み開始*/
void PID::start()
{
    pidTimer.attach(this, &PID::_compute, delta_t);
}

/*現在保持している計算データをリセット*/
void PID::reset()
{
    output = integral = error[0] = error[1] = error[2] = 0;
}

/*計算する　タイマーで回される*/
void PID::_compute()
{
    float proportion, differential;
    float _output = 0;
    
    switch(pid_mode) {
        case 0:   //位置型
            error[1] = error[0];
            error[0] = *target - *sensor;
            proportion    = kp * error[0];
            integral     += ki * (error[0] + error[1]) * delta_t / 2;
            differential  = kd * (error[0] - error[1]) / delta_t;
            _output = proportion + integral + differential;
            break;
        case 1:   //速度型
            error[2] = error[1];
            error[1] = error[0];
            error[0] = *target - *sensor;
            proportion    = kp * error[0] / delta_t;
            integral      = ki * error[0];
            differential  = kd * (error[0] - error[1] * 2 + error[2]) / delta_t;   //(前々-前) - (前-今) / t
            _output += proportion + integral + differential;
            break;
        default:
            break;
    }

    integral = _gurd(integral);
    output = _gurd(_output);
    
    last_target = *target;
    
    if(abs(error[0]) <= allowable_error)
        timer->start();
    else start_time = timer->read();
}

float PID::_gurd(float val)
{
    if(val > abs_max_output)
        return abs_max_output;
    else if(val < -abs_max_output)
        return -abs_max_output;
    else return val;
}

bool PID::isConvergence(float time_range)
{   
    if(last_target != *target)
        return 0; 
    if(timer->read() - start_time > time_range)
        return 1;
    else return 0;
}