#include "mbed.h"
#include "MDD2.h"

//MDD22のコンストラクタ実行と同時にpinをインスタンスする
MDD2::MDD2(PinName p1, PinName p2,  int freq) : Pwm1(p1),Pwm2(p2)
{
    abs_max_output = 1.0;
    Pwm1.period(1.0 / freq);
    Pwm2.period(1.0 / freq);
    Pwm1.write(0);
    Pwm2.write(0);
}

void MDD2::drive(float output)
{
    if(_abs(output) > abs_max_output)
    {
        Pwm1 = 0;
        Pwm2 = 0;
    }
    else if(output > abs_max_output * 0.1)
    {
        Pwm1 = output / abs_max_output;
        Pwm2 = 0;
    }
    else if(output < -abs_max_output * 0.1)
    {
        Pwm1 = 0;
        Pwm2 = -output / abs_max_output;
    }
    else
    {
        Pwm1 = 0;
        Pwm2 = 0;
    }
}

float MDD2::_abs(float val)
{
    if(val >= 0)
        return val;
    else return -val;
}
