#include "mbed.h"       
#include "Pulse.h"
#include "Serial.h"
// from https://developer.mbed.org/users/NickRyder/code/Pulse/docs/fb79a4637a64/classPulseInOut.html
// display is 2 rows of 16 chars each
// speaker is triggered by sending control chars to the LCD.
// instead of clearing LCD, redraw entire thing each time an update is needed

//TODO
// How do you tell a train from a vehicle? Have train provide position to sensors for temporary disable?
// How does the sensor know a train is coming, to tell people?
// move code into Avnet_ATT sample, use timer instead of wait

Serial debug(USBTX, USBRX); // tx, rx - for debug
Serial lcd(PTC17, PTC16);//tx, rx - for LCD 
PulseInOut gpo(D2); // pulse pin for distance sensor

DigitalOut red_led(LED_RED); // LED on board
DigitalOut green_led(LED_GREEN);

int duration=0;
int distance=0;
int TIME_UNTIL_WARN_TRAIN=5; //number of loops before message is sent //TODO SET HIGHER IN PROD
int TRIGGER_DISTANCE=2; //min number of inches for sensor to detect an obstruction
int count_seconds=0;
bool trains_a_comin=false;
bool mute=false;

void red_light()
{
    red_led=0;//red ON
    green_led=1; //green OFF
}  

void yellow_light()
{
    red_led=0; // red ON
    green_led=0;// green ON
}    

void no_light()
{
    red_led=1; //red OFF
    green_led=1; //green OFF
}


void warn_beep()
{
    // short beeps for detection of obstruction, before siren
    //set length, set scale, play note - short blip for detection
    //plays for 1/8 second, "dit-dit"
    lcd.putc(209);//1/32nd note
    lcd.putc(215);//scale 3(lowest)
    lcd.putc(220);//A note
    lcd.putc(209);//1/32nd note
    lcd.putc(215);//scale 3(lowest)
    lcd.putc(232);//silence
    lcd.putc(209);//1/32nd note
    lcd.putc(215);//scale 3(lowest)
    lcd.putc(220);//A note
    lcd.putc(209);//1/32nd note
    lcd.putc(215);//scale 3(lowest)
    lcd.putc(232);//silence
}


void siren()
{
    //longer tone for "get the hell off the track right now"
    //plays for 2 seconds
    lcd.putc(213);//one second
    lcd.putc(216);//scale 4 (middle)
    lcd.putc(229);//F note
    lcd.putc(213);//one second
    lcd.putc(218);//scale 6 (middle)
    lcd.putc(229);//F note
}

int main()
{
    //set up the LCD display - refer to documentation https://www.parallax.com/sites/default/files/downloads/27979-Parallax-Serial-LCDs-Product-Guide-v3.1.pdf
    lcd.baud(19200);
    lcd.putc(22); // power on
    lcd.putc(17); //backlight on
    lcd.putc(12); //clear display
    wait_ms(5); //required after "clear display"
    
    //main loop - check for obstruction+warn. If obstruction lasts more than X seconds, send message to train to stop. 
    while (true) {
        //Set up LCD display
       // lcd.putc(12); //clear display
       // wait_ms(5); //required after clear
        
        no_light();
        //Check distance sensor
        // re-implementing from the Arduino doc at https://www.arduino.cc/en/tutorial/ping
        //set as output and send a HIGH pulse of >2 us to ping surroundings
        gpo.write(0);
        wait_us(2);
        gpo.write(1);
        wait_us(5);
        gpo.write(0);
        
        //then, set to read, and read value
        duration=0;
        duration=gpo.read_high_us();
        distance=duration / 74 / 2;
        
        //TODO: implement timer - if obstruction is here for too_many_seconds, trigger
        //debug.printf("Pulse duration: %d\r\n", duration);
        //lcd.printf("DISTANCE: %d", distance);
        //lcd.putc(13); //carriage return
        
        debug.printf("Distance (in): %d\r\n", distance);
        if (distance < TRIGGER_DISTANCE) {
            //TODO: code to start counting
            count_seconds++;//TODO this is currently the number of loops, not the number of seconds. FIXME
            
            if (count_seconds > TIME_UNTIL_WARN_TRAIN) {
                red_light();
                if (not mute){
                    siren();
                }
    
                //TODO send message to train ONLY ONCE  
                debug.printf("SENDING MESSAGE TO TRAIN");
                
                lcd.printf("DANGER!       ");
                lcd.putc(13); //carriage return
                lcd.printf("ONCOMING TRAIN!");
                lcd.putc(13); //carriage return

            }
            else {
            //detection, but still counting
                if (not mute){
                    warn_beep();
                }            
                yellow_light(); 
                 
                debug.printf("OBSTRUCTION DETECTED");            
                lcd.printf("MOVE QUICKLY");
                lcd.putc(13); //carriage return
                lcd.printf("ACROSS TRACK");
                lcd.putc(13); //carriage return

            }            
        }
        else{
            no_light();
            debug.printf("ALL CLEAR\r\n");
            //TODO turn off screen when no detection? saves power            
            lcd.printf("ALL CLEAR     ");
            lcd.putc(13); //carriage return
            lcd.printf("               ");
            lcd.putc(13); //carriage return

            count_seconds=0;
        }
        wait(1);
        //no_light(); // toggle led
        
    }
}
  
