#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include "uniqueCPUID.h"

#include <iostream>  
#include <string>  
#include "UnitTest.h"
//#include "BlockChain.h"
#include "MockHsm.h"
#include "Asset.h"
#include "Transaction.h"
#include "Account.h"
#include "Key.h"

using namespace std;  

#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   1023
#define HTTPD_MAX_HDR_LENGTH   255
#define HTTPD_MAX_FNAME_LENGTH   127
#define HTTPD_MAX_DNAME_LENGTH   127

#define DEBUG_LOG 1

const char* ECHO_SERVER_ADDRESS = "192.168.31.185";
const int ECHO_SERVER_PORT = 10003;

Serial uart(USBTX, USBRX);

//SDFileSystem sd(p5, p6, p7, p8, "sd"); // LPC1768 MBD2PMD
//SDFileSystem sd(P0_18, P0_17, P0_15, P0_16, "sd"); // Seeeduino Arch Pro SPI2SD
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // K64F

EthernetInterface eth;
TCPSocketServer server;
TCPSocketConnection client;
TCPSocketConnection my_client;

char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
char fileName[HTTPD_MAX_FNAME_LENGTH+1];
char dirName[HTTPD_MAX_DNAME_LENGTH+1];
char *uristr;
char *eou;
char *qrystr;

FILE *fp;
int rdCnt;

// function declation
int test_socket_client(void);
int socket_init();
int socket_fini();


void test_uuid()
{
    char pUUID[128] = {0};
    getUniqueIDAsStr(pUUID);
    printf("CPUID = %s \n",pUUID);
    //printUniqueId(uart);
}

int test_MockHsm()
{
    MockHsm mh;
    mh.setAlias("t_key_6");
    cout<<mh.getAlias()<<endl;
    cout<<mh.createKey()<<endl;
    cout<< mh.listKeys() <<endl;
    return 0;
}

int test_Asset()
{
    Asset asset;
    asset.setAlias("t_asset_6");

    cout<< asset.createAsset() << endl;
    cout<< asset.listAssets() << endl;
    
    
    return 0;
}

int test_Account()
{
    Key key;
    key.setAlias("t_key");
    key.listKeys();

    Account act(key);
    act.setAlias("t_acc_8");
    act.createAccount();
    act.listAccounts();

    return 0;
}

int test_transaction(string type)
{
    Transaction ts;
    //cout << ts.buildTransaction() << endl;
    ts.buildTransaction(type);
    ts.signTransaction();
    ts.submitTransaction();
    ts.listTransactions();
    return 0;
}

int test_transaction()
{
    vector<Actions> vActions;
    Actions act;
    MbedJSONValue reference_data;

    act.accounts_alias = "t_acc_1";
    act.amount = 51;
    act.asset_alias = "t_asset";
    act.reference_data = reference_data;
    act.type = "spend_account";
    vActions.push_back(act);

    Actions act1 = {"t_acc_2",  "t_asset", 49, reference_data, "spend_account"  };
    Actions act2 = {"tom",      "t_asset", 80, reference_data, "control_account"};
    Actions act3 = {"Jerry",    "t_asset", 20, reference_data, "control_account"};

    vActions.push_back(act1);
    vActions.push_back(act2);
    vActions.push_back(act3);
 printf("=============2========\r\n");
    Transaction ts;
    ts.buildTransaction(vActions);
    ts.signTransaction();
    ts.submitTransaction();
    ts.listTransactions();

    return 0;
}


int main(void)
{
    printf("main start\n");
    
    test_uuid();

    
    socket_init();
    
    test_MockHsm();
    test_Asset();
    test_Account();

    //char isContinue = 'y';
   // do
    //{
        string type = "spend_account";
        //string type = "issue";
        //test_transaction(type);
        test_transaction();
        printf("=============5========\n");
   // }while(1);
    //}while (isContinue = getch() != 'q');
    
    
    //test_socket_client();
    
    socket_fini();
    
    printf("main end\n");
    return 0;
}

int socket_init()
{
    int ret = 0;
    // EthernetInterface eth;
    printf("Initializing Ethernet\n");
    ret = eth.init(); //Use DHCP
    //eth.init("192.168.31.186", "255.255.255.0", "192.168.31.1"); //Use static ip
    printf("Connecting\n");
    ret = eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    return ret;
}

int socket_fini()
{
    return eth.disconnect();  
}

int test_socket_client(void)
{
    TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    printf("Connected to Server at %s\n",ECHO_SERVER_ADDRESS);
    
    // Send message to server
    char hello[] = "Hello World";
    printf("Sending  message to Server : '%s' \n",hello);
    socket.send_all(hello, sizeof(hello) - 1);
    
    // Receive message from server
    char buf[256];
    int n = socket.receive(buf, 256);
    buf[n] = '\0';
    printf("Received message from server: '%s'\n", buf);
    
    // Clean up
    socket.close();
    
    return 0;
}

void get_file(char* uri)
{
    uart.printf("get_file %s\n", uri);
    char *lstchr = strrchr(uri, NULL) -1;
    if ('/' == *lstchr) {
        uart.printf("Open directory /sd%s\n", uri);
        *lstchr = 0;
        sprintf(fileName, "/sd%s", uri);
        DIR *d = opendir(fileName);
        if (d != NULL) {
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            sprintf(httpHeader,"<html><head><title>Directory Listing</title></head><body><h1>%s Directory Listing</h1><ul>", uri);
            client.send(httpHeader,strlen(httpHeader));
            struct dirent *p;
            while((p = readdir(d)) != NULL) {
                sprintf(dirName, "%s/%s", fileName, p->d_name);
                uart.printf("%s\n", dirName);
                DIR *subDir = opendir(dirName);
                if (subDir != NULL) {
                    sprintf(httpHeader,"<li><a href=\"./%s/\">%s/</a></li>", p->d_name, p->d_name);
                } else {
                    sprintf(httpHeader,"<li><a href=\"./%s\">%s</a></li>", p->d_name, p->d_name);
                }
                client.send(httpHeader,strlen(httpHeader));
            }
        }
        closedir(d);
        uart.printf("Directory closed\n");
        sprintf(httpHeader,"</ul></body></html>");
        client.send(httpHeader,strlen(httpHeader));
    } else {
        sprintf(fileName, "/sd%s", uri);
        fp = fopen(fileName, "r");
        if (fp == NULL) {
            uart.printf("File not found\n");
            sprintf(httpHeader,"HTTP/1.1 404 Not Found \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            client.send(uri,strlen(uri));
        } else {
            uart.printf("Sending: header");
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            uart.printf(" file");
            while ((rdCnt = fread(buffer, sizeof( char ), 1024, fp)) == 1024) {
                client.send(buffer, rdCnt);
                uart.printf(".");
            }
            client.send(buffer, rdCnt);
            fclose(fp);
            uart.printf("done\n");
        }
    }
}

int main_1 (void)
{
//    Serial Interface eth;
    uart.baud(115200);
    uart.printf("Initializing\n");

//    Check File System
    uart.printf("Checking File System\n");
    DIR *d = opendir("/sd/");
    if (d != NULL) {
        uart.printf("SD Card Present\n");
    } else {
        uart.printf("SD Card Root Directory Not Found\n");
    }

//    EthernetInterface eth;
    uart.printf("Initializing Ethernet\n");
    //eth.init(); //Use DHCP
    eth.init("192.168.31.186", "255.255.255.0", "192.168.31.1"); //Use  
    uart.printf("Connecting\n");
    eth.connect();
    uart.printf("IP Address is %s\n", eth.getIPAddress());
    
    //test socket client
    //my_client.connect("192.168.31.185",10003);
    //my_client.send_all("hello world",11);
    
     TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        uart.printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    uart.printf("Connected to Server at %s\n",ECHO_SERVER_ADDRESS);
    
    // Send message to server
    char hello[] = "Hello World";
    uart.printf("Sending  message to Server : '%s' \n",hello);
    socket.send_all(hello, sizeof(hello) - 1);
    
    // Receive message from server
    char buf[256];
    int n = socket.receive(buf, 256);
    buf[n] = '\0';
    uart.printf("Received message from server: '%s'\n", buf);
    
    // Clean up
    socket.close();
    ////////////////////////////////////////////////////////////////////////////

//    TCPSocketServer server;
    server.bind(HTTPD_SERVER_PORT);
    server.listen();
    uart.printf("Server Listening\n");

    while (true) {
        uart.printf("\nWait for new connection...\r\n");
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        my_client.send_all("hello world",11);

        uart.printf("Connection from: %s\r\n", client.get_address());
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            uart.printf("Recieved Data: %d\r\n\r\n%.*s\r\n",n,n,buffer);
            if (n >= 1024) {
                sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                client.send(buffer,n);
                break;
            } else {
                buffer[n]=0;
            }
            if (!strncmp(buffer, "GET ", 4)) {
                uristr = buffer + 4;
                eou = strstr(uristr, " ");
                if (eou == NULL) {
                    sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                    client.send(httpHeader,strlen(httpHeader));
                    client.send(buffer,n);
                } else {
                    *eou = 0;
                    get_file(uristr);
                }
            }
        }

        client.close();
    }
}


int main_2() {
    //    Serial Interface eth;
    uart.baud(115200);
    uart.printf("Initializing\n");
    
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("\nClient IP Address is %s\n", eth.getIPAddress());
    
    // Connect to Server
    TCPSocketConnection socket;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    printf("Connected to Server at %s\n",ECHO_SERVER_ADDRESS);
    
    // Send message to server
    char hello[] = "Hello World";
    printf("Sending  message to Server : '%s' \n",hello);
    socket.send_all(hello, sizeof(hello) - 1);
    
    // Receive message from server
    char buf[256];
    int n = socket.receive(buf, 256);
    buf[n] = '\0';
    printf("Received message from server: '%s'\n", buf);
    
    // Clean up
    socket.close();
    eth.disconnect();
    
    while(true) {}
}