/*
交易包含一个或多个输入，以及一个或多个输出。
恒为区块链核心平台的API允许您使用操作（包括发出，支出和返还）构建交易。
发布资产单位
1
添加“发出”操作
2
为资产别名选择“ReAsset”
3
输入“100”作为金额
4
添加“使用帐户控制”操作
5
为帐户别名选择“ReAccount”
6
为资产别名选择“ReAsset”
7
输入“100”作为金额
8
点击“提交”按钮
*/

#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include "uniqueCPUID.h"

#include <iostream>  
#include <string>  
#include "UnitTest.h"
//#include "BlockChain.h"
#include "MockHsm.h"
#include "Asset.h"
#include "Transaction.h"
#include "Account.h"
#include "Key.h"


void Transaction_test()
{
    vector<Actions> vActions;
    Actions act;
    MbedJSONValue reference_data;

    act.accounts_alias = "t_acc_1";
    act.amount = 51;
    act.asset_alias = "t_asset";
    act.reference_data = reference_data;
    act.type = "spend_account";
    vActions.push_back(act);

    Actions act1 = {"t_acc_2",  "t_asset", 49, reference_data, "spend_account"  };
    Actions act2 = {"tom",      "t_asset", 80, reference_data, "control_account"};
    Actions act3 = {"Jerry",    "t_asset", 20, reference_data, "control_account"};

    vActions.push_back(act1);
    vActions.push_back(act2);
    vActions.push_back(act3);

    Transaction ts;
    ts.buildTransaction(vActions);
    ts.signTransaction();
    ts.submitTransaction();
    ts.listTransactions();
}