#include "Transaction.h"
#include "MbedJSONValue.h"
#include <string>
#include <stdio.h>

// ��������
// ע��json�Ǹ�����[]
string Transaction::buildTransaction()
{
	string strJson = "";

	MbedJSONValue val;
	MbedJSONValue reference_data;
	MbedJSONValue valArray;

	//fill the object
	val["actions"][0]["account_alias"] = "t_acc_1";
	val["actions"][0]["asset_alias"]   = "t_asset";
	val["actions"][0]["amount"] = 10;
	val["actions"][0]["reference_data"] = reference_data;
	val["actions"][0]["type"] = "spend_account";

	val["actions"][1]["account_alias"] = "t_acc_2";
	val["actions"][1]["asset_alias"]   = "t_asset";
	val["actions"][1]["amount"] = 10;
	val["actions"][1]["reference_data"] = reference_data;
	val["actions"][1]["type"] = "control_account";

	//serialize it into a JSON string
	valArray[0] = val;
	strJson = valArray.serialize();

	printf("json: %s\r\n", strJson.c_str());

	string strRep = "";
	string strUrl = "/build-transaction";
	client.http_post(strUrl,strJson,strRep);
 printf("=============4========\n");

	// get http response content
	string content = client.get_content(strRep);

	// decode content json 
	MbedJSONValue valRep;
	parse(valRep,content.c_str());
	m_valRep = valRep;

	std::string raw_transaction = valRep[0]["raw_transaction"].get<std::string>();
	MbedJSONValue valSign;
	valSign = valRep[0]["signing_instructions"][0];

	string xpub;
	xpub = valSign["witness_components"][0]["keys"][0]["xpub"].get<std::string>();
	m_strXpub = xpub;

	return strJson;
}

string Transaction::buildTransaction(string type)
{
	string strJson = "";

	MbedJSONValue val;
	MbedJSONValue reference_data;
	MbedJSONValue valArray;

	//fill the object
	if (type == "spend_account")
	{
		amount = 10;
		sender = "t_acc_1";
		receiver = "t_acc_2";
		asset_alias = "t_asset";

		val["actions"][0]["account_alias"] = sender;
		val["actions"][0]["asset_alias"]   = asset_alias;
		val["actions"][0]["amount"] = amount;
		val["actions"][0]["reference_data"] = reference_data;
		val["actions"][0]["type"] = type;

		val["actions"][1]["account_alias"] = receiver;
		val["actions"][1]["asset_alias"]   = asset_alias;
		val["actions"][1]["amount"] = amount;
		val["actions"][1]["reference_data"] = reference_data;
		val["actions"][1]["type"] = "control_account";
	}
	else if (type == "issue")
	{
		amount = 1000;
		receiver = "t_acc_1";
		asset_alias = "t_asset";

		val["actions"][0]["asset_alias"]   = asset_alias;
		val["actions"][0]["amount"] = amount;
		val["actions"][0]["reference_data"] = reference_data;
		val["actions"][0]["type"] = type;

		val["actions"][1]["account_alias"] = receiver;
		val["actions"][1]["asset_alias"]   = asset_alias;
		val["actions"][1]["amount"] = amount;
		val["actions"][1]["reference_data"] = reference_data;
		val["actions"][1]["type"] = "control_account";
	}
	

	//serialize it into a JSON string
	valArray[0] = val;
	strJson = valArray.serialize();

	//printf("json: %s\r\n", strJson.c_str());

	string strRep = "";
	string strUrl = "/build-transaction";
	client.http_post(strUrl,strJson,strRep);


	// get http response content
	string content = client.get_content(strRep);

	// decode content json 
	MbedJSONValue valRep;
	parse(valRep,content.c_str());
	m_valRep = valRep;

	std::string raw_transaction = valRep[0]["raw_transaction"].get<std::string>();
	MbedJSONValue valSign;
	valSign = valRep[0]["signing_instructions"][0];

	string xpub;
	xpub = valSign["witness_components"][0]["keys"][0]["xpub"].get<std::string>();
	m_strXpub = xpub;

	return strJson;
}

string Transaction::buildTransaction(vector<Actions> &actions)
{
	string strJson = "";
	MbedJSONValue val;
	MbedJSONValue reference_data;
	MbedJSONValue valArray;
 printf("=============3========\r\n");
	//fill the object
	vector<Actions>::iterator it;
	int i = 0;
	for (it = actions.begin(),i = 0; it != actions.end(); it++,i++)
	{
		 printf("=============3.1========\r\n");
		if (it->type == "spend_account")
		{
			val["actions"][i]["account_alias"] = it->accounts_alias;
			val["actions"][i]["asset_alias"]   = it->asset_alias;
			val["actions"][i]["amount"] = it->amount;
			val["actions"][i]["reference_data"] = it->reference_data;
			val["actions"][i]["type"] = it->type;
		}
		else if (it->type == "issue")
		{
			val["actions"][i]["asset_alias"]   = it->asset_alias;
			val["actions"][i]["amount"] = it->amount;
			val["actions"][i]["reference_data"] = it->reference_data;
			val["actions"][i]["type"] = it->type;
		}
		else if (it->type == "control_account")
		{
			val["actions"][i]["account_alias"] = it->accounts_alias;
			val["actions"][i]["asset_alias"]   = it->asset_alias;
			val["actions"][i]["amount"] = it->amount;
			val["actions"][i]["reference_data"] = it->reference_data;
			val["actions"][i]["type"] = it->type;
		}
		 printf("=============3.2========\r\n");
	}

 printf("=============3.3========\r\n");

	//serialize it into a JSON string
	valArray[0] = val;
	strJson = valArray.serialize();

	printf("json: %s\r\n", strJson.c_str());

	string strRep = "";
	string strUrl = "/build-transaction";
	if (client.http_post(strUrl,strJson,strRep) < 0)
	{
		return "http post error";
	}
	else if (strRep.find("HTTP/1.1 200 OK") < 0)
	{
		return strRep.substr(0,strRep.find_first_of("\r\n"));
	}

	// get http response content
	string content = client.get_content(strRep);
	if (content.find("raw_transaction") < 0)
	{
		return content;
	}
 printf("=============4========\r\n");
	// decode content json 
	MbedJSONValue valRep;
	string err = parse(valRep,content.c_str());
	int ret = 0;
	ret = err.find("error");
	if ( ret > 1)
	{
		return err;
	}
	m_valRep = valRep;

	std::string raw_transaction = valRep[0]["raw_transaction"].get<std::string>();
	MbedJSONValue valSign;
	valSign = valRep[0]["signing_instructions"][0];

	string xpub;
	xpub = valSign["witness_components"][0]["keys"][0]["xpub"].get<std::string>();
	m_strXpub = xpub;

	return strJson;
}

string Transaction::signTransaction()
{
	string strJson = "";

	MbedJSONValue val;

	//fill the object
	val["transactions"] = m_valRep;
	val["xpubs"][0]  = m_strXpub;

	//serialize it into a JSON string
	strJson = val.serialize();

	string strRep = "";
	string strUrl = "/mockhsm/sign-transaction";
	client.http_post(strUrl,strJson,strRep);


	// get http response content
	string content = client.get_content(strRep);

	// decode content json 
	MbedJSONValue valRep;
	parse(valRep,content.c_str());

	m_valRep = valRep;

	return strJson;
}

string Transaction::submitTransaction()
{
	string strJson = "";

	MbedJSONValue val;

	//fill the object
	val["transactions"] = m_valRep;

	//serialize it into a JSON string
	strJson = val.serialize();

	//printf("json: %s\r\n", strJson.c_str());

	string strRep = "";
	string strUrl = "/submit-transaction";
	client.http_post(strUrl,strJson,strRep);

	// get http response content
	string content = client.get_content(strRep);

	// decode content json 
	MbedJSONValue valRep;
	parse(valRep,content.c_str());

	id = valRep[0]["id"].get<std::string>();

	return strJson;
}

string Transaction::listTransactions()
{
	string strJson = "";

	MbedJSONValue val;

	//fill the object
	val["filter"] = "id='" + id + "'";

	//serialize it into a JSON string
	strJson = val.serialize();

	//printf("json: %s\r\n", strJson.c_str());

	string strRep = "";
	string strUrl = "/list-transactions";
	client.http_post(strUrl,strJson,strRep);


	// get http response content
	string content = client.get_content(strRep);

	// decode content json 
	MbedJSONValue valRep;
	parse(valRep,content.c_str());
	m_valRep = valRep;

	return strJson;
}