#include "mbed.h"
#include "rgbled.h"

rgbled::rgbled(PinName pin_red, PinName pin_green, PinName pin_blue)
             : _pin_red(pin_red), _pin_green(pin_green), _pin_blue(pin_blue){
    _on = false;
    _off = !_on;
    _pin_red = _off;
    _pin_green = _off;
    _pin_blue = _off;
}

void rgbled::active(bool a){
    _on = a;
    _off = !_on;
}
    
void rgbled::_none(void){
    _pin_red = _off;
    _pin_green = _off;
    _pin_blue = _off;
}

void rgbled::_red(void){
    _pin_red = _on;
    _pin_green = _off;
    _pin_blue = _off;
}

void rgbled::_green(void){
    _pin_red = _off;
    _pin_green = _on;
    _pin_blue = _off;
}

void rgbled::_blue(void){
    _pin_red = _off;
    _pin_green = _off;
    _pin_blue = _on;
}

void rgbled::set(color c){
        switch (c) {
            case none :
                _none();
                break;
            case red :
                _red();
                break;
            case green :
                _green();
                break;
            case blue :
                _blue();
                break;
        }
}
