#include "HCSR04.h"
#include "mbed.h"
/*
*HCSR04.cpp
*/
HCSR04::HCSR04(PinName t, PinName e, RawSerial pc,float interval, bool repeat,int done) : trig(t), echo(e), _pc(pc),_interval(interval), _repeat(repeat),_done(done) {}
 
void HCSR04::Trig()
{
    timer.reset();  //reset timer
    trig=0;   // trigger low 
    wait_us(2); //  wait 
    trig=1;   //  trigger high
    wait_us(10);
    trig=0;  // trigger low
}

void HCSR04::setMode(bool mode)
{
    _repeat = mode;
}

void HCSR04::clearStatus()
{
    _done = 0;
}

int HCSR04::getStatus()
{
    return _done;
}



 long HCSR04::echo_duration() {
        
    Trig();
         while(!echo); // start pulseIN
      timer.start();
     while(echo);
      timer.stop();
     return timer.read_us(); 
 
}
 
//return distance in cm 
int HCSR04::distance(){
    _done++;
    duration = echo_duration();
    distance_cm = (duration/2)/29.1  ;
    int distance_cm;
}

float HCSR04::returninterval()
{
    return _interval;
}