#include "mbed.h"
#include <I2C.h>

I2C i2c(p28,p27);
Serial pc(USBTX, USBRX);
//Serial uart(p28, p27);
char buffer[128];
        
    
DigitalOut myled(LED1);
void funct_in(int adress, char *data)
{
 
    i2c.read(adress,data,1);
}

void funct_out(int adress,char *data)
{
    i2c.write(adress,data,1);
}

void can_in(int adress,char control, char *data)
{
    i2c.write(adress, &control,1);
    i2c.read(adress,data,1);
}

void dac_out(int adress,char *data)
{
    i2c.write(adress, data,2);
}

int main() {
   // pc.gets(buffer,4);
   //if(uart.readable()) {
    //pc.putc(uart.getc());
    
    int adress_out=0x70;//pcf_out
    int adress_in=0x72;// pcf_in
    int adress_can=0x90;//4 can/ 1 cna 8bits
    int adress_dac=0x40;//dac 6bits 8 voies
    char x,*tab;
    char cmd[2];
    tab=cmd;
    while(1) 
    {
        if(pc.readable()) 
        {
            if(pc.getc()=='i')
                {
                    funct_in(adress_in,&x);
                    pc.printf("in=%d",x);
                }
            if (pc.getc()=='o')
                {cmd[0]=pc.getc();
                cmd[1]=pc.getc();
                    funct_out(adress_out,tab);//get binary value form labview: 0x00 to 0xFF
                }
            if (pc.getc()=='a')// frame : a<control><data> : a<0 OUT IN1 IN0 0 I CH1 CH0><D7 D6 D5 D4 D3 D2 D1 D0>
                {   cmd[0]=0;
                    cmd[0]|=pc.getc()-48;//channel number
                    cmd[0]|=(pc.getc()-48)<<2;//auto iteration channel
                    cmd[0]|=(pc.getc()-48)<<4;//input type diff/single ended
                    cmd[0]|=(pc.getc()-48)<<6;//dac active
                
                    can_in(adress_can,cmd[0],&x);
                    pc.printf("%x ",cmd[0]);
                    pc.printf("can=%d\n",x);
                }
            if(pc.getc()=='d')//frame : d<control><data> : d<I3 I2 I1 I0 SD SC SB SA><x x D5 D4 D3 D2 D1 D0>
            //SD to SA : Valid subaddresses are: 0H to 7H. The subaddresses correspond to DAC0 to DAC7 channel
            //I3 to I0 : 0 or F
                {   cmd[0]=(pc.getc()-48); //DAC0 to DAC7
                    cmd[0]|=0x0F<<4;//0 or F >> send F
                    //sprintf(cmd[1],"%d",pc.gets());// data to convert
                    cmd[1]=pc.getc();// data to convert
                   // pc.printf("%x %x\n",cmd[0],cmd[1]);
                    dac_out(adress_dac,cmd);
                }
        }  
    }
}
