#include "mbed.h"
#include "encoder.h"
#include "MODSERIAL.h"


int main(){
    //VARIABLES
    AnalogIn potmeter(A1);
    AnalogIn potmeter2(A0);
    DigitalIn button(D8);
    MODSERIAL pc(USBTX,USBRX);
    
    Encoder motor1(D13,D12,true);   // channel A and B from encoder, true - getSpeed works
    PwmOut pwm_motor1(D6);          // D4 and D5 = motor 2, D7 and D6 = motor 2  
    DigitalOut dir_motor1(D7);      // 
    
    Encoder motor2(D10,D9,true);   // channel A and B from encoder, true - getSpeed works
    PwmOut pwm_motor2(D5);          // D4 and D5 = motor 2, D7 and D6 = motor 2  
    DigitalOut dir_motor2(D4);      // 
    
    //CODE
    pc.baud(9600);
    

    while (1) {
    
        pwm_motor2.period(0.0001);   //100us period
        for (float s= 0.0f; s <= 1.1f ; s += 0.01f) {       //increase pwm from 0 to 1, steps of 0.1
            dir_motor2=1;                                   //direction
            pwm_motor2.write(s);                            //write pwm value s to motor
            wait(0.1);                                      
            pc.printf("pwm duty: %f, %d, \n\r", s, motor2.getPosition());       //print values to putty
        }
    }
}