#include "mbed.h"
#include "encoder.h"
#include "MODSERIAL.h"

volatile bool looptimerflag;

void setlooptimerflag(void)
{
    looptimerflag = true;
} 
 
int main(){
    //VARIABLES
    AnalogIn potmeter(A1);
    AnalogIn potmeter2(A0);
    DigitalIn button(D8);
    MODSERIAL pc(USBTX,USBRX);
    
    Encoder motor1(D13,D12,true);   // channel A and B from encoder, true - getSpeed works
    PwmOut pwm_motor1(D6);          // D4 and D5 = motor 2, D7 and D6 = motor 2  
    DigitalOut dir_motor1(D7);      // 
    
    Encoder motor2(D10,D9,true);   // channel A and B from encoder, true - getSpeed works
    PwmOut pwm_motor2(D5);          // D4 and D5 = motor 2, D7 and D6 = motor 2  
    DigitalOut dir_motor2(D4);      // 
    
    // MOTOR1
    float goal;
    float pwm_to_motor;  
    // MOTOR2
    float goal2;
    float pwm_to_motor2;  
        
    //CODE
    pc.baud(9600);
    
    //pwm_motor1.write(0.2f);         // Speed
    //dir_motor1.write(1);            // Direction
   
    Ticker looptimer;
    looptimer.attach(setlooptimerflag,0.01);  

    while (1) {
        while(looptimerflag != true);
        looptimerflag = false;
        
        //MOTOR1
        goal = (potmeter.read()-0.5)*4200;
        pc.printf("setpoint: %f, %d, %f \n\r", goal, motor1.getPosition(),motor1.getSpeed());
        pwm_to_motor = (goal - motor1.getPosition())*.001;   
    
        if(pwm_to_motor > 0)
            dir_motor1 = 0;
        else
            dir_motor1 = 1;
        
        pwm_motor1.write(abs(pwm_to_motor));
        
        //MOTOR2
        goal2 = (potmeter2.read()-0.5)*4200;
        //pc.printf("setpoint: %f, %d, %f \n\r", goal2, motor2.getPosition(),motor2.getSpeed());
        pwm_to_motor2 = (goal2 - motor2.getPosition())*.001;   
    
        if(pwm_to_motor2 > 0)
            dir_motor2 = 0;
        else
            dir_motor2 = 1;
        
        pwm_motor2.write(abs(pwm_to_motor2));
           

    }
}