#include "mbed.h"
#include "encoder.h"
#include "MODSERIAL.h"

volatile bool looptimerflag;

void setlooptimerflag(void)
{
    looptimerflag = true;
} 
 
int main(){
    //VARIABLES
    AnalogIn potmeter(A1);
    AnalogIn potmeter2(A0);
    MODSERIAL pc(USBTX,USBRX);
    DigitalIn button(PTA1);
    DigitalIn button1(PTB9);
    
    Encoder motor1(D13,D12,true);   // channel A and B from encoder, true - getSpeed works
    PwmOut pwm_motor1(D6);          // D4 and D5 = motor 2, D7 and D6 = motor 2  
    DigitalOut dir_motor1(D7);      // 
    
    Encoder motor2(D10,D9,true);   // channel A and B from encoder, true - getSpeed works
    PwmOut pwm_motor2(D5);          // D4 and D5 = motor 2, D7 and D6 = motor 2  
    DigitalOut dir_motor2(D4);      // 
    
    // MOTOR1
    float goal;
    float pwm_to_motor;  
    // MOTOR2
    float goal2;
    float pwm_to_motor2;  
        
    //CODE
    pc.baud(9600);
    
    //pwm_motor1.write(0.2f);         // Speed
    //dir_motor1.write(1);            // Direction
   
    Ticker looptimer;
    looptimer.attach(setlooptimerflag,0.01);  

    while (1) {
        while(looptimerflag != true);
        looptimerflag = false;
        
        //MOTOR1
        if (button.read() < 0.5) {        //button pressed - direction
            dir_motor2.write(1);
            pwm_motor2.write(0.5);  
            pc.printf("position = %d \r\n", motor2.getPosition());
        } 
        else if(button1.read() < 0.5) {   //button pressed - other direction
            dir_motor2.write(0);
            pwm_motor2.write(0.5);  
            pc.printf("position = %d \r\n", motor2.getPosition());
        } 
        else {                            //button not pressed
           dir_motor2.write(0);
           pwm_motor2.write(0);
           pc.printf("position = %d \r\n", motor2.getPosition());
        }
           
        // pc.printf("pos: %d, speed %f \r\n",motor1.getPosition(), motor1.getSpeed());
    }
}