#include "mbed.h"
#include "HIDScope.h"
#include "biquadFilter.h" 

AnalogIn emg1(A0); //onderste board
AnalogIn emg2(A1); // 2e board
AnalogIn emg3(A2); // 3e board
AnalogIn emg4(A3); // bovenste board

Ticker sample_ticker; // naam van de emg-ticker

HIDScope scope(2);  // aantal kanalen voor je HIDScope

//highpass filter 20 Hz
const double numhigh_1 = 0.956543225556877;
const double numhigh_2 = -1.91308645113754;
const double numhigh_3 = 0.956543225556877;
const double denhigh_2 = -1.91197067426073;
const double denhigh_3 = 0.9149758348014341;

//notchfilter 50Hz
//biquad 1
const double numnotch_1_1 = 1;
const double numnotch_1_2 = -1.97538661427765;
const double numnotch_1_3 = 1.00000018882502;
const double dennotch_1_2 = -1.97024348390877;
const double dennotch_1_3 = 0.995504923090779;

//biquad 2
const double numnotch_2_1 = 1;
const double numnotch_2_2 = -1.97538624436946;
const double numnotch_2_3 = 1.00000018882502;
const double dennotch_2_2 = -1.97175302143845;
const double dennotch_2_3 = 0.995629024908953;

//lowpass filter 7 Hz  - envelop
const double numlow_1 = 0.000119046743110057;
const double numlow_2 = 0.000238093486220118;
const double numlow_3 = 0.000119046743110057;
const double denlow_2 = -1.968902268531908;
const double denlow_3 = 0.9693784555043481;


double u1 = emg1.read();                //inputvariables
double u2 = emg2.read();
double u3 = emg3.read();
double u4 = emg4.read();


biquadFilter     highpass( denhigh_2 , denhigh_3 , numhigh_1 , numhigh_2 , numhigh_3);                // removes artifacts
biquadFilter     notch1( dennotch_1_2 , dennotch_1_3 , numnotch_1_1 , numnotch_1_2 , numnotch_1_3 );  // removes 49-51 Hz power interference
biquadFilter     notch2( dennotch_2_2 , dennotch_2_3 , numnotch_2_1 , numnotch_2_2 , numnotch_2_3 );   //
biquadFilter     lowpass( denlow_2 , denlow_3 , numlow_1 , numlow_2 , numlow_3 );                     // EMG envelope 

biquadFilter     highpass_2( denhigh_2 , denhigh_3 , numhigh_1 , numhigh_2 , numhigh_3);
biquadFilter     notch1_2( dennotch_1_2 , dennotch_1_3 , numnotch_1_1 , numnotch_1_2 , numnotch_1_3 );  // removes 49-51 Hz power interference
biquadFilter     notch2_2( dennotch_2_2 , dennotch_2_3 , numnotch_2_1 , numnotch_2_2 , numnotch_2_3 );   //
biquadFilter     lowpass_2( denlow_2 , denlow_3 , numlow_1 , numlow_2 , numlow_3 );                     // EMG envelope 

biquadFilter     highpass_3( denhigh_2 , denhigh_3 , numhigh_1 , numhigh_2 , numhigh_3);
biquadFilter     notch1_3( dennotch_1_2 , dennotch_1_3 , numnotch_1_1 , numnotch_1_2 , numnotch_1_3 );  // removes 49-51 Hz power interference
biquadFilter     notch2_3( dennotch_2_2 , dennotch_2_3 , numnotch_2_1 , numnotch_2_2 , numnotch_2_3 );   //
biquadFilter     lowpass_3( denlow_2 , denlow_3 , numlow_1 , numlow_2 , numlow_3 );                     // EMG envelope 

biquadFilter     highpass_4( denhigh_2 , denhigh_3 , numhigh_1 , numhigh_2 , numhigh_3);
biquadFilter     notch1_4( dennotch_1_2 , dennotch_1_3 , numnotch_1_1 , numnotch_1_2 , numnotch_1_3 );  // removes 49-51 Hz power interference
biquadFilter     notch2_4( dennotch_2_2 , dennotch_2_3 , numnotch_2_1 , numnotch_2_2 , numnotch_2_3 );   //
biquadFilter     lowpass_4( denlow_2 , denlow_3 , numlow_1 , numlow_2 , numlow_3 );                     // EMG envelope 

void myController()
{

    highpass.step (u1);
    notch1.step (u1);
    notch2.step (u1);
    lowpass.step (u1);
    
    highpass_2.step (u2);
    notch1_2.step (u2);
    notch2_2.step (u2);
    lowpass_2.step (u2);
    
    highpass_3.step (u3);
    notch1_3.step (u3);
    notch2_3.step (u3);
    lowpass_3.step (u3);
    
    highpass_4.step (u4);
    notch1_4.step (u4);
    notch2_4.step (u4);
    lowpass_4.step (u4);

}

int main()
{
   sample_ticker.attach(&myController,0.002);
   while (true){   
    }
}  