#include "mbed.h"
#include "HIDScope.h"

//Define objects
AnalogIn    emg(A0); //Analog input
Ticker      sample_timer;
HIDScope    scope(1);

/** Sample function
 * this function samples the emg and sends it to HIDScope
 **/
void sample()
{
    /* First, sample the EMG using the 'read' method of the 'AnalogIn' variable named 'emg' */
    double emg_value = emg.read();
    /* Second, set the sampled emg value in channel zero (the first channel) in the 'HIDScope' variable named 'scope' */
    scope.set(0,emg_value);
    /* Repeat the step above if required for more channels (channel 0 up to 5 = 6 channels) */
    /* Finally, send all channels to the PC at once */
    scope.send();
}

int main()
{
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds
    */
    sample_timer.attach(&sample, 0.002);

    /*empty loop, sample() is executed periodically*/
    while(1) {}
}