#include "mbed.h"
#include "HIDScope.h"

AnalogIn emg1(A0); //onderste board
AnalogIn emg2(A1); // 2e board
AnalogIn emg3(A2); // 3e board
AnalogIn emg4(A3); // bovenste board

Ticker sample_ticker; // naam van de emg-ticker

HIDScope scope(4);  // aantal kanalen voor je HIDScope

//highpass filter 20 Hz
const double numhigh_1 = 0.956543225556877;
const double numhigh_2 = -1.91308645113754;
const double numhigh_3 = 0.956543225556877;
const double denhigh_2 = -1.91197067426073;
const double denhigh_3 = 0.9149758348014341;

//notchfilter 50Hz
//biquad 1
const double numnotch_1_1 = 1;
const double numnotch_1_2 = -1.97538661427765;
const double numnotch_1_3 = 1.00000018882502;
const double dennotch_1_2 = -1.97024348390877;
const double dennotch_1_3 = 0.995504923090779;

//biquad 2
const double numnotch_2_1 = 1;
const double numnotch_2_2 = -1.97538624436946;
const double numnotch_2_3 = 1.00000018882502;
const double dennotch_2_2 = -1.97175302143845;
const double dennotch_2_3 = 0.995629024908953;

//lowpass filter 7 Hz  - envelop
const double numlow_1 = 0.000119046743110057;
const double numlow_2 = 0.000238093486220118;
const double numlow_3 = 0.000119046743110057;
const double denlow_2 = -1.968902268531908;
const double denlow_3 = 0.9693784555043481;

// storage variables definieren
double f1_v1 = 0, f1_v2 = 0, f2_v1 = 0, f2_v2 = 0, f3_v1 = 0, f3_v2 = 0, f4_v1 = 0, f4_v2 = 0;

double biquad( double u, double &v1, double &v2, const double a1, const double a2, const double b0, const double b1, const double b2)

{
    double v = u  - a1*v1 - a2*v2;
    double y = b0*v + b1*v1 + b2*v2;
    v2=v1;
    v1=v;
    return y;
    }
    
void myController()
{
// double u1=..., u2...;
double u1 = emg1.read();
double y1 = biquad(u1, f1_v1, f1_v2, denhigh_2, denhigh_3, numhigh_1, numhigh_2, numhigh_3);
double y2 = abs(y1);
double y3 = biquad(y2, f2_v1, f2_v2, dennotch_1_2, dennotch_1_3, numnotch_1_1, numnotch_1_2, numnotch_1_3);
double y4 = biquad(y3, f3_v1, f3_v2, dennotch_2_2, dennotch_2_3, numnotch_2_1, numnotch_2_2, numnotch_2_3);
double y5 = biquad(y4, f4_v1, f4_v2, denlow_2, denlow_3, nomlow_1, numlow_2, numlow_3);
scope.set(0,u1);
scope.set(1,y5);
scope.send();
}
   
    
     
int main()
{
   sample_ticker.attach(&mycontroller,0.005);
   while (true){   
    }
}