#include "FilterDesign2.h"
#include "BiQuad.h"
#include "BiQuad4.h"

// This is exactly the same file as FilterDesign.cpp, but for the second EMG signal.
// Notch filter op 50 Hz
double nb0_2 = 0.999103206817809;
double nb1_2 = -1.994263409725146;
double nb2_2 = 0.999103206817809;
double na1_2 = -1.994263409725146;
double na2_2 = 0.998206413635618;

// 4th order Butterworth High pass 10 Hz
double hpb0_2 = 0.922946103200875;
double hpb1_2 = -3.691784412803501;
double hpb2_2 = 5.537676619205252; 
double hpb3_2 = -3.691784412803501;
double hpb4_2 = 0.922946103200875;
double hpa1_2 = -3.839672788481732;
double hpa2_2 = 5.531745865737864;
double hpa3_2 = -3.543889487580057;
double hpa4_2 = 0.851829509414351;

//4th order Butterworth low pass 9 Hz
double lpb0_2 = 0.00000054134117189603 ;
double lpb1_2 = 0.00000216536468758410  ;
double lpb2_2 = 0.00000324804703137616; 
double lpb3_2 = 0.00000216536468758410;
double lpb4_2 = 0.00000054134117189603;
double lpa1_2 = -3.855703428197204;
double lpa2_2 = 5.577429961461492;
double lpa3_2 = -3.587322565783154;
double lpa4_2 = 0.865604693977616;

double gain_2 = 10.00000;

BiQuad notch50_2(nb0_2, nb1_2, nb2_2, na1_2, na2_2);
BiQuad4 highpass_2(hpb0_2, hpb1_2, hpb2_2, hpb3_2, hpb4_2, hpa1_2, hpa2_2, hpa3_2, hpa4_2);
BiQuad4 lowpass_2(lpb0_2, lpb1_2, lpb2_2, lpb3_2, lpb4_2, lpa1_2, lpa2_2, lpa3_2, lpa4_2);

double FilterDesign2(double u)
{   
    double y_n_2 = notch50_2.step(u);
    double y_hp_2 = highpass_2.step(y_n_2);
    double y_abs_2 = abs(y_hp_2);
    double y_lp_2 = lowpass_2.step(y_abs_2);
    double y_gain_2 = y_lp_2*gain_2;
    
    return y_gain_2;
}