// For this example, you need the BioRobotics shield.
// Connect POT2 (frequency)to A0
// Connect POT1 (pwm) to A1
#include "mbed.h"
#include <math.h>

DigitalOut gpo(D0);
DigitalOut led(LED_RED);
AnalogIn freq(A0);
AnalogIn pwm(A1);
AnalogIn button(A2);
Ticker ReadPotmetersTicker;
volatile double frequency_Hz=1;
volatile double pwm_pct = 50;
volatile int on_time_us; // The time the LED should be on, in microseconds
volatile int off_time_us;

void ReadPotmeterValues(void)
{
    //frequency_Hz = 1 + pow((double)freq.read(),4) * 50; // Frequency ranges from 1 to 50 Hz
    //pwm_pct = pwm.read() * 100;
    
    if (pwm == 0){
        frequency_Hz = frequency_Hz + 1;
        }
    if (freq == 0){
        frequency_Hz = frequency_Hz - 1;
        }
        on_time_us = (int) ((50/100.0) * (1.0/frequency_Hz) * 1.0e6);
        off_time_us = (int) (( (100.0-50)/100.0) * (1.0/frequency_Hz) * 1.0e6);
}

int main()
{
    ReadPotmetersTicker.attach(ReadPotmeterValues, 0.1);
    led = 1;
    
    while (true) 
    {
        
        gpo = 0; // Turn led on
        wait_us(on_time_us);
        gpo = 1; // Turn led on
        wait_us(off_time_us);
        //pc.printf("potmetervalue %d",pwm_pct)
    }
}