#include "FilterDesign.h"
#include "BiQuad.h"
#include "BiQuad4.h"





// 4th order Butterworth High pass 9 Hz
double hpb0 = 0.862550850547179;
double hpb1 = -3.45020340218871;
double hpb2 = 5.17530510328307; 
double hpb3 = -3.45020340218871;
double hpb4 = 0.862550850547179;
double hpa1 = -3.70453845798319;
double hpa2 = 5.15648369715094;
double hpa3 = -3.1957974837626;
double hpa4 = 0.743993969858123;

//4th order Butterworth low pass 10 Hz
double lpb0 = 0.0000132937288987445 ;
double lpb1 = 0.0000531749155949779 ;
double lpb2 = 0.0000797623733924668; 
double lpb3 = 0.0000531749155949779;
double lpb4 = 0.0000132937288987445;
double lpa1 = -3.67172908916193;
double lpa2 = 5.06799838673419;
double lpa3 = -3.11596692520174;
double lpa4 = 0.719910327291871;

// Multiplication with the gain
double gain = 10.00000;     

                        
BiQuad4 highpass(hpb0, hpb1, hpb2, hpb3, hpb4, hpa1, hpa2, hpa3, hpa4);
BiQuad4 lowpass(lpb0, lpb1, lpb2, lpb3, lpb4, lpa1, lpa2, lpa3, lpa4);

double FilterDesign(double u)
{   
    double y_hp = highpass.step(u);   // Secondly the highpassfilter
    double y_abs = abs(y_hp);           // Make the signal values absolute
    double y_lp = lowpass.step(y_abs);  // Then a lowpass filter
    double y_gain = y_lp*gain;          // Multiply by a gain
        
    return y_gain;                      // Return this filtered value
}