#include "mbed.h"
#include "HIDScope.h"
#include "FilterDesign.h"
#include "BiQuad.h"
#include "BiQuad4.h"
#include "MODSERIAL.h"

Serial pc(USBTX,USBRX);
DigitalIn button(SW3) ;


//Define objects
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );
AnalogIn potmeter1(PTC11);          // Input of two potmeters
AnalogIn potmeter2(PTC10);


Ticker      ticker_calibration;   // Ticker to send the EMG signals to screen
Ticker      sample_timer;           // Ticker for reading out EMG
HIDScope    scope( 2 );
DigitalOut  led(LED1);

volatile double emg1_filtered;      //measured value of the first emg
volatile double emg2_filtered;      //measured value of the second emg
volatile double emg1_max ;           // calibrated value of first emg
volatile double emg2_max ;
volatile double emg1_cal = 0.8;
 
 // Read EMG
//void EMGread()
//{
//    emg1_filtered = FilterDesign(emg0.read());
//    emg2_filtered = FilterDesign(emg1.read());
    //pc.printf("emg1_cal = %f, emg2_cal = %f \n\r", emg1_filtered, emg2_filtered);
//}


 

void sample() ;
void EMGcalibration () ;




int main()
{   
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
    
    pc.baud(115200);
    //EMGcalibration();
    sample_timer.attach(&sample, 0.002);
    
   
    /*empty loop, sample() is executed periodically*/
    while(true) {
        if(SW3==0){
            EMGcalibration();
            }
            
    led = 1; 
        
    while(emg1_filtered >= 0.9*emg1_cal){
            led = 0;
    }
    }
}






void sample() 
{
    emg1_filtered = FilterDesign(emg0.read());
    emg2_filtered = FilterDesign(emg1.read());
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0, emg1_filtered ) ;
    scope.set(1, emg2_filtered );
    /* Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels) 
    *  Ensure that enough channels are available (HIDScope scope( 2 ))
    *  Finally, send all channels to the PC at once */
    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    //pc.printf("%f", emg1_filtered)
    //led = !led;
}

void EMGcalibration ()
{
    
Timer t;
t.start();
    do { 
    ticker_calibration.attach(&sample, 0.002);
    if(emg1_cal < emg1_filtered){
        emg1_cal = emg1_filtered ;
        }
        }while(t<10);
}