#include "mbed.h"
#include "scrp_slave.hpp"
#include "air.hpp"
#include "sbdbt.hpp"
sbdbt ds3(A0, A1);
DigitalIn limitA(PA_9,PullUp);
DigitalIn limitB(PC_5,PullUp);
Air catch_no(PA_0);

//↓モーター
void driveMotorS(double pwm){
    PwmOut up_pin_A(PB_13);
    PwmOut up_pin_B(PB_14);
    up_pin_A.period_us(2048);
    up_pin_B.period_us(2048);
    if (!pwm) {
        up_pin_A = 0;
        up_pin_B = 0;
    } else if (0 < pwm) {
        up_pin_A = pwm;
        up_pin_B = 0;
    } else {
        up_pin_A = 0;
        up_pin_B= -pwm;
    }
}
//↓昇降
//速さはテキトー
void Up(int data){
    if(data==1 && !limitA){
        driveMotorS(0.06);
    }else if(data==-1 && !limitB){
        driveMotorS(-0.06);
    }else{
        driveMotorS(0);
    }
}
//↓回収用
void CATCH_NO(bool data){
    catch_no.move(data);
    }

int main(){
    int up;
    bool catch_no=0,old_circle;
    while(true){
//↓コントローラー関係
        up=ds3.up()+ds3.down();
        if(old_circle<ds3.circle()) catch_no=!catch_no;
        old_circle=ds3.circle();
//↓関数関係        
        Up(up);
        CATCH_NO(catch_no);
        }
}