#include "mbed.h"
#include "scrp_slave.hpp"
#include "air.hpp"
#include "sbdbt.hpp"
ScrpSlave slave(PC_12,PD_2,PH_1,SERIAL_TX,SERIAL_RX,0x0807ffff);
Serial pc(SERIAL_TX,SERIAL_RX);
DigitalIn limitA(PB_12,PullUp);
DigitalIn limitB(PC_8,PullUp);
Air catch_no(PA_0);
DigitalOut Led1(PA_10);
DigitalOut Led2(PB_15);
//↓モーター
void driveMotorS(double pwm){
    PwmOut up_pin_A(PB_13);
    PwmOut up_pin_B(PB_14);
    up_pin_A.period_us(2048);
    up_pin_B.period_us(2048);
    if (!pwm) {
        up_pin_A = 0;
        up_pin_B = 0;
    } else if (0 < pwm) {
        up_pin_A = pwm;
        up_pin_B = 0;
    } else {
        up_pin_A = 0;
        up_pin_B= -pwm;
    }
}
//↓昇降
//速さはテキトー
bool Up(int rx_data,int &tx_data){
    if(rx_data==1 && !limitA){
        driveMotorS(0.3);
        Led2.write(1);
    }else if(rx_data==-1 && !limitB){
        driveMotorS(-0.3);
        Led2.write(1);
    }else{
        driveMotorS(0);
        Led2.write(0);
    }
    return true;
}
//↓回収用
bool CATCH_NO(int rx_data,int &tx_data){
    catch_no.move(rx_data);
    Led1.write(rx_data);
    return true;
    }

int main(){
    slave.addCMD(7,CATCH_NO);
    slave.addCMD(8,Up);
    while(true);    
}