#include "mbed.h"
#include "air.hpp"
#include "Servo.h"
#include "scrp_slave.hpp"
ScrpSlave slave(PC_12,PD_2,PH_1,SERIAL_TX,SERIAL_RX,0x0807ffff);
Serial pc(SERIAL_TX,SERIAL_RX);
DigitalIn limitA(PB_0,PullUp);
Air hassya(PB_9);
DigitalOut Led1(PA_10);
DigitalOut Led2(PB_15);
DigitalOut Led3(PB_2);
Servo myservo(PB_13);
Timer timer;
int tim=-6000;
int a=0;
//↓モータ用
void driveMotorS(double pwm){
    PwmOut up_pin_A(PB_4);
    PwmOut up_pin_B(PB_5);
    up_pin_A.period_us(2048);
    up_pin_B.period_us(2048);
    if (!pwm) {
        up_pin_A = 0;
        up_pin_B = 0;
    } else if (0 < pwm) {
        up_pin_A = pwm;
        up_pin_B = 0;
    } else {
        up_pin_A = 0;
        up_pin_B= -pwm;
    }
}
//　↓サーボ用
void Servo(bool data){
    if(data==0){
    myservo = 0;
    }else{
    myservo = 0.5;
    }
}
//↓発射用
bool Hassya(int rx_data,int &tx_data){
    
    if(rx_data==1 && a==1){
        tim=timer.read_ms();
        a=0;        
    }
    if(a==1 || !limitA==0){
        hassya.move(0);
        driveMotorS(0);
        Servo(0);
        Led1.write(0);
        Led2.write(0);
        Led3.write(0);
        a=1;
    }else if(timer.read_ms()-tim<5000){
            hassya.move(0);
            driveMotorS(0);
            Servo(1);
            Led1.write(0);
            Led2.write(0);
            Led3.write(1);
    }else if(timer.read_ms()-tim<6000){
            hassya.move(1);
            driveMotorS(0);
            Servo(0);
            Led1.write(1);
            Led2.write(0);
            Led3.write(0);
    }else if(timer.read_ms()-tim>6000 && !limitA==1){
            hassya.move(1);
            driveMotorS(-0.06);
            Servo(0);
            Led1.write(1);
            Led2.write(1);
            Led3.write(0);
    }else {
            hassya.move(0);
            driveMotorS(0);
            Servo(0);
            Led1.write(0);
            Led2.write(0);
            Led3.write(0);
    }
    return true;
}
int main(){
    timer.start();
    slave.addCMD(22,Hassya);
    while(true);
}