#ifndef MBED_MOTOR_H
#define MBED_MOTOR_H

#include "mbed.h"
#include "PID.h"
#include "QEI.h"

/*nastawy regulatora PID
const float K = 1;
const float Ti = 0;
const float Td = 0;
const float itv = 0.001;
#define AUTO 1
*/
/*QEI pins*/
/*
#define CH_A PTA2
#define CH_B PTA3
const int pPerRev = 10;
const int max_pulse_rate = 300; //do policzenia!!!!!!!!!!!!!!!!!!!
*/
/** Interface to control a standard DC motor
*
* with an H-bridge using a PwmOut and 2 DigitalOuts
*/
class Motor {
public:

    /** Create a motor control interface
    *
    * @param pwm A PwmOut pin, driving the H-bridge enable line to control the speed
    * @param fwd A DigitalOut, set high when the motor should go forward
    * @param rev A DigitalOut, set high when the motor should go backwards
    */
    Motor(PinName pwm, PinName fwd, PinName rev, PinName stby);

    /** Set the speed of the motor
    *
    * @param speed The speed of the motor as a normalised value between -1.0 and 1.0
    */
    void speed(float speed);
    
    /**Change the stand by status of H-bridge
    *
    * @param status 0 - bridge disabled, 1 - bridge enabled
    */
    void setStandby(bool status)
    {
        _stdby = status;
    }

protected:
    PwmOut _pwm;
    DigitalOut _fwd;
    DigitalOut _rev;
    DigitalOut _stdby;
private:
    //PID speedControl;
    //QEI encoder;
    float set_speed;
    int pulses;
    float curr_speed;
    float prev_pulses;
    
};

#endif
