#include "mbed.h"
AnalogIn adc1(A5);
BusOut vu_leds(PA_10,PB_3,PB_5,PB_4,PB_10,PA_8,PA_9,PC_7);
BusOut digit2(PA_0,PA_1,PA_4,PB_0);
BusOut digit1(PC_3,PC_2,PH_1,PH_0);
DigitalIn user(USER_BUTTON);
DigitalOut led(LED1);
Serial pc(USBTX, USBRX);
void display_vu(unsigned int x)
{
    vu_leds=0xff>>(8-x);
}
void display_digits(int x)
{
    digit1=x/10;
    digit2=x%10;

}
int main()
{
    
    int volt1;
    int volum;
    bool mode;
    while(1) {
        float read =adc1.read();
        pc.printf("%f\t",read);
        volt1 = read*33; 
        volum = read*8;
        pc.printf("%d\t%d\n",volt1,volum);
        if(!mode) {
            display_vu(volum);
            digit2=0;
            digit1=0;
        } else {
            display_digits(volt1);
            vu_leds=0;
        }
        if(!user) {
            mode=!mode;
            while(!user);
        }
        wait(0.2); // 200 millisecond
        led = !led;
    }
}
