#include "mbed.h"
#include <Adafruit_GFX.h>    
#define TFTWIDTH  320
#define TFTHEIGHT 480

#define TFT_NORTH {SPFD5408_MADCTL_MY | SPFD5408_MADCTL_BGR}
#define TFT_EAST  {SPFD5408_MADCTL_MX | SPFD5408_MADCTL_MY | SPFD5408_MADCTL_MV | SPFD5408_MADCTL_BGR}
#define TFT_SOUTH {SPFD5408_MADCTL_MX | SPFD5408_MADCTL_BGR}
#define TFT_WEST  {SPFD5408_MADCTL_MV | SPFD5408_MADCTL_BGR}

#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF

#define SPFD5408_SOFTRESET          0x01
#define SPFD5408_SLEEPIN            0x10
#define SPFD5408_SLEEPOUT           0x11
#define SPFD5408_NORMALDISP         0x13
#define SPFD5408_INVERTOFF          0x20
#define SPFD5408_INVERTON           0x21
#define SPFD5408_GAMMASET           0x26
#define SPFD5408_DISPLAYOFF         0x28
#define SPFD5408_DISPLAYON          0x29
#define SPFD5408_COLADDRSET         0x2A
#define SPFD5408_PAGEADDRSET        0x2B
#define SPFD5408_MEMORYWRITE        0x2C
#define SPFD5408_PIXELFORMAT        0x3A
#define SPFD5408_FRAMECONTROL       0xB1
#define SPFD5408_DISPLAYFUNC        0xB6
#define SPFD5408_ENTRYMODE          0xB7
#define SPFD5408_POWERCONTROL1      0xC0
#define SPFD5408_POWERCONTROL2      0xC1
#define SPFD5408_VCOMCONTROL1       0xC5
#define SPFD5408_VCOMCONTROL2       0xC7
#define SPFD5408_MEMCONTROL         0x36
#define SPFD5408_MADCTL             0x36
#define SPFD5408_MADCTL_MY          0x80
#define SPFD5408_MADCTL_MX          0x40
#define SPFD5408_MADCTL_MV          0x20
#define SPFD5408_MADCTL_ML          0x10
#define SPFD5408_MADCTL_RGB         0x00
#define SPFD5408_MADCTL_BGR         0x08
#define SPFD5408_MADCTL_MH          0x04

#define IDLE    1
#define ACTIVE  0
#define COMMAND 0
#define DATA    1

#define TEMPS   60

#define VERT_LINE 0
#define HORI_LINE 1
/** setup tft **/
DigitalOut pinRD(A0);   //PA_0;
DigitalOut pinWR(A1);   //PA_1;
DigitalOut pinCD(A2);   //PA_4;
DigitalOut pinCS(A3);   //PB_0;
DigitalOut pinReset(A4);//PC_1;

BusInOut portTFT(D8, D9, D2, D3, D4, D5, D6, D7);
/**set up cam*/
RawSerial pc(SERIAL_TX, SERIAL_RX); //has to use rawserial ,serial too slow and has byte loss.
RawSerial cam(PA_11, PA_12);
RawSerial esp(PB_6, PA_10);
DigitalOut read_state(LED1);
InterruptIn frame_start(PC_5);
InterruptIn ccap(USER_BUTTON);


void WriteCommand(uint8_t c)
{
    pinCD = COMMAND;
    pinWR = ACTIVE;
    portTFT = c;
    pinWR = IDLE;
}

void WriteData(uint8_t d)
{
    pinCD = DATA;
    pinWR = ACTIVE;
    portTFT = d;
    pinWR = IDLE;
}

//Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(LED1);

 

void begin(void) {

    pinCS = IDLE;
    pinCD = DATA;
    pinWR = IDLE;
    pinRD = IDLE;
    portTFT.output();   

    pinReset = ACTIVE;
    pinReset = IDLE;

    pinCS = ACTIVE;
   
    WriteCommand(SPFD5408_SOFTRESET);
    WriteData(0);
    wait_ms(100);
   
    WriteCommand(SPFD5408_MEMCONTROL);
    WriteData(SPFD5408_MADCTL_MY | SPFD5408_MADCTL_BGR);
   
    WriteCommand(SPFD5408_PIXELFORMAT);
    WriteData(0x55);
 
    WriteCommand(SPFD5408_FRAMECONTROL);
    WriteData(0x00);
    WriteData(0x1B);
 
    WriteCommand(SPFD5408_SLEEPOUT);
    WriteData(0);
 
    WriteCommand(SPFD5408_DISPLAYON);
    WriteData(0);
}

void setAddrWindow(int x1, int y1, int x2, int y2) {
    pinCS = ACTIVE;
    wait_us(TEMPS);
    WriteCommand(SPFD5408_COLADDRSET);
    WriteData(x1 >> 8);
    WriteData(x1);
    WriteData(x2 >> 8);
    WriteData(x2);
    wait_us(TEMPS);
    pinCS = IDLE;

    pinCS = ACTIVE;
    wait_us(TEMPS);
    WriteCommand(SPFD5408_PAGEADDRSET);
    WriteData(y1 >> 8);
    WriteData(y1);
    WriteData(y2 >> 8);
    WriteData(y2);
    wait_us(TEMPS);
    pinCS = IDLE;
}

void fillRect(uint16_t x1, uint16_t y1, uint16_t w, uint16_t h, uint16_t fillcolor) {
    uint8_t hi, lo;
    uint16_t  x2, y2;
    uint16_t i, j;

    x2 = x1 + w - 1;
    y2 = y1 + h - 1;
    setAddrWindow(x1, y1, x2, y2);

    hi = fillcolor >> 8;
    lo = fillcolor;

    pinCS = ACTIVE;

    WriteCommand(SPFD5408_MEMORYWRITE);
    pinCD = DATA;
    
    for (i = h; i > 0; i--)
    {
        for (j = w; j > 0; j--)

        {
            pinWR = ACTIVE;
            portTFT = hi;
            pinWR = IDLE;
            pinWR = ACTIVE;
            portTFT = lo;
            pinWR = IDLE;            
        }
    }
    
    
    pinCS = IDLE;
}

void drawLine(uint8_t orientation,uint16_t x1, uint16_t y1, uint16_t lenght, uint16_t fillcolor) {
    uint8_t hi, lo;
    uint16_t  x2, y2;
    uint16_t i, j;
    
    if(orientation == VERT_LINE)
    {
        x2 = x1 - 1;
        y2 = y1 + lenght - 1;
    }
    else if(orientation == HORI_LINE)
    {
        x2 = x1 + lenght - 1;
        y2 = y1 - 1;
    }
    setAddrWindow(x1, y1, x2, y2);

    hi = fillcolor >> 8;
    lo = fillcolor;

    pinCS = ACTIVE;

    WriteCommand(SPFD5408_MEMORYWRITE);
    pinCD = DATA;
    
    for (i = lenght; i > 0; i--)
    {
        pinWR = ACTIVE;
        portTFT = hi;
        pinWR = IDLE;
        pinWR = ACTIVE;
        portTFT = lo;
        pinWR = IDLE;            
    
    }
    
    
    pinCS = IDLE;
}


void drawPixel(uint16_t x1, uint16_t y1, uint16_t fillcolor) {
    uint8_t hi, lo;
    uint16_t  x2, y2;
    
    x2 = x1 - 1;
    y2 = y1 - 1;
    
    setAddrWindow(x1, y1, x2, y2);

    hi = fillcolor >> 8;
    lo = fillcolor;

    pinCS = ACTIVE;

    WriteCommand(SPFD5408_MEMORYWRITE);
    pinCD = DATA;
    
//    for (i = 1; i > 0; i--)
//    {
        pinWR = ACTIVE;
        portTFT = hi;
        pinWR = IDLE;
        pinWR = ACTIVE;
        portTFT = lo;
        pinWR = IDLE;            
    //
//    }
//    
    
    pinCS = IDLE;
}
void draw_text_korn(uint64_t rttd,int x_k=100,int y_k=100)
{
    for(int i=0;i<8;i++)
    {for(int j=0;j<8;j++)
    {
        if( ( (rttd>>(i*8+j)) &0x01)==1){drawPixel(i*3+x_k,-1*2*j+y_k,GREEN);}
        }
    }
}
void korn_text(char ttd,int y_k,int x_k)//important note x is y, y is x
{
    const uint64_t IMAGES[] = {
  0x6666667e66663c00,
  0x3e66663e66663e00,
  0x3c66060606663c00,
  0x3e66666666663e00,
  0x7e06063e06067e00,
  0x0606063e06067e00,
  0x3c66760606663c00,
  0x6666667e66666600,
  0x3c18181818183c00,
  0x1c36363030307800,
  0x66361e0e1e366600,
  0x7e06060606060600,
  0xc6c6c6d6feeec600,
  0xc6c6e6f6decec600,
  0x3c66666666663c00,
  0x06063e6666663e00,
  0x603c766666663c00,
  0x66361e3e66663e00,
  0x3c66603c06663c00,
  0x18181818185a7e00,
  0x7c66666666666600,
  0x183c666666666600,
  0xc6eefed6c6c6c600,
  0xc6c66c386cc6c600,
  0x1818183c66666600,
  0x7e060c1830607e00,
  0x0000000000000000,
  0x7c667c603c000000,
  0x3e66663e06060600,
  0x3c6606663c000000,
  0x7c66667c60606000,
  0x3c067e663c000000,
  0x0c0c3e0c0c6c3800,
  0x3c607c66667c0000,
  0x6666663e06060600,
  0x3c18181800180000,
  0x1c36363030003000,
  0x66361e3666060600,
  0x1818181818181800,
  0xd6d6feeec6000000,
  0x6666667e3e000000,
  0x3c6666663c000000,
  0x06063e66663e0000,
  0xf0b03c36363c0000,
  0x060666663e000000,
  0x3e403c027c000000,
  0x1818187e18180000,
  0x7c66666666000000,
  0x183c666600000000,
  0x7cd6d6d6c6000000,
  0x663c183c66000000,
  0x3c607c6666000000,
  0x3c0c18303c000000,
  
  0x0000000000000000,0x7c667c603c000000,0x3e66663e06060600,0x3c6606663c000000,0x3c607c66667c0000,
  0x7c66667c60606000,0x3c067e663c000000,0x0c0c3e0c0c6c3800,0x6666663e06060600,0x3c18181800180000,
  0x1c36363030003000,0x66361e3666060600,0x1818181818181800,0xd6d6feeec6000000,0x6666667e3e000000,
  0x3c6666663c000000,0x06063e66663e0000,0xf0b03c36363c0000,0x060666663e000000,0x3e403c027c000000,
  0x1818187e18180000,0x7c66666666000000,0x183c666600000000,0x7cd6d6d6c6000000,0x663c183c66000000,
  0x3c607c6666000000,0x3c0c18303c000000
};
    /*switch(ttd)
    {
        case 'F':
            draw_text_korn(0x0606063e06067e00);
            break;
        }*/
        draw_text_korn(IMAGES[ttd-'A'],x_k,480-y_k);
    }
void korn_text_string(char st[15])
{int x_s=100,y_s=100;
    for(int sz=0;sz<15;st++)
    {
        korn_text(st[sz],x_s,y_s);
        x_s+=16;
        }
    }
    
/*cam part*/
bool cap=1;
uint8_t image[76800];
uint32_t pix_count;
bool read=1;
void read_to_image(){
    pix_count = 0;
    read=1;
    while(pix_count<76800&&read){
        read_state=!read_state;
        if(cam.readable()) {
            image[pix_count++]=cam.getc();
        }
    }
    read_state=0;
}

void set_cap(){cap = 1;}
void end_read(){read = 0;}
long map(long x, long in_min, long in_max, long out_min, long out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}
uint16_t P2RGB(uint8_t val){
    uint8_t bits_5=val/8;
    uint8_t bits_6=val/4;
    uint16_t rgb= bits_5<<11|bits_6<<5|bits_5;
    return rgb;
}

int main()
{
    
    pc.baud(1000000);
    cam.baud(1000000);
    esp.baud(1000000);
    frame_start.fall(&read_to_image); 
    frame_start.rise(&end_read); 
    ccap.fall(&set_cap); 
    begin();
    //drawLine(VERT_LINE,0, 20, 60,GREEN );
    //drawLine(HORI_LINE,30, 10, 20, RED);
    drawPixel(100,100,RED);
    drawPixel(200,200,'H');
    fillRect(20, 100, 15,15, 0); //ซ้ายบน
    fillRect(30, 110, 15,15, RED);
    fillRect(40, 120, 15,15, RED);
    fillRect(50, 130, 15,15, RED);
    fillRect(60, 140, 15,15, RED);
    
    fillRect(20, 90, 15,15, RED);//ขวาบน
    fillRect(30, 80, 15,15, RED);
    fillRect(40, 70, 15,15, RED);
    fillRect(50, 60, 15,15, RED);
    fillRect(60, 50, 15,15, RED);
    
    fillRect(70, 140, 15,15, RED); //ซ้ายล่าง
    fillRect(80, 130, 15,15, RED);
    fillRect(90, 120, 15,15, RED);
    fillRect(100, 110, 15,15, RED);
    fillRect(110, 100, 15,15, RED); 
    
    fillRect(70, 50, 15,15, RED); //ขวาล่าง
    fillRect(80, 60, 15,15, RED);
    fillRect(90, 70, 15,15, RED);
    fillRect(100, 80, 15,15, RED);
    fillRect(110, 90, 15,15, RED);
    while(1)
    {
     //setRotation(3);
     korn_text_string("SFRDHTRTSYSTEM");
     korn_text_string("SFDSFDGSTEM");
     int yh=0;
     for(int y=0;y<240;y++){
         for (int x=0;x<480;x++){
             drawPixel(320-yh,480-x,P2RGB(image[(int)((x+y*480)/1.5)]));
        }
        if(y%3==0){
            yh++;
            for (int x=0;x<480;x++){
             drawPixel(320-yh,480-x,P2RGB(image[(int)((x+y*480)/1.5)]));
             
        }
        }
        yh++;
    }
    //korn_text_string("SF-SYSTEM");
    
    }
}
