#include "mbed.h"
RawSerial pc(SERIAL_TX, SERIAL_RX); //has to use rawserial ,serial too slow and has byte loss.
RawSerial cam(PA_11, PA_12);
DigitalOut read_state(LED1);
InterruptIn frame_start(PC_5);
uint8_t image[76800];
uint32_t pix_count;
bool reading;
void count_reset(){
    pix_count = 0;
    reading=!reading;
}
int main() {
    
    pc.baud(2000000);
    cam.baud(2000000);
    frame_start.fall(&count_reset); 
    while(1) {
        pix_count=0;
        while(pix_count<76800){
            if(cam.readable()) {
                image[pix_count++]=cam.getc();
            }
        }
        for(int u=0;u<76800;u++){
            pc.putc(image[u]);
        }
    }
}
