#include "mbed.h"

DigitalOut myled(LED1);
AnalogIn tempSensor(A0);  //set up A0 connected to temp sensor
Serial pc(SERIAL_TX, SERIAL_RX); //set up serial comms

float sensorValue;  //variable for sensor value
float temp;  //variable for temperature

int main() 
{
    ADC1->CR &= ~(1UL);        //disable AD
    ADC1->CR &= ~(1UL<<30);    //single ended calib
    ADC1->CR |= 1UL<<31;      //calibrate
    while(ADC1->CR == 1)      //wait for calibrate
    ADC1->CR |= 1UL;          //enable AD
    wait_ms(1);
 
 while(1)
 {
 sensorValue = tempSensor.read();   //read temp value
 
 float tempSum = 0;
 for(int i = 0; i<10; i++)
 {
 sensorValue = tempSensor.read(); 
 tempSum = tempSum+sensorValue;
 }
 temp = (tempSum/10)*330; 

 pc.printf("Temp is : %.1f ^C\r\n", temp);
 wait(2); //wait 2 second 
 }
}
