#include "mbed.h"
#include "C12832.h"
#include "moteur.h"
#include "emissionIR.h"

/* Déclaration des objets glogaux ***************************/

C12832 lcd(D11, D13, D12, D7, D10);

AnalogIn pot1(A0);
AnalogIn pot2(A1);

DigitalOut LED_rouge(D5,1);
DigitalOut LED_verte(D9,1);
//DigitalOut LED_bleue(D8,1); // NE PAS UTILISER LA LED BLEUE

DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
DigitalIn fire(D4);


// Détecteurs d'obstacles
AnalogIn IR_G(PB_1);AnalogIn IR_D(PC_2);  

DigitalIn   jack(PD_2);
DigitalIn bumpers(PB_7);
DigitalOut  LED(PA_13);

// Détecteur de zone blanche
BusIn Arrivee(PC_9,PC_10,PC_11,PC_12,PA_12,PA_14);

Serial uartWifi(SERIAL_TX, SERIAL_RX);
//Serial uartWifi(PA_9, PA_10);

/* Déclaration des variables globales ****************************************/


/* Définition des fonctions gérant la machine à états ************************/    
    
// définition des fonctions     
void gestionEtat(){    
    }
    
void gestionAction(){
    }

/******************************************************************************/
enum Machine_A_Etat
{
    Depart,Navigation,Arrive,Evitement,Rotation
};

int main() { 
    lcd.cls();
    lcd.locate(32,16);
    lcd.printf("Module ER2 : template");
    while(true){
        int iState=Depart;
        float distObsGauche=pot1.read();
        float distObsDroite=pot2.read();
        int SwitchBumpers=bumpers.read();
        int SwitchUp=up.read();
        int SwitchJack=jack.read();
        int SwitchFire=fire.read(); 
        int iFlag=0;
        /*wait(.5);  /*this time depends on the speed of the robot*/
        switch(iState){
            case Depart :
                if(iFlag==0) 
                {
                    LED_verte.write(1); 
                    LED_rouge.write(0);
                    initVariateurs();
                    iFlag=1;
                }
                if(SwitchJack==0||SwitchFire==1)
                    iState=Navigation;
                break;
            
            case Navigation : 
                LED_verte.write(0);
                LED_rouge.write(0);
                //No Yellow LED
                commandeMoteurs(50,50);
                if(distObsGauche<0.2||distObsDroite<0.2)/*0.2=20cm,0.4=40cm*/
                    iState=Rotation;
                else if((distObsGauche>0.2&&distObsGauche<0.4)||(distObsDroite>0.2&&distObsDroite<0.4))
                    iState=Evitement;
                else if(/*white tested||*/SwitchBumpers==1)
                    iState=Arrive;
                break;
            
            case Arrive :
                wait(.1);
                LED_rouge.write(0);
                LED_verte.write(!LED_verte.read());
                commandeMoteurs(0,0);
                if(SwitchUp==1)
                {
                    iState=Depart;
                    iFlag=0;
                }
                break;
            
            case Evitement :
                wait(.1);
                LED_rouge.write(1);
                LED_verte.write(0);
                if(distObsDroite>distObsGauche)
                    commandeMoteurs(100,0);/*turn right*/
                else
                    commandeMoteurs(0,100);/*turn left*/
                if(distObsGauche<0.2||distObsDroite<0.2)
                    iState=Rotation;
                else if(distObsGauche>0.4&&distObsDroite>0.4)
                    iState=Navigation;
                else if(/*white tested||*/SwitchBumpers==1)
                iState=Arrive;
                break;
            
            case Rotation :
                LED_verte.write(0);
                LED_rouge.write(!LED_rouge.read());
                if(distObsDroite>distObsGauche)
                    commandeMoteurs(100,0);/*turn right*/
                else
                    commandeMoteurs(0,100);/*turn left*/
                if(distObsGauche>0.4&&distObsDroite>0.4)
                    iState=Navigation;
                if(/*white tested||*/SwitchBumpers==1)
                    iState=Arrive;
                if(distObsGauche>0.4&&distObsDroite>0.4)
                    iState=Navigation;
                else if(/*white tested||*/SwitchBumpers==1)
                    iState=Arrive;
                break;
            }//switch        
        
        }//while
  }  