    /******************************************************************
    * Code utilisé en ER1 pour commander les moteurs                 
    *******************************************************************/
        
    #include "moteur.h"
   
    DigitalOut enbMot(PB_12);  //enable moteurs
    //Moteur droit
    PwmOut sens1M1(PA_11);
    PwmOut sens2M1(PB_15);
    //moteur gauche
    PwmOut sens1M2(PB_14);
    PwmOut sens2M2(PB_13);

    void initVariateurs(void)
    {
        sens1M1.period_us(50);
        sens2M1.period_us(50);
        sens1M2.period_us(50);
        sens2M2.period_us(50);
        enbMot=1;   
    }
    
    void commandeMoteurs(int moteurG, int moteurD)
    {
        float mG, mD;
        //gestion des pulses minimum sur les PWM
        if (moteurG>=95) moteurG=100;
        else if (moteurG<=-95)moteurG=-100;
        else if (moteurG>=-5 && moteurG<=5) moteurG=0;
        if (moteurD>=95) moteurD=100;
        else if (moteurD<=-95)moteurD=-100;
        else if (moteurD>=-5 && moteurD<=5) moteurD=0;
        //gestion des signaux de commande
        if (moteurG>=0)
        {
            mG=(float)moteurG/100;
            sens1M1=mG;
            sens2M1=0;       
        }
        else
        {
            mG=(float)moteurG*(-1)/100;
            sens1M1=0;
            sens2M1=mG;
        }
        if (moteurD>=0)
        {
            mD=(float)moteurD/100;
            sens1M2=mD;
            sens2M2=0;       
        }
        else
        {
            mD=(float)moteurD*(-1)/100;
            sens1M2=0;
            sens2M2=mD;
        }
    }