//#include "mbed.h"
#include "TFC.h"
#include <iostream>
#include <stdio.h>
//#include "serialib.h"

const float AGGRESSIVE2 = .43;
const float AGGRESSIVE = .40;
const float MODERATE =.35;
const float CONSERVATIVE =.30;
const float STOP =0;
const float PROTECTION_THRESHOLD_UPPER =.7;
const float PROTECTION_THRESHOLD_LOWER =-.7;
const float TURN_FORWARD_ACCEL =0.045;
const float TURN_BACKWARD_ACCEL =0.025;
const float SERVO_CAN_MOVE_IN_ONE_FRAME =0.1;
const float SERVO_MAX =.5;

const int BLACK_THRESHOLD =63;
const int LINE_SCAN_LENGTH =128;


DigitalOut myled(LED1);

int main()
{
    //run this before anything
    TFC_Init();

    //variables
    float current_left_motor_speed = 0;
    float current_right_motor_speed = 0;
    
    // gains on prop, int, der
    // subject to change, need to fine tune
    
    bool rear_motor_enable_flag = true;
    bool linescan_ping_pong = false;
    bool linescan_enable = true;

    int black_values_list0[LINE_SCAN_LENGTH];
    int black_value_count0 = 0;
    int black_values_list1[LINE_SCAN_LENGTH];
    int black_value_count1 = 0;

    int violence_level = 0;
    int sum_black0 = 0;
    int sum_black1 = 0;

    
    int center_now0;
    int center_now1;
    
    float left_counter  =0;
    float right_counter =0;
    bool turn_left=false;
    bool turn_right=false;

    float bullshit_offset = .08;
    
    int num_of_straight =0;

    int avg_value0=0;
    int avg_value1=0;
    //int black_threshhold=0;
    //int black_threshhold =450;
    int black_threshhold0 =600*(TFC_ReadPot(0));
    int black_threshhold1 =600*(TFC_ReadPot(0));

    // major loop
    while(1) {

        // initial motor stuff
        if(rear_motor_enable_flag) {
            TFC_HBRIDGE_ENABLE;

            // checking behavior level
            violence_level =  int(TFC_GetDIP_Switch());

            
            if (violence_level==4) {
                current_left_motor_speed  = -(AGGRESSIVE2);
                current_right_motor_speed = AGGRESSIVE2;
            }
            if (violence_level==3) {
                current_left_motor_speed  = -(AGGRESSIVE);
                current_right_motor_speed = AGGRESSIVE;
            }
            else if (violence_level==2) {
                current_left_motor_speed  = -(MODERATE);
                current_right_motor_speed = (MODERATE);
            }
            else if (violence_level==1) {
                current_left_motor_speed  = -(CONSERVATIVE);
                current_right_motor_speed = CONSERVATIVE;
            }
            else if (violence_level==0) {
                current_left_motor_speed  = STOP;
                current_right_motor_speed = STOP;
            }
            else {
                current_left_motor_speed  = STOP;
                current_right_motor_speed = STOP;
            }
            
            // protection block
            if(current_left_motor_speed >= PROTECTION_THRESHOLD_UPPER)
                current_left_motor_speed= PROTECTION_THRESHOLD_UPPER;
            if(current_right_motor_speed >= PROTECTION_THRESHOLD_UPPER)
                current_right_motor_speed = PROTECTION_THRESHOLD_UPPER;
            if(current_left_motor_speed <= PROTECTION_THRESHOLD_LOWER)
                current_left_motor_speed = PROTECTION_THRESHOLD_LOWER;
            if(current_right_motor_speed <= PROTECTION_THRESHOLD_LOWER)
                current_right_motor_speed = PROTECTION_THRESHOLD_LOWER;

            TFC_SetMotorPWM(current_left_motor_speed, current_right_motor_speed);
        }// end motor enabled
        else {
            TFC_HBRIDGE_DISABLE;
        }// end motor disabled

        // camera stuff
        if (linescan_enable) {
            if (TFC_LineScanImageReady !=0) {

                if (linescan_ping_pong) {
                    //checking channel 0
                    
                    
                    // checking for center line (single line)
                    for (uint16_t i=10; i<118; i++) 
                    {
                        if ((*(TFC_LineScanImage0+i) < black_threshhold0)) {
                            black_values_list0[black_value_count0] = i;
                            black_value_count0++;
                            //black_list_one++;
                            avg_value0 +=(*(TFC_LineScanImage0+i));
                        }
                    }
                    
                    
                    for (uint16_t i=10; i<118; i++) 
                    {
                        if ((*(TFC_LineScanImage1+i) < black_threshhold1)) {
                            black_values_list1[black_value_count1] = i;
                            black_value_count1++;
                            //black_list_one++;
                            avg_value1 +=(*(TFC_LineScanImage1+i));
                        }
                    }
                    

                    for(int i=0; i<black_value_count0; i++) 
                    {
                        sum_black0 += black_values_list0[i];
                    }
                    
                    for(int i=0; i<black_value_count1; i++) 
                    {
                        sum_black1 += black_values_list1[i];
                    }
                    

                    if (black_value_count0 > 4)
                    {
                        black_threshhold0 = avg_value0 / black_value_count0;
                        black_threshhold0 +=50;
                    }
                    
                    if (black_value_count1 > 4)
                    {
                        black_threshhold1 = avg_value1 / black_value_count1;
                        black_threshhold1 +=50;
                    }
                    
     
                    //if (black_value_count>2)
                    center_now0 = sum_black0 / black_value_count0;
                    center_now1 = sum_black1 / black_value_count1;
                    
                    uint8_t num0 = 0;
                    uint8_t num1 = 0;
                    
                    if(center_now0 > 10 && center_now0 < 19) // turn right little
                        num0 = 1;
                    else if(center_now0 >= 19 && center_now0 < 39)// moderate right
                        num0 = 2;
                    else if(center_now0 >= 39 && center_now0 < 62)// snap right
                        num0 = 3;
                    else if(center_now0 >= 62 && center_now0 < 65) // center do nothing
                        num0 = 4;
                    else if(center_now0 >= 65 && center_now0 < 89)// snap left
                        num0 = 5;
                    else if(center_now0 >=89 && center_now0 < 109) // moderate left
                        num0 = 6;
                    else if(center_now0 >= 109 && center_now0 < 118) // turn left little
                        num0 = 7;
                        
                    if(center_now1 > 10 && center_now1 < 19) // turn right little
                        num1 = 8;
                    else if(center_now1 >= 19 && center_now1 < 39)// moderate right
                        num1 = 9;
                    else if(center_now1 >= 39 && center_now1 < 62)// snap right
                        num1 = 10;
                    else if(center_now1 >= 62 && center_now1 < 65) // center do nothing
                        num1 = 11;
                    else if(center_now1 >= 65 && center_now1 < 89)// snap left
                        num1 = 12;
                    else if(center_now1 >=89 && center_now1 < 109) // moderate left
                        num1 = 13;
                    else if(center_now1 >= 109 && center_now1 < 118) // turn left little
                        num1 = 14;    
                        
                    //else
                      //  num = 0;
                    
                    if (black_value_count0<2 )
                        num0 = 0;
                    if (black_value_count1<2)
                        num1=15;
                        
                    
                    
                    if (num0==0 and num1==15)
                    {
                        turn_right = false; 
                        turn_left = false;
                        TFC_SetBatteryLED(9);
                    }
                    
                    else if (num0==0)
                    {
                        turn_right = false; 
                        turn_left = false;
                        TFC_SetBatteryLED(8);
                    }
                    
                    else if (num0==1)
                    {
                        turn_right = false; 
                        turn_left = false;
                        TFC_SetBatteryLED(12);
                    }
                    
                    else if (num1==14)
                    {
                        turn_right = false; 
                        turn_left = false;
                        TFC_SetBatteryLED(2);
                    }
                    
                    else if (num1==15)
                    {
                        turn_right = false; 
                        turn_left = false;
                        TFC_SetBatteryLED(1);
                    }
     
                    
                    else if (num0==2)
                    {
                        turn_left=false;
                        turn_right=true;
                        if (right_counter <.15)
                            right_counter =.15; // less drastic for outside parts
                        TFC_SetBatteryLED(12);
                    }
                    
                    else if (num0==3)
                    {
                        turn_left=false;
                        turn_right=true;
                        if (right_counter <.2)
                            right_counter =.2; // less drastic for outside parts
                        TFC_SetBatteryLED(4);
                    }
                    
                    else if (num0==4)
                    {
                        turn_left=false;
                        turn_right=true;
                        if (right_counter <.3)
                            right_counter =.3; // less drastic for outside parts
                        TFC_SetBatteryLED(4);
                    }
                    
                    else if (num1==11)
                    {
                        turn_left=true;
                        turn_right=false;
                        if (left_counter >-.3)
                            left_counter =-.3; // less drastic for outside parts
                        TFC_SetBatteryLED(3);
                    }
                    
                    else if (num1==12)
                    {
                        turn_left=true;
                        turn_right=false;
                        if (left_counter >-.2)
                            left_counter =-.2; // less drastic for outside parts
                        TFC_SetBatteryLED(3);
                    }
                    
                    else if (num1==13)
                    {
                        turn_left=true;
                        turn_right=false;
                        if (left_counter >-.15)
                            left_counter =-.15; // less drastic for outside parts
                        TFC_SetBatteryLED(2);
                    }

                    //straight
                if (turn_right == false and turn_left == false)
                    {
                        //TFC_SetServo(0,(0.0+ bullshit_offset));
                        TFC_SetServo(0,bullshit_offset);
                        TFC_SetMotorPWM(current_left_motor_speed-(.0008*num_of_straight), current_right_motor_speed+(.0008*num_of_straight)); // --left is faster, ++right is faster
                        if (violence_level !=0)
                            num_of_straight++;
                    }
                   
                    else
                    {
                    }
                    
                    //dealwiththeshit
                    if(turn_left)
                    {
                        turn_right = false;
                        num_of_straight = 0; // no longer on a straight
                        
                        if (violence_level == 2 or violence_level == 1)
                            TFC_SetServo(0,left_counter+ bullshit_offset );
                        if (violence_level == 3 or violence_level == 4)
                            TFC_SetServo(0,(left_counter+ bullshit_offset)*.8 );
                        
                        //TFC_SetServo(0,left_counter);
                        left_counter += .01;
                        if (left_counter > (0+ bullshit_offset))
                            turn_left = false;
                            
                            TFC_SetMotorPWM(current_left_motor_speed+(.2*left_counter), current_right_motor_speed+(.2*left_counter));  // ++left is slower, ++right is faster
                            
                        }
                        
                    if(turn_right)
                    {
                        turn_left =false;
                        num_of_straight = 0; // no longer on a straight
                        
                        //TFC_SetServo(0,right_counter- bullshit_offset );
                        //TFC_SetServo(0,right_counter);
                        
                        if (violence_level == 2 or violence_level == 1)
                            TFC_SetServo(0,(right_counter+ bullshit_offset));
                        if (violence_level == 3 or violence_level == 4)
                            TFC_SetServo(0,(right_counter+ bullshit_offset)*.8 );            
                        
                        right_counter -= .01;
                        if (right_counter < (0+ bullshit_offset))
                            turn_right = false;
                        
                        TFC_SetMotorPWM(current_left_motor_speed-(.2*right_counter), current_right_motor_speed-(.2*right_counter)); // --left is faster, --right is slower       
                        }   

                    // clearing values for next image processing round
                    black_value_count0 = 0;
                    sum_black0 = 0;
                    avg_value0=0;
                    
                    black_value_count1 = 0;
                    sum_black1 = 0;
                    avg_value1=0;
                    

                    // end image processing

                    linescan_ping_pong = false;
                } // end checking channel 0
                
                else { //checking channel 1
                    linescan_ping_pong = true;
                }

                TFC_LineScanImageReady = 0;  // since we used it, we reset the flag
            }// end imageready
        }// end linescan stuff
    }
}

// shit code down here
