#include "mbed.h"
#include "TextLCD.h"
#include "Servo.h"

#define PIN_LCD_4 PB_8
#define PIN_LCD_6 PB_9
#define PIN_LCD_11 PA_10
#define PIN_LCD_12 PB_3
#define PIN_LCD_13 PB_5
#define PIN_LCD_14 PB_4

#define PIN_SERVO_ORANGE PA_15

#define PIN_LED_COFFEE /* first */  PC_4, PB_13, PB_14, PB_15, PB_1, PB_2, PB_12, PA_11, PA_12, PC_5, \
                       /* second */ PC_6, PC_8, PC_9, PB_10, PA_8, PA_9,PC_7, PB_6, PA_7, PA_6
#define PIN_LED_WATER  PC_0, PC_1, PB_0, PA_4, PA_1, PA_0
#define PIN_LED_COCOA  PC_3, PC_2, PH_1, PH_0, PC_15
#define PIN_LED_MILK   PC_14, PB_7, PA_14

#define PIN_BUTTON_AMERICANO PC_10
#define PIN_BUTTON_CHOCO PC_11
#define PIN_BUTTON_ESPRESSO PC_12
#define PIN_BUTTON_LATTE PD_2
#define PIN_BUTTON_MOCCO PA_13

#define PIN_SWITCH PC_13 /* same as USER_BUTTON */

#define SERVO_POS_A 544  /* 544-2400 */
#define SERVO_POS_B 2400  /* 544-2400 */

TextLCD lcd(PIN_LCD_4, PIN_LCD_6, PIN_LCD_11, PIN_LCD_12, PIN_LCD_13, PIN_LCD_14); // rs, e, d4-d7
DigitalIn latte_button(PIN_BUTTON_LATTE, PullUp);
DigitalIn mocco_button(PIN_BUTTON_MOCCO, PullUp);
DigitalIn americano_button(PIN_BUTTON_AMERICANO, PullUp);
DigitalIn choco_button(PIN_BUTTON_CHOCO, PullUp);
DigitalIn espresso_button(PIN_BUTTON_ESPRESSO, PullUp);
DigitalIn type_switch(PIN_SWITCH, PullDown);

DigitalOut led[34] = {PIN_LED_COFFEE, PIN_LED_COCOA, PIN_LED_MILK, PIN_LED_WATER};
Servo servo(PIN_SERVO_ORANGE);

#define COFFEE 0
#define COCOA 1
#define MILK 2
#define WATER 3

#define MAX_COFFEE 20
#define MAX_COCOA 5
#define MAX_MILK 3
#define MAX_WATER 6

int left[4];

void show_leds() {
    int i;
    for (i = 0; i < MAX_COFFEE; i++) {
        led[0 + i] = (i + 1 <= left[COFFEE]);
    }
    for (i = 0; i < MAX_COCOA; i++) {
        led[MAX_COFFEE + i] = (i + 1 <= left[COCOA]);
    }
    for (i = 0; i < MAX_MILK; i++) {
        led[MAX_COFFEE + MAX_COCOA + i] = (i + 1 <= left[MILK]);
    }
    for (i = 0; i < MAX_WATER; i++) {
        led[MAX_COFFEE + MAX_COCOA + MAX_MILK + i] = (i + 1 <= left[WATER]);
    }
}

void reset() {
    int n = type_switch;
    //lcd.printf("type %d\n", n);
    if (0/*type_switch == 0*/) {
        left[COFFEE] = 15;
        left[COCOA] = 5;
        left[MILK] = 3;
        left[WATER] = 5;
    } else {
        left[COFFEE] = 20;
        left[COCOA] = 4;
        left[MILK] = 2;
        left[WATER] = 6;
    }
    show_leds();
    servo.Enable(SERVO_POS_A, 20000);
    wait(1);
    lcd.cls();
    lcd.printf("B\xC3\xB2""ep\xB8\xBF""e \xBD""a\xBE\xB8\xBFo\xBA");
    //lcd.printf("B"/*\xC3\xB2""ep\xB8\xBF""e \xBD""a\xBE\xB8\xBFo\xBA"*/);
}

void drop_key() {
    servo.SetPosition(SERVO_POS_B);
    wait(1);
}

void try_drink(int ing0, int ing1, int ing2, int ing3) {
   wait(0.5);
   if (left[COFFEE] >= ing0 && left[COCOA] >= ing1 && left[MILK] >= ing2 && left[WATER] >= ing3) {
       left[COFFEE] -= ing0;
       left[COCOA] -= ing1;
       left[MILK] -= ing2;
       left[WATER] -= ing3;
       show_leds();
       lcd.cls();
       if (left[COFFEE] || left[COCOA] || left[MILK] || left[WATER]) {
           lcd.printf("\xA4""a\xBA""a\xB7 c\xE3""e\xBB""a\xBD \xBD""e \xBEo\xBB\xBDoc\xBF\xC4\xC6\n");
       } else {
           lcd.printf("\n\xA4""a\xBA""a\xB7 c\xE3""e\xBB""a\xBD\n");
           drop_key();
           reset();
       }
   }
} 

int main() {
    int was_americano = 1, was_latte = 1, was_mocco = 1, was_choco = 1, was_espresso = 1;
    int now_americano, now_latte, now_mocco, now_choco, now_espresso;
    reset();
    while (1) {
        now_americano = americano_button;
        now_latte = latte_button;
        now_mocco = mocco_button;
        now_choco = choco_button;
        now_espresso = espresso_button;
        if (!was_americano && now_americano) {
            //try_drink(4, 0, 0, 2);
            try_drink(1, 0, 0, 1);
        } else if (!was_latte && now_latte) {
            //try_drink(2, 0, 1, 0);
            try_drink(1, 0, 1, 0);
        } else if (!was_mocco && now_mocco) {
            //try_drink(3, 1, 0, 0);
            try_drink(2, 2, 1, 1);
        } else if (!was_choco && now_choco) {
            //try_drink(0, 2, 1, 0);
            try_drink(0, 3, 1, 0);
        } else if (!was_espresso && now_espresso) {
            //try_drink(2, 0, 0, 1);
            try_drink(5, 0, 0, 1);
        }
        was_americano = now_americano;
        was_latte = now_latte;
        was_espresso = now_espresso;
        was_mocco = now_mocco;
        was_choco = now_choco;
        wait(0.05);
    }
}