#include "mbed.h"
#include "rtos.h"

PwmOut servo1(p25);
PwmOut servo2(p24);

// Threads
void bpc_func(void const *args);
Thread * bpc_thread;

float dty_servo_open = 0.1125;  // PCT [3.75-11.25]
float dty_servo_close = 0.0375; // PCT [3.75-11.25]
float period = 0.02;    // sec

AnalogIn Button(p15);       // elevator button press Voltage = 3.3*0.2*n ; n = Floor Number


int main() {

    servo1.period(period);
    servo2.period(period);
    bpc_thread = new Thread(bpc_func); // start button checker thread
    
    
    while(1) {

    }
}

void bpc_func(void const *args) {
    while (1) {
        float ADC_val = Button.read(); 
        int val = ADC_val*10;
        if(val == 2) {
            // blah
        } else if(val == 4) {
            // blah
        } else if(val == 6) {
            // blah
        } else if(val == 8) {
            servo1.write(dty_servo_open);
            servo2.write(dty_servo_open);
        } else if(val == 10) {
            servo1.write(dty_servo_close);
            servo2.write(dty_servo_close);
        }
        wait(0.1);
    }
}
